/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import org.jabref.gui.libraryproperties.AbstractPropertiesTabView;
import org.jabref.gui.libraryproperties.LibraryPropertiesViewModel;
import org.jabref.gui.libraryproperties.PropertiesTab;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ControlHelper;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;

public class LibraryPropertiesView
extends BaseDialog<LibraryPropertiesViewModel> {
    @FXML
    private TabPane tabPane;
    @FXML
    private ButtonType saveButton;
    @Inject
    private ThemeManager themeManager;
    private final BibDatabaseContext databaseContext;
    private LibraryPropertiesViewModel viewModel;

    public LibraryPropertiesView(BibDatabaseContext databaseContext) {
        this.databaseContext = databaseContext;
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        ControlHelper.setAction(this.saveButton, this.getDialogPane(), event -> this.savePreferencesAndCloseDialog());
        if (databaseContext.getDatabasePath().isPresent()) {
            this.setTitle(Localization.lang("%0 - Library properties", databaseContext.getDatabasePath().get().getFileName()));
        } else {
            this.setTitle(Localization.lang("Library properties", new Object[0]));
        }
        this.themeManager.updateFontStyle(this.getDialogPane().getScene());
    }

    @FXML
    private void initialize() {
        this.viewModel = new LibraryPropertiesViewModel(this.databaseContext);
        for (PropertiesTab pane : this.viewModel.getPropertiesTabs()) {
            ScrollPane scrollPane = new ScrollPane(pane.getBuilder());
            scrollPane.setFitToHeight(true);
            scrollPane.setFitToWidth(true);
            this.tabPane.getTabs().add((Object)new Tab(pane.getTabName(), (Node)scrollPane));
            if (!(pane instanceof AbstractPropertiesTabView)) continue;
            AbstractPropertiesTabView propertiesTab = (AbstractPropertiesTabView)pane;
            propertiesTab.prefHeightProperty().bind((ObservableValue)this.tabPane.tabMaxHeightProperty());
            propertiesTab.prefWidthProperty().bind((ObservableValue)this.tabPane.widthProperty());
            propertiesTab.getStyleClass().add((Object)"propertiesTab");
        }
        this.viewModel.setValues();
    }

    private void savePreferencesAndCloseDialog() {
        this.viewModel.storeAllSettings();
        this.close();
    }
}

