/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties.general;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import java.nio.charset.Charset;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import org.jabref.gui.libraryproperties.AbstractPropertiesTabView;
import org.jabref.gui.libraryproperties.general.GeneralPropertiesViewModel;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.preferences.PreferencesService;

public class GeneralPropertiesView
extends AbstractPropertiesTabView<GeneralPropertiesViewModel> {
    @FXML
    private ComboBox<Charset> encoding;
    @FXML
    private ComboBox<BibDatabaseMode> databaseMode;
    @FXML
    private TextField generalFileDirectory;
    @FXML
    private TextField userSpecificFileDirectory;
    @FXML
    private TextField laTexFileDirectory;
    @Inject
    private PreferencesService preferencesService;

    public GeneralPropertiesView(BibDatabaseContext databaseContext) {
        this.databaseContext = databaseContext;
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("General", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new GeneralPropertiesViewModel(this.databaseContext, this.dialogService, this.preferencesService);
        new ViewModelListCellFactory().withText(Charset::displayName).install(this.encoding);
        this.encoding.disableProperty().bind((ObservableValue)((GeneralPropertiesViewModel)this.viewModel).encodingDisableProperty());
        this.encoding.itemsProperty().bind(((GeneralPropertiesViewModel)this.viewModel).encodingsProperty());
        this.encoding.valueProperty().bindBidirectional(((GeneralPropertiesViewModel)this.viewModel).selectedEncodingProperty());
        new ViewModelListCellFactory().withText(BibDatabaseMode::getFormattedName).install(this.databaseMode);
        this.databaseMode.itemsProperty().bind(((GeneralPropertiesViewModel)this.viewModel).databaseModesProperty());
        this.databaseMode.valueProperty().bindBidirectional(((GeneralPropertiesViewModel)this.viewModel).selectedDatabaseModeProperty());
        this.generalFileDirectory.textProperty().bindBidirectional((Property)((GeneralPropertiesViewModel)this.viewModel).generalFileDirectoryPropertyProperty());
        this.userSpecificFileDirectory.textProperty().bindBidirectional((Property)((GeneralPropertiesViewModel)this.viewModel).userSpecificFileDirectoryProperty());
        this.laTexFileDirectory.textProperty().bindBidirectional((Property)((GeneralPropertiesViewModel)this.viewModel).laTexFileDirectoryProperty());
    }

    @FXML
    public void browseGeneralFileDirectory() {
        ((GeneralPropertiesViewModel)this.viewModel).browseGeneralDir();
    }

    @FXML
    public void browseUserSpecificFileDirectory() {
        ((GeneralPropertiesViewModel)this.viewModel).browseUserDir();
    }

    @FXML
    void browseLatexFileDirectory() {
        ((GeneralPropertiesViewModel)this.viewModel).browseLatexDir();
    }
}

