/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.libraryproperties.keypattern;

import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.commands.Command;
import jakarta.inject.Inject;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.commonfxcontrols.CitationKeyPatternsPanel;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.libraryproperties.AbstractPropertiesTabView;
import org.jabref.gui.libraryproperties.PropertiesTab;
import org.jabref.gui.libraryproperties.keypattern.KeyPatternPropertiesViewModel;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreferencesService;

public class KeyPatternPropertiesView
extends AbstractPropertiesTabView<KeyPatternPropertiesViewModel>
implements PropertiesTab {
    @FXML
    private Button keyPatternHelp;
    @FXML
    private CitationKeyPatternsPanel bibtexKeyPatternTable;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private BibEntryTypesManager bibEntryTypesManager;

    public KeyPatternPropertiesView(BibDatabaseContext databaseContext) {
        this.databaseContext = databaseContext;
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Citation key patterns", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new KeyPatternPropertiesViewModel(this.databaseContext, this.preferencesService);
        this.bibtexKeyPatternTable.patternListProperty().bindBidirectional(((KeyPatternPropertiesViewModel)this.viewModel).patternListProperty());
        this.bibtexKeyPatternTable.defaultKeyPatternProperty().bindBidirectional(((KeyPatternPropertiesViewModel)this.viewModel).defaultKeyPatternProperty());
        ActionFactory actionFactory = new ActionFactory();
        actionFactory.configureIconButton(StandardActions.HELP_KEY_PATTERNS, (Command)new HelpAction(HelpFile.CITATION_KEY_PATTERN, this.dialogService, this.preferencesService.getFilePreferences()), (ButtonBase)this.keyPatternHelp);
    }

    @Override
    public void setValues() {
        ((KeyPatternPropertiesViewModel)this.viewModel).setValues();
        this.bibtexKeyPatternTable.setValues(this.bibEntryTypesManager.getAllTypes(this.databaseContext.getMetaData().getMode().orElse(this.preferencesService.getLibraryPreferences().getDefaultBibDatabaseMode())), this.databaseContext.getMetaData().getCiteKeyPatterns(this.preferencesService.getCitationKeyPatternPreferences().getKeyPatterns()));
    }

    @FXML
    public void resetAllKeyPatterns() {
        this.bibtexKeyPatternTable.resetAll();
    }
}

