/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.linkedfile;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.linkedfile.DownloadLinkedFileAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.FilePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedownloadMissingFilesAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibraryTab.class);
    private final StateManager stateManager;
    private final DialogService dialogService;
    private final FilePreferences filePreferences;
    private final TaskExecutor taskExecutor;
    private BibDatabaseContext databaseContext;

    public RedownloadMissingFilesAction(StateManager stateManager, DialogService dialogService, FilePreferences filePreferences, TaskExecutor taskExecutor) {
        this.stateManager = stateManager;
        this.dialogService = dialogService;
        this.filePreferences = filePreferences;
        this.taskExecutor = taskExecutor;
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager));
    }

    public void execute() {
        if (this.stateManager.getActiveDatabase().isPresent()) {
            this.databaseContext = this.stateManager.getActiveDatabase().get();
            boolean confirm = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Redownload missing files", new Object[0]), Localization.lang("Redownload missing files for current library?", new Object[0]));
            if (!confirm) {
                return;
            }
            this.redownloadMissing(this.stateManager.getActiveDatabase().get());
        }
    }

    private void redownloadMissing(BibDatabaseContext databaseContext) {
        LOGGER.info("Redownloading missing files");
        databaseContext.getEntries().forEach(entry -> entry.getFiles().forEach(linkedFile -> {
            if (linkedFile.isOnlineLink() || linkedFile.getSourceUrl().isEmpty()) {
                return;
            }
            Optional<Path> path = FileUtil.find(this.databaseContext, linkedFile.getLink(), this.filePreferences);
            if (path.isPresent() && Files.exists(path.get(), new LinkOption[0])) {
                return;
            }
            String fileName = Path.of(linkedFile.getLink(), new String[0]).getFileName().toString();
            DownloadLinkedFileAction downloadAction = new DownloadLinkedFileAction(this.databaseContext, (BibEntry)entry, (LinkedFile)linkedFile, linkedFile.getSourceUrl(), this.dialogService, this.filePreferences, this.taskExecutor, fileName, true);
            downloadAction.execute();
        }));
    }
}

