/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import com.airhacks.afterburner.injection.Injector;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javax.swing.undo.UndoManager;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.DragAndDropDataFormats;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.edit.EditAction;
import org.jabref.gui.externalfiles.ImportHandler;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.MainTableColumnFactory;
import org.jabref.gui.maintable.MainTableDataModel;
import org.jabref.gui.maintable.MainTableHeaderContextMenu;
import org.jabref.gui.maintable.MainTablePreferences;
import org.jabref.gui.maintable.PersistenceVisualStateTable;
import org.jabref.gui.maintable.RightClickMenu;
import org.jabref.gui.maintable.SmartConstrainedResizePolicy;
import org.jabref.gui.maintable.columns.LibraryColumn;
import org.jabref.gui.maintable.columns.MainTableColumn;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.CustomLocalDragboard;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.gui.util.ViewModelTableRowFactory;
import org.jabref.logic.importer.FetcherClientException;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.FetcherServerException;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.event.EntriesAddedEvent;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.BibtexString;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.reactfx.util.TriConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainTable
extends TableView<BibEntryTableViewModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainTable.class);
    private final LibraryTab libraryTab;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final BibDatabaseContext database;
    private final MainTableDataModel model;
    private final ImportHandler importHandler;
    private final CustomLocalDragboard localDragboard;
    private final ClipBoardManager clipBoardManager;
    private final BibEntryTypesManager entryTypesManager;
    private final TaskExecutor taskExecutor;
    private final UndoManager undoManager;
    private long lastKeyPressTime;
    private String columnSearchTerm;

    public MainTable(MainTableDataModel model, LibraryTab libraryTab, LibraryTabContainer tabContainer, BibDatabaseContext database, PreferencesService preferencesService, DialogService dialogService, StateManager stateManager, KeyBindingRepository keyBindingRepository, ClipBoardManager clipBoardManager, BibEntryTypesManager entryTypesManager, TaskExecutor taskExecutor, FileUpdateMonitor fileUpdateMonitor) {
        this.libraryTab = libraryTab;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.database = Objects.requireNonNull(database);
        this.model = model;
        this.clipBoardManager = clipBoardManager;
        this.entryTypesManager = entryTypesManager;
        this.taskExecutor = taskExecutor;
        this.undoManager = libraryTab.getUndoManager();
        MainTablePreferences mainTablePreferences = preferencesService.getMainTablePreferences();
        this.importHandler = new ImportHandler(database, preferencesService, fileUpdateMonitor, this.undoManager, stateManager, dialogService, taskExecutor);
        this.localDragboard = stateManager.getLocalDragboard();
        this.setOnDragOver(this::handleOnDragOverTableView);
        this.setOnDragDropped(this::handleOnDragDroppedTableView);
        this.getColumns().addAll(new MainTableColumnFactory(database, preferencesService, preferencesService.getMainTableColumnPreferences(), this.undoManager, dialogService, stateManager, taskExecutor).createColumns());
        this.getColumns().removeIf(LibraryColumn.class::isInstance);
        new ViewModelTableRowFactory<BibEntryTableViewModel>().withOnMouseClickedEvent((entry, event) -> {
            if (event.getClickCount() == 2) {
                libraryTab.showAndEdit(entry.getEntry());
            }
        }).withContextMenu(entry -> RightClickMenu.create(entry, keyBindingRepository, libraryTab, dialogService, stateManager, preferencesService, this.undoManager, clipBoardManager, taskExecutor, (JournalAbbreviationRepository)Injector.instantiateModelOrService(JournalAbbreviationRepository.class), entryTypesManager)).setOnDragDetected((TriConsumer<TableRow<BibEntryTableViewModel>, BibEntryTableViewModel, MouseEvent>)((TriConsumer)this::handleOnDragDetected)).setOnDragDropped((TriConsumer<TableRow<BibEntryTableViewModel>, BibEntryTableViewModel, DragEvent>)((TriConsumer)this::handleOnDragDropped)).setOnDragOver((TriConsumer<TableRow<BibEntryTableViewModel>, BibEntryTableViewModel, DragEvent>)((TriConsumer)this::handleOnDragOver)).setOnDragExited((TriConsumer<TableRow<BibEntryTableViewModel>, BibEntryTableViewModel, DragEvent>)((TriConsumer)this::handleOnDragExited)).setOnMouseDragEntered((TriConsumer<TableRow<BibEntryTableViewModel>, BibEntryTableViewModel, MouseDragEvent>)((TriConsumer)this::handleOnDragEntered)).install(this);
        this.getSortOrder().clear();
        mainTablePreferences.getColumnPreferences().getColumnSortOrder().forEach(columnModel -> this.getColumns().stream().map(column -> (MainTableColumn)((Object)((Object)column))).filter(column -> column.getModel().equals(columnModel)).findFirst().ifPresent(column -> {
            LOGGER.debug("Adding sort order for col {} ", (Object)column);
            this.getSortOrder().add((Object)column);
        }));
        if (mainTablePreferences.getResizeColumnsToFit()) {
            this.setColumnResizePolicy(new SmartConstrainedResizePolicy());
        }
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setItems((ObservableList)model.getEntriesFilteredAndSorted());
        model.getEntriesFilteredAndSorted().comparatorProperty().bind((ObservableValue)this.comparatorProperty());
        this.getStylesheets().add((Object)MainTable.class.getResource("MainTable.css").toExternalForm());
        new PersistenceVisualStateTable(this, mainTablePreferences.getColumnPreferences()).addListeners();
        this.setupKeyBindings(keyBindingRepository);
        this.setOnKeyTyped(key -> {
            if (this.getSortOrder().isEmpty()) {
                return;
            }
            this.jumpToSearchKey((TableColumn<BibEntryTableViewModel, ?>)((TableColumn)this.getSortOrder().getFirst()), (KeyEvent)key);
        });
        database.getDatabase().registerListener((Object)this);
        MainTableColumnFactory rightClickMenuFactory = new MainTableColumnFactory(database, preferencesService, preferencesService.getMainTableColumnPreferences(), this.undoManager, dialogService, stateManager, taskExecutor);
        new MainTableHeaderContextMenu(this, rightClickMenuFactory, tabContainer, dialogService).show(true);
    }

    private void jumpToSearchKey(TableColumn<BibEntryTableViewModel, ?> sortedColumn, KeyEvent keyEvent) {
        if (keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.isShiftDown()) {
            return;
        }
        if (keyEvent.getCharacter() == null || sortedColumn == null) {
            return;
        }
        this.columnSearchTerm = System.currentTimeMillis() - this.lastKeyPressTime < 700L ? this.columnSearchTerm + keyEvent.getCharacter().toLowerCase() : keyEvent.getCharacter().toLowerCase();
        this.lastKeyPressTime = System.currentTimeMillis();
        this.getItems().stream().filter(item -> Optional.ofNullable(sortedColumn.getCellObservableValue(item).getValue()).map(Object::toString).orElse("").toLowerCase().startsWith(this.columnSearchTerm)).findFirst().ifPresent(item -> {
            this.scrollTo(item);
            this.clearAndSelect(item.getEntry());
        });
    }

    @Subscribe
    public void listen(EntriesAddedEvent event) {
        UiTaskExecutor.runInJavaFXThread(() -> this.clearAndSelect(event.getFirstEntry()));
    }

    public void clearAndSelect(BibEntry bibEntry) {
        this.getSelectionModel().clearSelection();
        this.findEntry(bibEntry).ifPresent(entry -> {
            this.getSelectionModel().select(entry);
            this.scrollTo(entry);
        });
    }

    public void copy() {
        List<BibEntry> selectedEntries = this.getSelectedEntries();
        if (!selectedEntries.isEmpty()) {
            List<BibtexString> stringConstants = this.getUsedStringValues(selectedEntries);
            try {
                if (stringConstants.isEmpty()) {
                    this.clipBoardManager.setContent(selectedEntries, this.entryTypesManager);
                } else {
                    this.clipBoardManager.setContent(selectedEntries, this.entryTypesManager, stringConstants);
                }
                this.dialogService.notify(Localization.lang("Copied %0 entry(ies)", selectedEntries.size()));
            }
            catch (IOException e) {
                LOGGER.error("Error while copying selected entries to clipboard.", (Throwable)e);
            }
        }
    }

    public void cut() {
        this.copy();
        this.libraryTab.delete(StandardActions.CUT);
    }

    private void setupKeyBindings(KeyBindingRepository keyBindings) {
        EditAction pasteAction = new EditAction(StandardActions.PASTE, () -> this.libraryTab, this.stateManager, this.undoManager);
        EditAction copyAction = new EditAction(StandardActions.COPY, () -> this.libraryTab, this.stateManager, this.undoManager);
        EditAction cutAction = new EditAction(StandardActions.CUT, () -> this.libraryTab, this.stateManager, this.undoManager);
        EditAction deleteAction = new EditAction(StandardActions.DELETE_ENTRY, () -> this.libraryTab, this.stateManager, this.undoManager);
        this.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.getSelectedEntries().stream().findFirst().ifPresent(this.libraryTab::showAndEdit);
                event.consume();
                return;
            }
            Optional<KeyBinding> keyBinding = keyBindings.mapToKeyBinding((KeyEvent)event);
            if (keyBinding.isPresent()) {
                switch (keyBinding.get()) {
                    case SELECT_FIRST_ENTRY: {
                        this.clearAndSelectFirst();
                        event.consume();
                        break;
                    }
                    case SELECT_LAST_ENTRY: {
                        this.clearAndSelectLast();
                        event.consume();
                        break;
                    }
                    case PASTE: {
                        pasteAction.execute();
                        event.consume();
                        break;
                    }
                    case COPY: {
                        copyAction.execute();
                        event.consume();
                        break;
                    }
                    case CUT: {
                        cutAction.execute();
                        event.consume();
                        break;
                    }
                    case DELETE_ENTRY: {
                        deleteAction.execute();
                        event.consume();
                        break;
                    }
                }
            }
        });
    }

    public void clearAndSelectFirst() {
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().selectFirst();
        this.scrollTo(0);
    }

    private void clearAndSelectLast() {
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().selectLast();
        this.scrollTo(this.getItems().size() - 1);
    }

    public void paste() {
        String content = ClipBoardManager.getContents();
        List<BibEntry> entriesToAdd = this.importHandler.handleBibTeXData(content);
        if (entriesToAdd.isEmpty()) {
            entriesToAdd = this.handleNonBibTeXStringData(content);
        }
        if (entriesToAdd.isEmpty()) {
            return;
        }
        this.importHandler.importEntriesWithDuplicateCheck(this.database, entriesToAdd);
    }

    private List<BibEntry> handleNonBibTeXStringData(String data) {
        try {
            return this.importHandler.handleStringData(data);
        }
        catch (FetcherException exception) {
            if (exception instanceof FetcherClientException) {
                this.dialogService.showInformationDialogAndWait(Localization.lang("Look up identifier", new Object[0]), Localization.lang("No data was found for the identifier", new Object[0]));
            } else if (exception instanceof FetcherServerException) {
                this.dialogService.showInformationDialogAndWait(Localization.lang("Look up identifier", new Object[0]), Localization.lang("Server not available", new Object[0]));
            } else {
                this.dialogService.showErrorDialogAndWait(exception);
            }
            return List.of();
        }
    }

    public void dropEntry(List<BibEntry> entriesToAdd) {
        this.importHandler.importEntriesWithDuplicateCheck(this.database, entriesToAdd);
    }

    private void handleOnDragOver(TableRow<BibEntryTableViewModel> row, BibEntryTableViewModel item, DragEvent event) {
        if (event.getDragboard().hasFiles()) {
            event.acceptTransferModes(TransferMode.ANY);
            ControlHelper.setDroppingPseudoClasses(row, event);
        }
        event.consume();
    }

    private void handleOnDragOverTableView(DragEvent event) {
        if (event.getDragboard().hasFiles()) {
            event.acceptTransferModes(TransferMode.ANY);
        }
        event.consume();
    }

    private void handleOnDragEntered(TableRow<BibEntryTableViewModel> row, BibEntryTableViewModel entry, MouseDragEvent event) {
        TableRow sourceRow = (TableRow)event.getGestureSource();
        this.getSelectionModel().selectRange(sourceRow.getIndex(), row.getIndex());
    }

    private void handleOnDragExited(TableRow<BibEntryTableViewModel> row, BibEntryTableViewModel entry, DragEvent dragEvent) {
        ControlHelper.removeDroppingPseudoClasses(row);
    }

    private void handleOnDragDetected(TableRow<BibEntryTableViewModel> row, BibEntryTableViewModel entry, MouseEvent event) {
        row.startFullDrag();
        List<BibEntry> entries = this.getSelectionModel().getSelectedItems().stream().map(BibEntryTableViewModel::getEntry).collect(Collectors.toList());
        ClipboardContent content = new ClipboardContent();
        Dragboard dragboard = this.startDragAndDrop(TransferMode.COPY_OR_MOVE);
        content.put((Object)DragAndDropDataFormats.ENTRIES, (Object)"");
        dragboard.setContent((Map)content);
        if (!entries.isEmpty()) {
            this.localDragboard.putBibEntries(entries);
        }
        event.consume();
    }

    private void handleOnDragDropped(TableRow<BibEntryTableViewModel> row, BibEntryTableViewModel target, DragEvent event) {
        boolean success = false;
        if (event.getDragboard().hasFiles()) {
            List<Path> files = event.getDragboard().getFiles().stream().map(File::toPath).collect(Collectors.toList());
            block0 : switch (ControlHelper.getDroppingMouseLocation(row, event)) {
                case TOP: 
                case BOTTOM: {
                    this.importHandler.importFilesInBackground(files).executeWith(this.taskExecutor);
                    break;
                }
                case CENTER: {
                    BibEntry entry = target.getEntry();
                    switch (event.getTransferMode()) {
                        case LINK: {
                            LOGGER.debug("Mode LINK");
                            this.importHandler.getLinker().addFilesToEntry(entry, files);
                            break block0;
                        }
                        case MOVE: {
                            LOGGER.debug("Mode MOVE");
                            this.importHandler.getLinker().moveFilesToFileDirRenameAndAddToEntry(entry, files, this.libraryTab.getIndexingTaskManager());
                            break block0;
                        }
                        case COPY: {
                            LOGGER.debug("Mode Copy");
                            this.importHandler.getLinker().copyFilesToFileDirAndAddToEntry(entry, files, this.libraryTab.getIndexingTaskManager());
                        }
                    }
                }
            }
            success = true;
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private void handleOnDragDroppedTableView(DragEvent event) {
        boolean success = false;
        if (event.getDragboard().hasFiles()) {
            List<Path> files = event.getDragboard().getFiles().stream().map(File::toPath).collect(Collectors.toList());
            this.importHandler.importFilesInBackground(files).executeWith(this.taskExecutor);
            success = true;
        }
        event.setDropCompleted(success);
        event.consume();
    }

    public void addSelectionListener(ListChangeListener<? super BibEntryTableViewModel> listener) {
        this.getSelectionModel().getSelectedItems().addListener(listener);
    }

    public MainTableDataModel getTableModel() {
        return this.model;
    }

    public List<BibEntry> getSelectedEntries() {
        return this.getSelectionModel().getSelectedItems().stream().map(BibEntryTableViewModel::getEntry).collect(Collectors.toList());
    }

    private Optional<BibEntryTableViewModel> findEntry(BibEntry entry) {
        return this.model.getEntriesFilteredAndSorted().stream().filter(viewModel -> viewModel.getEntry().equals(entry)).findFirst();
    }

    private List<BibtexString> getUsedStringValues(List<BibEntry> entries) {
        return this.database.getDatabase().getUsedStrings(entries);
    }
}

