/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import java.util.Optional;
import org.jabref.gui.maintable.NameDisplayPreferences;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.model.entry.field.OrFields;

public class MainTableFieldValueFormatter {
    private final NameDisplayPreferences.DisplayStyle displayStyle;
    private final NameDisplayPreferences.AbbreviationStyle abbreviationStyle;
    private final BibDatabase bibDatabase;

    public MainTableFieldValueFormatter(NameDisplayPreferences nameDisplayPreferences, BibDatabaseContext bibDatabaseContext) {
        this.displayStyle = nameDisplayPreferences.getDisplayStyle();
        this.abbreviationStyle = nameDisplayPreferences.getAbbreviationStyle();
        this.bibDatabase = bibDatabaseContext.getDatabase();
    }

    public String formatFieldsValues(OrFields fields, BibEntry entry) {
        for (Field field : fields.getFields()) {
            if (field.getProperties().contains((Object)FieldProperty.PERSON_NAMES) && this.displayStyle != NameDisplayPreferences.DisplayStyle.AS_IS) {
                Optional<String> name = entry.getResolvedFieldOrAlias(field, this.bibDatabase);
                if (!name.isPresent()) continue;
                return this.formatFieldWithAuthorValue(name.get());
            }
            Optional<String> content = entry.getResolvedFieldOrAliasLatexFree(field, this.bibDatabase);
            if (!content.isPresent()) continue;
            return content.get();
        }
        return "";
    }

    private String formatFieldWithAuthorValue(String nameToFormat) {
        if (nameToFormat == null) {
            return null;
        }
        AuthorList authors = AuthorList.parse(nameToFormat);
        if ((this.displayStyle == NameDisplayPreferences.DisplayStyle.FIRSTNAME_LASTNAME || this.displayStyle == NameDisplayPreferences.DisplayStyle.LASTNAME_FIRSTNAME) && this.abbreviationStyle == NameDisplayPreferences.AbbreviationStyle.LASTNAME_ONLY) {
            return authors.latexFree().getAsLastNames(false);
        }
        return switch (this.displayStyle) {
            default -> nameToFormat;
            case NameDisplayPreferences.DisplayStyle.FIRSTNAME_LASTNAME -> authors.latexFree().getAsFirstLastNames(this.abbreviationStyle == NameDisplayPreferences.AbbreviationStyle.FULL, false);
            case NameDisplayPreferences.DisplayStyle.LASTNAME_FIRSTNAME -> authors.latexFree().getAsLastFirstNames(this.abbreviationStyle == NameDisplayPreferences.AbbreviationStyle.FULL, false);
            case NameDisplayPreferences.DisplayStyle.NATBIB -> authors.latexFree().getAsNatbib();
        };
    }
}

