/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable.columns;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import org.jabref.gui.DialogService;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.fieldeditors.LinkedFileViewModel;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.MainTableColumnFactory;
import org.jabref.gui.maintable.MainTableColumnModel;
import org.jabref.gui.maintable.columns.MainTableColumn;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.PreferencesService;

public class FileColumn
extends MainTableColumn<List<LinkedFile>> {
    private final DialogService dialogService;
    private final BibDatabaseContext database;
    private final PreferencesService preferencesService;
    private final TaskExecutor taskExecutor;

    public FileColumn(MainTableColumnModel model, BibDatabaseContext database, DialogService dialogService, PreferencesService preferencesService, TaskExecutor taskExecutor) {
        super(model);
        this.database = Objects.requireNonNull(database);
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.taskExecutor = taskExecutor;
        this.setCommonSettings();
        Node headerGraphic = IconTheme.JabRefIcons.FILE.getGraphicNode();
        Tooltip.install((Node)headerGraphic, (Tooltip)new Tooltip(Localization.lang("Linked files", new Object[0])));
        this.setGraphic(headerGraphic);
        new ValueTableCellFactory().withGraphic(this::createFileIcon).withTooltip(this::createFileTooltip).withMenu(this::createFileMenu).withOnMouseClickedEvent((entry, linkedFiles) -> event -> {
            if (event.getButton() == MouseButton.PRIMARY && linkedFiles.size() == 1) {
                LinkedFileViewModel linkedFileViewModel = new LinkedFileViewModel((LinkedFile)linkedFiles.getFirst(), entry.getEntry(), database, taskExecutor, dialogService, preferencesService);
                linkedFileViewModel.open();
            }
        }).install(this);
    }

    public FileColumn(MainTableColumnModel model, BibDatabaseContext database, DialogService dialogService, PreferencesService preferencesService, String fileType, TaskExecutor taskExecutor) {
        super(model);
        this.database = Objects.requireNonNull(database);
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.taskExecutor = taskExecutor;
        this.setCommonSettings();
        this.setGraphic(ExternalFileTypes.getExternalFileTypeByName(fileType, preferencesService.getFilePreferences()).map(ExternalFileType::getIcon).orElse(IconTheme.JabRefIcons.FILE).getGraphicNode());
        new ValueTableCellFactory().withGraphic(linkedFiles -> this.createFileIcon(linkedFiles.stream().filter(linkedFile -> linkedFile.getFileType().equalsIgnoreCase(fileType)).collect(Collectors.toList()))).install(this);
    }

    private void setCommonSettings() {
        this.setResizable(false);
        MainTableColumnFactory.setExactWidth(this, 28.0);
        this.getStyleClass().add((Object)"column-icon");
        this.setCellValueFactory(cellData -> ((BibEntryTableViewModel)cellData.getValue()).getLinkedFiles());
    }

    private String createFileTooltip(List<LinkedFile> linkedFiles) {
        if (!linkedFiles.isEmpty()) {
            return Localization.lang("Open file %0", linkedFiles.getFirst().getLink());
        }
        return null;
    }

    private ContextMenu createFileMenu(BibEntryTableViewModel entry, List<LinkedFile> linkedFiles) {
        if (linkedFiles.size() <= 1) {
            return null;
        }
        ContextMenu contextMenu = new ContextMenu();
        for (LinkedFile linkedFile : linkedFiles) {
            LinkedFileViewModel linkedFileViewModel = new LinkedFileViewModel(linkedFile, entry.getEntry(), this.database, this.taskExecutor, this.dialogService, this.preferencesService);
            MenuItem menuItem = new MenuItem(linkedFileViewModel.getTruncatedDescriptionAndLink(), linkedFileViewModel.getTypeIcon().getGraphicNode());
            menuItem.setOnAction(event -> linkedFileViewModel.open());
            contextMenu.getItems().add((Object)menuItem);
        }
        return contextMenu;
    }

    private Node createFileIcon(List<LinkedFile> linkedFiles) {
        if (linkedFiles.size() > 1) {
            return IconTheme.JabRefIcons.FILE_MULTIPLE.getGraphicNode();
        }
        if (linkedFiles.size() == 1) {
            return ExternalFileTypes.getExternalFileTypeByLinkedFile(linkedFiles.getFirst(), true, this.preferencesService.getFilePreferences()).map(ExternalFileType::getIcon).orElse(IconTheme.JabRefIcons.FILE).getGraphicNode();
        }
        return null;
    }
}

