/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.menus;

import java.util.List;
import javax.swing.undo.UndoManager;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableChangeType;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.types.EntryType;

public class ChangeEntryTypeAction
extends SimpleCommand {
    private final EntryType type;
    private final List<BibEntry> entries;
    private final UndoManager undoManager;

    public ChangeEntryTypeAction(EntryType type, List<BibEntry> entries, UndoManager undoManager) {
        this.type = type;
        this.entries = entries;
        this.undoManager = undoManager;
    }

    public void execute() {
        NamedCompound compound = new NamedCompound(Localization.lang("Change entry type", new Object[0]));
        this.entries.forEach(e -> e.setType(this.type).ifPresent(change -> compound.addEdit(new UndoableChangeType((FieldChange)change))));
        this.undoManager.addEdit(compound);
    }
}

