/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.text.Text;

public class DiffHighlighting {
    private DiffHighlighting() {
    }

    public static List<Text> generateDiffHighlighting(String baseString, String modifiedString, String separator) {
        List<String> baseStringSplit = Arrays.asList(baseString.split(separator));
        List<String> modifiedStringSplit = Arrays.asList(modifiedString.split(separator));
        List deltaList = DiffUtils.diff(baseStringSplit, modifiedStringSplit).getDeltas();
        List<Text> result = baseStringSplit.stream().map(text -> DiffHighlighting.forUnchanged(text + separator)).collect(Collectors.toList());
        block5: for (AbstractDelta delta : deltaList.reversed()) {
            int startPos = delta.getSource().getPosition();
            List lines = delta.getSource().getLines();
            int offset = 0;
            switch (delta.getType()) {
                case CHANGE: {
                    for (String line : lines) {
                        result.set(startPos + offset, DiffHighlighting.forRemoved(line + separator));
                        ++offset;
                    }
                    result.set(startPos + offset - 1, DiffHighlighting.forRemoved(baseStringSplit.get(startPos + offset - 1) + separator));
                    result.add(startPos + offset, DiffHighlighting.forAdded(String.join((CharSequence)separator, delta.getTarget().getLines())));
                    break;
                }
                case DELETE: {
                    for (String line : lines) {
                        result.set(startPos + offset, DiffHighlighting.forRemoved(line + separator));
                        ++offset;
                    }
                    continue block5;
                }
                case INSERT: {
                    result.add(delta.getSource().getPosition(), DiffHighlighting.forAdded(String.join((CharSequence)separator, delta.getTarget().getLines())));
                    break;
                }
            }
        }
        return result;
    }

    public static Text forChanged(String text) {
        Text node = new Text(text);
        node.getStyleClass().add((Object)"text-changed");
        return node;
    }

    public static Text forUnchanged(String text) {
        Text node = new Text(text);
        node.getStyleClass().add((Object)"text-unchanged");
        return node;
    }

    public static Text forAdded(String text) {
        Text node = new Text(text);
        node.getStyleClass().add((Object)"text-added");
        return node;
    }

    public static Text forRemoved(String text) {
        Text node = new Text(text);
        node.getStyleClass().add((Object)"text-removed");
        return node;
    }
}

