/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.mergeentries.EntriesMergeResult;
import org.jabref.gui.mergeentries.MergeEntriesDialog;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableChangeType;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.importer.EntryBasedFetcher;
import org.jabref.logic.importer.FetcherClientException;
import org.jabref.logic.importer.FetcherServerException;
import org.jabref.logic.importer.IdBasedFetcher;
import org.jabref.logic.importer.ImportCleanup;
import org.jabref.logic.importer.WebFetcher;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchAndMergeEntry {
    public static List<Field> SUPPORTED_FIELDS = Arrays.asList(StandardField.DOI, StandardField.EPRINT, StandardField.ISBN);
    private static final Logger LOGGER = LoggerFactory.getLogger(FetchAndMergeEntry.class);
    private final DialogService dialogService;
    private final UndoManager undoManager;
    private final BibDatabaseContext bibDatabaseContext;
    private final TaskExecutor taskExecutor;
    private final PreferencesService preferences;

    public FetchAndMergeEntry(BibDatabaseContext bibDatabaseContext, TaskExecutor taskExecutor, PreferencesService preferences, DialogService dialogService, UndoManager undoManager) {
        this.bibDatabaseContext = bibDatabaseContext;
        this.taskExecutor = taskExecutor;
        this.preferences = preferences;
        this.dialogService = dialogService;
        this.undoManager = undoManager;
    }

    public void fetchAndMerge(BibEntry entry) {
        this.fetchAndMerge(entry, SUPPORTED_FIELDS);
    }

    public void fetchAndMerge(BibEntry entry, Field field) {
        this.fetchAndMerge(entry, Collections.singletonList(field));
    }

    public void fetchAndMerge(BibEntry entry, List<Field> fields) {
        for (Field field : fields) {
            Optional<String> fieldContent = entry.getField(field);
            if (fieldContent.isPresent()) {
                Optional<IdBasedFetcher> fetcher = WebFetchers.getIdBasedFetcherForField(field, this.preferences.getImportFormatPreferences());
                if (!fetcher.isPresent()) continue;
                BackgroundTask.wrap(() -> ((IdBasedFetcher)fetcher.get()).performSearchById((String)fieldContent.get())).onSuccess(fetchedEntry -> {
                    ImportCleanup cleanup = ImportCleanup.targeting(this.bibDatabaseContext.getMode(), this.preferences.getFieldPreferences());
                    String type = field.getDisplayName();
                    if (fetchedEntry.isPresent()) {
                        cleanup.doPostCleanup((BibEntry)fetchedEntry.get());
                        this.showMergeDialog(entry, (BibEntry)fetchedEntry.get(), (WebFetcher)fetcher.get());
                    } else {
                        this.dialogService.notify(Localization.lang("Cannot get info based on given %0: %1", type, fieldContent.get()));
                    }
                }).onFailure(exception -> {
                    LOGGER.error("Error while fetching bibliographic information", (Throwable)exception);
                    if (exception instanceof FetcherClientException) {
                        this.dialogService.showInformationDialogAndWait(Localization.lang("Fetching information using %0", ((IdBasedFetcher)fetcher.get()).getName()), Localization.lang("No data was found for the identifier", new Object[0]));
                    } else if (exception instanceof FetcherServerException) {
                        this.dialogService.showInformationDialogAndWait(Localization.lang("Fetching information using %0", ((IdBasedFetcher)fetcher.get()).getName()), Localization.lang("Server not available", new Object[0]));
                    } else {
                        this.dialogService.showInformationDialogAndWait(Localization.lang("Fetching information using %0", ((IdBasedFetcher)fetcher.get()).getName()), Localization.lang("Error occurred %0", exception.getMessage()));
                    }
                }).executeWith(this.taskExecutor);
                continue;
            }
            this.dialogService.notify(Localization.lang("No %0 found", field.getDisplayName()));
        }
    }

    private void showMergeDialog(BibEntry originalEntry, BibEntry fetchedEntry, WebFetcher fetcher) {
        MergeEntriesDialog dialog = new MergeEntriesDialog(originalEntry, fetchedEntry, this.preferences);
        dialog.setTitle(Localization.lang("Merge entry with %0 information", fetcher.getName()));
        dialog.setLeftHeaderText(Localization.lang("Original entry", new Object[0]));
        dialog.setRightHeaderText(Localization.lang("Entry from %0", fetcher.getName()));
        Optional<BibEntry> mergedEntry = this.dialogService.showCustomDialogAndWait(dialog).map(EntriesMergeResult::mergedEntry);
        if (mergedEntry.isPresent()) {
            Optional<String> originalString;
            NamedCompound ce = new NamedCompound(Localization.lang("Merge entry with %0 information", fetcher.getName()));
            TreeSet<Field> jointFields = new TreeSet<Field>(Comparator.comparing(Field::getName));
            jointFields.addAll(mergedEntry.get().getFields());
            TreeSet<Field> originalFields = new TreeSet<Field>(Comparator.comparing(Field::getName));
            originalFields.addAll(originalEntry.getFields());
            boolean edited = false;
            EntryType oldType = originalEntry.getType();
            EntryType newType = mergedEntry.get().getType();
            if (!oldType.equals(newType)) {
                originalEntry.setType(newType);
                ce.addEdit(new UndoableChangeType(originalEntry, oldType, newType));
                edited = true;
            }
            for (Field field : jointFields) {
                originalString = originalEntry.getField(field);
                Optional<String> mergedString = mergedEntry.get().getField(field);
                if (!originalString.isEmpty() && originalString.equals(mergedString)) continue;
                originalEntry.setField(field, mergedString.get());
                ce.addEdit(new UndoableFieldChange(originalEntry, field, originalString.orElse(null), mergedString.get()));
                edited = true;
            }
            for (Field field : originalFields) {
                if (jointFields.contains(field) || FieldFactory.isInternalField(field)) continue;
                originalString = originalEntry.getField(field);
                originalEntry.clearField(field);
                ce.addEdit(new UndoableFieldChange(originalEntry, field, originalString.get(), null));
                edited = true;
            }
            if (edited) {
                ce.end();
                this.undoManager.addEdit(ce);
                this.dialogService.notify(Localization.lang("Updated entry with info from %0", fetcher.getName()));
            } else {
                this.dialogService.notify(Localization.lang("No information added", new Object[0]));
            }
        } else {
            this.dialogService.notify(Localization.lang("Canceled merging entries", new Object[0]));
        }
    }

    public void fetchAndMerge(BibEntry entry, EntryBasedFetcher fetcher) {
        BackgroundTask.wrap(() -> fetcher.performSearch(entry).stream().findFirst()).onSuccess(fetchedEntry -> {
            if (fetchedEntry.isPresent()) {
                ImportCleanup cleanup = ImportCleanup.targeting(this.bibDatabaseContext.getMode(), this.preferences.getFieldPreferences());
                cleanup.doPostCleanup((BibEntry)fetchedEntry.get());
                this.showMergeDialog(entry, (BibEntry)fetchedEntry.get(), fetcher);
            } else {
                this.dialogService.notify(Localization.lang("Could not find any bibliographic information.", new Object[0]));
            }
        }).onFailure(exception -> {
            LOGGER.error("Error while fetching entry with {} ", (Object)fetcher.getName(), exception);
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error while fetching from %0", fetcher.getName()), (Throwable)exception);
        }).executeWith(this.taskExecutor);
    }
}

