/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.mergeentries.EntriesMergeResult;
import org.jabref.gui.mergeentries.MergeEntriesDialog;
import org.jabref.gui.mergeentries.MergeTwoEntriesAction;
import org.jabref.logic.bibtex.comparator.EntryComparator;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.InternalField;
import org.jabref.preferences.PreferencesService;

public class MergeEntriesAction
extends SimpleCommand {
    private static final int NUMBER_OF_ENTRIES_NEEDED = 2;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final UndoManager undoManager;
    private final PreferencesService preferencesService;

    public MergeEntriesAction(DialogService dialogService, StateManager stateManager, UndoManager undoManager, PreferencesService preferencesService) {
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.undoManager = undoManager;
        this.preferencesService = preferencesService;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(2, stateManager));
    }

    public void execute() {
        BibEntry second;
        BibEntry first;
        BibEntry two;
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            return;
        }
        ObservableList<BibEntry> selectedEntries = this.stateManager.getSelectedEntries();
        if (selectedEntries.size() != 2) {
            this.dialogService.showInformationDialogAndWait(Localization.lang("Merge entries", new Object[0]), Localization.lang("You have to choose exactly two entries to merge.", new Object[0]));
            return;
        }
        EntryComparator entryComparator = new EntryComparator(false, false, InternalField.KEY_FIELD);
        BibEntry one = (BibEntry)selectedEntries.getFirst();
        if (entryComparator.compare(one, two = (BibEntry)selectedEntries.get(1)) <= 0) {
            first = one;
            second = two;
        } else {
            first = two;
            second = one;
        }
        MergeEntriesDialog dialog = new MergeEntriesDialog(first, second, this.preferencesService);
        dialog.setTitle(Localization.lang("Merge entries", new Object[0]));
        Optional<EntriesMergeResult> mergeResultOpt = this.dialogService.showCustomDialogAndWait(dialog);
        mergeResultOpt.ifPresentOrElse(entriesMergeResult -> {
            new MergeTwoEntriesAction((EntriesMergeResult)entriesMergeResult, this.stateManager, this.undoManager).execute();
            this.dialogService.notify(Localization.lang("Merged entries", new Object[0]));
        }, () -> this.dialogService.notify(Localization.lang("Canceled merging entries", new Object[0])));
    }
}

