/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog;

import com.tobiasdiez.easybind.EasyBind;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.jabref.gui.mergeentries.newmergedialog.FieldRowViewModel;
import org.jabref.gui.mergeentries.newmergedialog.ShowDiffConfig;
import org.jabref.gui.mergeentries.newmergedialog.cell.FieldNameCell;
import org.jabref.gui.mergeentries.newmergedialog.cell.FieldValueCell;
import org.jabref.gui.mergeentries.newmergedialog.cell.MergedFieldCell;
import org.jabref.gui.mergeentries.newmergedialog.cell.sidebuttons.ToggleMergeUnmergeButton;
import org.jabref.gui.mergeentries.newmergedialog.diffhighlighter.SplitDiffHighlighter;
import org.jabref.gui.mergeentries.newmergedialog.diffhighlighter.UnifiedDiffHighlighter;
import org.jabref.gui.mergeentries.newmergedialog.fieldsmerger.FieldMergerFactory;
import org.jabref.gui.mergeentries.newmergedialog.toolbar.ThreeWayMergeToolbar;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRowView {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldRowView.class);
    protected final FieldRowViewModel viewModel;
    protected final BooleanProperty shouldShowDiffs = new SimpleBooleanProperty(true);
    private final FieldNameCell fieldNameCell;
    private final FieldValueCell leftValueCell;
    private final FieldValueCell rightValueCell;
    private final MergedFieldCell mergedValueCell;
    private final ToggleGroup toggleGroup = new ToggleGroup();
    private GridPane parent;

    public FieldRowView(Field field, BibEntry leftEntry, BibEntry rightEntry, BibEntry mergedEntry, FieldMergerFactory fieldMergerFactory, PreferencesService preferencesService, int rowIndex) {
        this.viewModel = new FieldRowViewModel(field, leftEntry, rightEntry, mergedEntry, fieldMergerFactory);
        this.fieldNameCell = new FieldNameCell(field.getDisplayName(), rowIndex);
        this.leftValueCell = new FieldValueCell(this.viewModel.getLeftFieldValue(), rowIndex, preferencesService);
        this.rightValueCell = new FieldValueCell(this.viewModel.getRightFieldValue(), rowIndex, preferencesService);
        this.mergedValueCell = new MergedFieldCell(this.viewModel.getMergedFieldValue(), rowIndex);
        this.leftValueCell.parentProperty().addListener(e -> {
            Parent patt0$temp = this.leftValueCell.getParent();
            if (patt0$temp instanceof GridPane) {
                GridPane grid;
                this.parent = grid = (GridPane)patt0$temp;
            }
        });
        if (FieldMergerFactory.canMerge(field)) {
            ToggleMergeUnmergeButton toggleMergeUnmergeButton = new ToggleMergeUnmergeButton(field);
            toggleMergeUnmergeButton.setCanMerge(!this.viewModel.hasEqualLeftAndRightValues());
            this.fieldNameCell.addSideButton(toggleMergeUnmergeButton);
            EasyBind.listen(toggleMergeUnmergeButton.fieldStateProperty(), (observableValue, old, fieldState) -> {
                LOGGER.debug("Field merge state is {} for field {}", (Object)fieldState, (Object)field);
                if (fieldState == ToggleMergeUnmergeButton.FieldState.MERGED) {
                    this.viewModel.mergeFields();
                } else {
                    this.viewModel.unmergeFields();
                }
            });
        }
        this.toggleGroup.getToggles().addAll((Object[])new Toggle[]{this.leftValueCell, this.rightValueCell});
        this.mergedValueCell.textProperty().bindBidirectional((Property)this.viewModel.mergedFieldValueProperty());
        this.leftValueCell.textProperty().bindBidirectional((Property)this.viewModel.leftFieldValueProperty());
        this.rightValueCell.textProperty().bindBidirectional((Property)this.viewModel.rightFieldValueProperty());
        EasyBind.subscribe(this.viewModel.selectionProperty(), selection -> {
            if (selection == FieldRowViewModel.Selection.LEFT) {
                this.toggleGroup.selectToggle((Toggle)this.leftValueCell);
            } else if (selection == FieldRowViewModel.Selection.RIGHT) {
                this.toggleGroup.selectToggle((Toggle)this.rightValueCell);
            } else if (selection == FieldRowViewModel.Selection.NONE) {
                this.toggleGroup.selectToggle(null);
            }
        });
        EasyBind.subscribe((ObservableValue)this.toggleGroup.selectedToggleProperty(), selectedToggle -> {
            if (selectedToggle == this.leftValueCell) {
                this.selectLeftValue();
            } else if (selectedToggle == this.rightValueCell) {
                this.selectRightValue();
            } else {
                this.selectNone();
            }
        });
        EasyBind.subscribe((ObservableValue)this.viewModel.isFieldsMergedProperty(), isFieldsMerged -> {
            if (isFieldsMerged.booleanValue()) {
                this.rightValueCell.setVisible(false);
                GridPane.setColumnSpan((Node)this.leftValueCell, (Integer)2);
            } else {
                this.rightValueCell.setVisible(true);
                GridPane.setColumnSpan((Node)this.leftValueCell, (Integer)1);
            }
        });
        EasyBind.listen((ObservableValue)this.viewModel.hasEqualLeftAndRightBinding(), (obs, old, isEqual) -> {
            if (isEqual.booleanValue()) {
                LOGGER.debug("Left and right values are equal, LEFT==RIGHT=={}", (Object)this.viewModel.getLeftFieldValue());
                this.hideDiff();
            }
        });
    }

    public void selectLeftValue() {
        this.viewModel.selectLeftValue();
    }

    public void selectRightValue() {
        this.viewModel.selectRightValue();
    }

    public void selectNone() {
        this.viewModel.selectNone();
    }

    public String getMergedValue() {
        return this.mergedValueProperty().getValue();
    }

    public ReadOnlyStringProperty mergedValueProperty() {
        return this.viewModel.mergedFieldValueProperty();
    }

    public FieldNameCell getFieldNameCell() {
        return this.fieldNameCell;
    }

    public FieldValueCell getLeftValueCell() {
        return this.leftValueCell;
    }

    public FieldValueCell getRightValueCell() {
        return this.rightValueCell;
    }

    public MergedFieldCell getMergedValueCell() {
        return this.mergedValueCell;
    }

    public void showDiff(ShowDiffConfig diffConfig) {
        if (!this.rightValueCell.isVisible() || StringUtil.isNullOrEmpty(this.viewModel.getLeftFieldValue()) || StringUtil.isNullOrEmpty(this.viewModel.getRightFieldValue())) {
            return;
        }
        LOGGER.debug("Showing diffs...");
        StyleClassedTextArea leftLabel = this.leftValueCell.getStyleClassedLabel();
        StyleClassedTextArea rightLabel = this.rightValueCell.getStyleClassedLabel();
        this.hideDiff();
        if (this.shouldShowDiffs.get()) {
            if (diffConfig.diffView() == ThreeWayMergeToolbar.DiffView.UNIFIED) {
                new UnifiedDiffHighlighter(leftLabel, rightLabel, diffConfig.diffHighlightingMethod()).highlight();
            } else {
                new SplitDiffHighlighter(leftLabel, rightLabel, diffConfig.diffHighlightingMethod()).highlight();
            }
        }
    }

    public void hide() {
        if (this.parent != null) {
            this.parent.getChildren().removeAll((Object[])new Node[]{this.leftValueCell, this.rightValueCell, this.mergedValueCell, this.fieldNameCell});
        }
    }

    public void show() {
        if (this.parent != null && !this.parent.getChildren().contains((Object)this.leftValueCell)) {
            this.parent.getChildren().addAll((Object[])new Node[]{this.leftValueCell, this.rightValueCell, this.mergedValueCell, this.fieldNameCell});
        }
    }

    public void hideDiff() {
        if (!this.rightValueCell.isVisible()) {
            return;
        }
        LOGGER.debug("Hiding diffs...");
        int leftValueLength = this.getLeftValueCell().getStyleClassedLabel().getLength();
        this.getLeftValueCell().getStyleClassedLabel().clearStyle(0, leftValueLength);
        this.getLeftValueCell().getStyleClassedLabel().replaceText(this.viewModel.getLeftFieldValue());
        int rightValueLength = this.getRightValueCell().getStyleClassedLabel().getLength();
        this.getRightValueCell().getStyleClassedLabel().clearStyle(0, rightValueLength);
        this.getRightValueCell().getStyleClassedLabel().replaceText(this.viewModel.getRightFieldValue());
    }

    public boolean hasEqualLeftAndRightValues() {
        return this.viewModel.hasEqualLeftAndRightValues();
    }

    public String toString() {
        return "FieldRowView [shouldShowDiffs=" + this.shouldShowDiffs.get() + ", fieldNameCell=" + String.valueOf((Object)this.fieldNameCell) + ", leftValueCell=" + String.valueOf((Object)this.leftValueCell) + ", rightValueCell=" + String.valueOf((Object)this.rightValueCell) + ", mergedValueCell=" + String.valueOf((Object)this.mergedValueCell) + "]";
    }
}

