/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import org.jabref.gui.mergeentries.newmergedialog.FieldRowView;
import org.jabref.gui.mergeentries.newmergedialog.GroupDiffMode;
import org.jabref.gui.mergeentries.newmergedialog.PersonsNameFieldRowView;
import org.jabref.gui.mergeentries.newmergedialog.ShowDiffConfig;
import org.jabref.gui.mergeentries.newmergedialog.ThreeWayMergeHeaderView;
import org.jabref.gui.mergeentries.newmergedialog.ThreeWayMergeViewModel;
import org.jabref.gui.mergeentries.newmergedialog.fieldsmerger.FieldMergerFactory;
import org.jabref.gui.mergeentries.newmergedialog.toolbar.ThreeWayMergeToolbar;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldProperty;
import org.jabref.preferences.PreferencesService;

public class ThreeWayMergeView
extends VBox {
    public static final int GRID_COLUMN_MIN_WIDTH = 250;
    public static final String LEFT_DEFAULT_HEADER = Localization.lang("Left Entry", new Object[0]);
    public static final String RIGHT_DEFAULT_HEADER = Localization.lang("Right Entry", new Object[0]);
    private final ColumnConstraints fieldNameColumnConstraints = new ColumnConstraints(150.0);
    private final ColumnConstraints leftEntryColumnConstraints = new ColumnConstraints(250.0, 256.0, Double.MAX_VALUE);
    private final ColumnConstraints rightEntryColumnConstraints = new ColumnConstraints(250.0, 256.0, Double.MAX_VALUE);
    private final ColumnConstraints mergedEntryColumnConstraints = new ColumnConstraints(250.0, 256.0, Double.MAX_VALUE);
    private final ThreeWayMergeToolbar toolbar;
    private final ThreeWayMergeHeaderView headerView;
    private final ScrollPane scrollPane;
    private final GridPane mergeGridPane;
    private final ThreeWayMergeViewModel viewModel;
    private final List<FieldRowView> fieldRows = new ArrayList<FieldRowView>();
    private final PreferencesService preferencesService;
    private final FieldMergerFactory fieldMergerFactory;
    private final String keywordSeparator;

    public ThreeWayMergeView(BibEntry leftEntry, BibEntry rightEntry, String leftHeader, String rightHeader, PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
        this.getStylesheets().add((Object)ThreeWayMergeView.class.getResource("ThreeWayMergeView.css").toExternalForm());
        this.viewModel = new ThreeWayMergeViewModel((BibEntry)leftEntry.clone(), (BibEntry)rightEntry.clone(), leftHeader, rightHeader);
        this.fieldMergerFactory = new FieldMergerFactory(preferencesService.getBibEntryPreferences());
        this.keywordSeparator = preferencesService.getBibEntryPreferences().getKeywordSeparator().toString();
        this.mergeGridPane = new GridPane();
        this.scrollPane = new ScrollPane();
        this.headerView = new ThreeWayMergeHeaderView(leftHeader, rightHeader);
        this.toolbar = new ThreeWayMergeToolbar();
        this.initializeColumnConstraints();
        this.initializeMergeGridPane();
        this.initializeScrollPane();
        this.initializeHeaderView();
        this.initializeToolbar();
        this.setPrefHeight(Screen.getPrimary().getBounds().getHeight() * 0.76);
        this.setPrefWidth(Screen.getPrimary().getBounds().getWidth() * 0.97);
        this.getChildren().addAll((Object[])new Node[]{this.toolbar, this.headerView, this.scrollPane});
    }

    public ThreeWayMergeView(BibEntry leftEntry, BibEntry rightEntry, PreferencesService preferencesService) {
        this(leftEntry, rightEntry, LEFT_DEFAULT_HEADER, RIGHT_DEFAULT_HEADER, preferencesService);
    }

    private void initializeToolbar() {
        this.toolbar.setOnSelectLeftEntryValuesButtonClicked(this::selectLeftEntryValues);
        this.toolbar.setOnSelectRightEntryValuesButtonClicked(this::selectRightEntryValues);
        this.toolbar.showDiffProperty().addListener(e -> this.updateDiff());
        this.toolbar.diffViewProperty().addListener(e -> this.updateDiff());
        this.toolbar.diffHighlightingMethodProperty().addListener(e -> this.updateDiff());
        this.toolbar.hideEqualFieldsProperty().addListener(e -> this.showOrHideEqualFields());
        this.updateDiff();
        this.showOrHideEqualFields();
    }

    private void showOrHideEqualFields() {
        for (FieldRowView row : this.fieldRows) {
            if (this.toolbar.shouldHideEqualFields()) {
                if (!row.hasEqualLeftAndRightValues()) continue;
                row.hide();
                continue;
            }
            row.show();
        }
    }

    private void updateDiff() {
        if (this.toolbar.shouldShowDiffs().booleanValue()) {
            for (FieldRowView row : this.fieldRows) {
                if ("Groups".equals(row.getFieldNameCell().getText()) && (row.getLeftValueCell().getText().contains(this.keywordSeparator) || row.getRightValueCell().getText().contains(this.keywordSeparator))) {
                    row.showDiff(new ShowDiffConfig(this.toolbar.getDiffView(), new GroupDiffMode(this.keywordSeparator)));
                    continue;
                }
                row.showDiff(new ShowDiffConfig(this.toolbar.getDiffView(), this.toolbar.getDiffHighlightingMethod()));
            }
        } else {
            this.fieldRows.forEach(FieldRowView::hideDiff);
        }
    }

    private void initializeHeaderView() {
        this.headerView.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{this.fieldNameColumnConstraints, this.leftEntryColumnConstraints, this.rightEntryColumnConstraints, this.mergedEntryColumnConstraints});
    }

    private void initializeScrollPane() {
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scrollPane.setContent((Node)this.mergeGridPane);
    }

    private void initializeColumnConstraints() {
        this.fieldNameColumnConstraints.setHgrow(Priority.NEVER);
        this.leftEntryColumnConstraints.setHgrow(Priority.ALWAYS);
        this.rightEntryColumnConstraints.setHgrow(Priority.ALWAYS);
        this.mergedEntryColumnConstraints.setHgrow(Priority.ALWAYS);
    }

    private void initializeMergeGridPane() {
        this.mergeGridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{this.fieldNameColumnConstraints, this.leftEntryColumnConstraints, this.rightEntryColumnConstraints, this.mergedEntryColumnConstraints});
        for (int fieldIndex = 0; fieldIndex < this.viewModel.numberOfVisibleFields(); ++fieldIndex) {
            this.addRow(fieldIndex);
            this.mergeGridPane.getRowConstraints().add((Object)new RowConstraints());
        }
    }

    private Field getFieldAtIndex(int index) {
        return (Field)this.viewModel.getVisibleFields().get(index);
    }

    private void addRow(int fieldIndex) {
        Field field = this.getFieldAtIndex(fieldIndex);
        FieldRowView fieldRow = field.getProperties().contains((Object)FieldProperty.PERSON_NAMES) ? new PersonsNameFieldRowView(field, this.getLeftEntry(), this.getRightEntry(), this.getMergedEntry(), this.fieldMergerFactory, this.preferencesService, fieldIndex) : new FieldRowView(field, this.getLeftEntry(), this.getRightEntry(), this.getMergedEntry(), this.fieldMergerFactory, this.preferencesService, fieldIndex);
        this.fieldRows.add(fieldIndex, fieldRow);
        this.mergeGridPane.add((Node)fieldRow.getFieldNameCell(), 0, fieldIndex);
        this.mergeGridPane.add((Node)fieldRow.getLeftValueCell(), 1, fieldIndex);
        this.mergeGridPane.add((Node)fieldRow.getRightValueCell(), 2, fieldIndex);
        this.mergeGridPane.add((Node)fieldRow.getMergedValueCell(), 3, fieldIndex);
    }

    public BibEntry getMergedEntry() {
        return this.viewModel.getMergedEntry();
    }

    public void setLeftHeader(String leftHeader) {
        this.headerView.setLeftHeader(leftHeader);
    }

    public void setRightHeader(String rightHeader) {
        this.headerView.setRightHeader(rightHeader);
    }

    public void selectLeftEntryValues() {
        this.fieldRows.forEach(FieldRowView::selectLeftValue);
    }

    public void selectRightEntryValues() {
        this.fieldRows.forEach(FieldRowView::selectRightValue);
    }

    public void showDiff(ShowDiffConfig diffConfig) {
        this.toolbar.setDiffView(diffConfig.diffView());
        this.toolbar.setDiffHighlightingMethod(diffConfig.diffHighlightingMethod());
        this.toolbar.setShowDiff(true);
    }

    public BibEntry getLeftEntry() {
        return this.viewModel.getLeftEntry();
    }

    public BibEntry getRightEntry() {
        return this.viewModel.getRightEntry();
    }

    public void saveConfiguration() {
        this.toolbar.saveToolbarConfiguration();
    }
}

