/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog.cell;

import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.jabref.gui.mergeentries.newmergedialog.cell.ThreeWayMergeCell;
import org.jabref.gui.util.BindingsHelper;

public class MergedFieldCell
extends ThreeWayMergeCell {
    private static final String DEFAULT_STYLE_CLASS = "merged-field";
    private final StyleClassedTextArea textArea = new StyleClassedTextArea();

    public MergedFieldCell(String text, int rowIndex) {
        super(text, rowIndex);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.initializeTextArea();
        this.getChildren().add((Object)this.textArea);
    }

    private void initializeTextArea() {
        BindingsHelper.bindBidirectional(this.textArea.textProperty(), this.textProperty(), arg_0 -> ((StyleClassedTextArea)this.textArea).replaceText(arg_0), arg_0 -> ((StringProperty)this.textProperty()).setValue(arg_0));
        this.setAlignment(Pos.CENTER);
        this.textArea.setWrapText(true);
        this.textArea.setAutoHeight(true);
        this.textArea.setPadding(new Insets(8.0));
        HBox.setHgrow((Node)this.textArea, (Priority)Priority.ALWAYS);
        this.textArea.addEventFilter(ScrollEvent.SCROLL, e -> {
            e.consume();
            this.fireEvent((Event)e.copyFor(e.getSource(), (EventTarget)this));
        });
    }
}

