/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog.diffhighlighter;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import java.util.List;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.jabref.gui.mergeentries.newmergedialog.DiffMethod;
import org.jabref.gui.mergeentries.newmergedialog.diffhighlighter.DiffHighlighter;

public final class SplitDiffHighlighter
extends DiffHighlighter {
    public SplitDiffHighlighter(StyleClassedTextArea sourceTextview, StyleClassedTextArea targetTextview, DiffMethod diffMethod) {
        super(sourceTextview, targetTextview, diffMethod);
    }

    @Override
    public void highlight() {
        String targetContent;
        String sourceContent = this.sourceTextview.getText();
        if (sourceContent.equals(targetContent = this.targetTextview.getText())) {
            return;
        }
        List<String> sourceTokens = this.splitString(sourceContent);
        List<String> targetTokens = this.splitString(targetContent);
        List deltaList = DiffUtils.diff(sourceTokens, targetTokens).getDeltas();
        for (AbstractDelta delta : deltaList) {
            int affectedSourceTokensPosition = delta.getSource().getPosition();
            int affectedTargetTokensPosition = delta.getTarget().getPosition();
            List affectedTokensInSource = delta.getSource().getLines();
            List affectedTokensInTarget = delta.getTarget().getLines();
            int joinedSourceTokensLength = affectedTokensInSource.stream().map(String::length).reduce(Integer::sum).map(value -> value + this.getSeparator().length() * (affectedTokensInSource.size() - 1)).orElse(0);
            int joinedTargetTokensLength = affectedTokensInTarget.stream().map(String::length).reduce(Integer::sum).map(value -> value + this.getSeparator().length() * (affectedTokensInTarget.size() - 1)).orElse(0);
            int affectedSourceTokensPositionInText = this.getPositionInText(affectedSourceTokensPosition, sourceTokens);
            int affectedTargetTokensPositionInText = this.getPositionInText(affectedTargetTokensPosition, targetTokens);
            switch (delta.getType()) {
                case CHANGE: {
                    this.sourceTextview.setStyleClass(affectedSourceTokensPositionInText, affectedSourceTokensPositionInText + joinedSourceTokensLength, "deletion");
                    this.targetTextview.setStyleClass(affectedTargetTokensPositionInText, affectedTargetTokensPositionInText + joinedTargetTokensLength, "updated");
                    break;
                }
                case DELETE: {
                    this.sourceTextview.setStyleClass(affectedSourceTokensPositionInText, affectedSourceTokensPositionInText + joinedSourceTokensLength, "deletion");
                    break;
                }
                case INSERT: {
                    this.targetTextview.setStyleClass(affectedTargetTokensPositionInText, affectedTargetTokensPositionInText + joinedTargetTokensLength, "addition");
                }
            }
        }
    }

    public int getPositionInText(int positionInTokenList, List<String> tokenList) {
        if (positionInTokenList == 0) {
            return 0;
        }
        return tokenList.stream().limit(positionInTokenList).map(String::length).reduce(Integer::sum).map(value -> value + this.getSeparator().length() * positionInTokenList).orElse(0);
    }
}

