/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog.diffhighlighter;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.jabref.gui.mergeentries.newmergedialog.DiffMethod;
import org.jabref.gui.mergeentries.newmergedialog.diffhighlighter.DiffHighlighter;

public final class UnifiedDiffHighlighter
extends DiffHighlighter {
    public UnifiedDiffHighlighter(StyleClassedTextArea sourceTextview, StyleClassedTextArea targetTextview, DiffMethod diffMethod) {
        super(sourceTextview, targetTextview, diffMethod);
    }

    @Override
    public void highlight() {
        String targetContent;
        String sourceContent = this.sourceTextview.getText();
        if (sourceContent.equals(targetContent = this.targetTextview.getText())) {
            return;
        }
        List<String> sourceWords = this.splitString(sourceContent);
        List<String> targetWords = this.splitString(targetContent);
        ArrayList<String> unifiedWords = new ArrayList<String>(targetWords);
        List deltaList = DiffUtils.diff(sourceWords, targetWords).getDeltas();
        ArrayList<DiffHighlighter.Change> changeList = new ArrayList<DiffHighlighter.Change>();
        int deletionCount = 0;
        for (AbstractDelta delta : deltaList) {
            switch (delta.getType()) {
                case CHANGE: {
                    int changePosition = delta.getTarget().getPosition();
                    int deletionPoint = changePosition + deletionCount;
                    int insertionPoint = deletionPoint + 1;
                    List deltaSourceWords = delta.getSource().getLines();
                    List deltaTargetWords = delta.getTarget().getLines();
                    unifiedWords.add(deletionPoint, this.join(deltaSourceWords));
                    changeList.add(new DiffHighlighter.Change(deletionPoint, 1, DiffHighlighter.ChangeType.CHANGE_DELETION));
                    changeList.add(new DiffHighlighter.Change(insertionPoint, deltaTargetWords.size(), DiffHighlighter.ChangeType.ADDITION));
                    ++deletionCount;
                    break;
                }
                case DELETE: {
                    int deletionPoint = delta.getTarget().getPosition() + deletionCount;
                    unifiedWords.add(deletionPoint, this.join(delta.getSource().getLines()));
                    changeList.add(new DiffHighlighter.Change(deletionPoint, 1, DiffHighlighter.ChangeType.DELETION));
                    ++deletionCount;
                    break;
                }
                case INSERT: {
                    int insertionPoint = delta.getTarget().getPosition() + deletionCount;
                    changeList.add(new DiffHighlighter.Change(insertionPoint, delta.getTarget().getLines().size(), DiffHighlighter.ChangeType.ADDITION));
                }
            }
        }
        this.targetTextview.clear();
        boolean changeInProgress = false;
        for (int position = 0; position < unifiedWords.size(); ++position) {
            String word = (String)unifiedWords.get(position);
            Optional<DiffHighlighter.Change> changeAtPosition = this.findChange(position, changeList);
            if (changeAtPosition.isEmpty()) {
                this.appendToTextArea(this.targetTextview, this.getSeparator() + word, "unchanged");
                continue;
            }
            DiffHighlighter.Change change = changeAtPosition.get();
            List<String> changeWords = unifiedWords.subList(change.position(), change.position() + change.spanSize());
            if (change.type() == DiffHighlighter.ChangeType.DELETION) {
                this.appendToTextArea(this.targetTextview, this.getSeparator() + this.join(changeWords), "deletion");
            } else if (change.type() == DiffHighlighter.ChangeType.ADDITION) {
                if (changeInProgress) {
                    this.appendToTextArea(this.targetTextview, this.join(changeWords), "addition");
                    changeInProgress = false;
                } else {
                    this.appendToTextArea(this.targetTextview, this.getSeparator() + this.join(changeWords), "addition");
                }
            } else if (change.type() == DiffHighlighter.ChangeType.CHANGE_DELETION) {
                this.appendToTextArea(this.targetTextview, this.getSeparator() + this.join(changeWords), "deletion");
                changeInProgress = true;
            }
            position = position + changeWords.size() - 1;
        }
        if (this.targetTextview.getLength() >= this.getSeparator().length()) {
            this.targetTextview.deleteText(0, this.getSeparator().length());
        }
    }

    private void appendToTextArea(StyleClassedTextArea textArea, String text, String styleClass) {
        if (text.isEmpty()) {
            return;
        }
        if (text.startsWith(this.getSeparator())) {
            textArea.append(this.getSeparator(), "unchanged");
            textArea.append(text.substring(this.getSeparator().length()), styleClass);
        } else {
            textArea.append(text, styleClass);
        }
    }

    private Optional<DiffHighlighter.Change> findChange(int position, List<DiffHighlighter.Change> changeList) {
        return changeList.stream().filter(change -> change.position() == position).findAny();
    }
}

