/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import com.sun.star.comp.helper.BootstrapException;
import de.saxsys.mvvmfx.utils.commands.Command;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.undo.UndoManager;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.openoffice.AdvancedCiteDialogView;
import org.jabref.gui.openoffice.AdvancedCiteDialogViewModel;
import org.jabref.gui.openoffice.DetectOpenOfficeInstallation;
import org.jabref.gui.openoffice.ManageCitationsDialogView;
import org.jabref.gui.openoffice.OOBibBase;
import org.jabref.gui.openoffice.OOError;
import org.jabref.gui.openoffice.StyleSelectDialogView;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableKeyChange;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.citationkeypattern.CitationKeyGenerator;
import org.jabref.logic.citationkeypattern.CitationKeyPatternPreferences;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.openoffice.OpenOfficeFileSearch;
import org.jabref.logic.openoffice.OpenOfficePreferences;
import org.jabref.logic.openoffice.action.Update;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.logic.openoffice.style.StyleLoader;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.openoffice.style.CitationType;
import org.jabref.model.openoffice.uno.CreationException;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOfficePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenOfficePanel.class);
    private final DialogService dialogService;
    private final Button connect;
    private final Button manualConnect;
    private final Button selectDocument;
    private final Button setStyleFile = new Button(Localization.lang("Select style", new Object[0]));
    private final Button pushEntries = new Button(Localization.lang("Cite", new Object[0]));
    private final Button pushEntriesInt = new Button(Localization.lang("Cite in-text", new Object[0]));
    private final Button pushEntriesEmpty = new Button(Localization.lang("Insert empty citation", new Object[0]));
    private final Button pushEntriesAdvanced = new Button(Localization.lang("Cite special", new Object[0]));
    private final Button update;
    private final Button merge = new Button(Localization.lang("Merge citations", new Object[0]));
    private final Button unmerge = new Button(Localization.lang("Separate citations", new Object[0]));
    private final Button manageCitations = new Button(Localization.lang("Manage citations", new Object[0]));
    private final Button exportCitations = new Button(Localization.lang("Export cited", new Object[0]));
    private final Button settingsB = new Button(Localization.lang("Settings", new Object[0]));
    private final Button help;
    private final VBox vbox = new VBox();
    private final PreferencesService preferencesService;
    private final StateManager stateManager;
    private final ClipBoardManager clipBoardManager;
    private final UndoManager undoManager;
    private final TaskExecutor taskExecutor;
    private final StyleLoader loader;
    private final LibraryTabContainer tabContainer;
    private final FileUpdateMonitor fileUpdateMonitor;
    private final BibEntryTypesManager entryTypesManager;
    private OOBibBase ooBase;
    private OOBibStyle style;

    public OpenOfficePanel(LibraryTabContainer tabContainer, PreferencesService preferencesService, JournalAbbreviationRepository abbreviationRepository, TaskExecutor taskExecutor, DialogService dialogService, StateManager stateManager, FileUpdateMonitor fileUpdateMonitor, BibEntryTypesManager entryTypesManager, ClipBoardManager clipBoardManager, UndoManager undoManager) {
        this.tabContainer = tabContainer;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.entryTypesManager = entryTypesManager;
        this.preferencesService = preferencesService;
        this.taskExecutor = taskExecutor;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.clipBoardManager = clipBoardManager;
        this.undoManager = undoManager;
        ActionFactory factory = new ActionFactory();
        this.connect = new Button();
        this.connect.setGraphic(IconTheme.JabRefIcons.CONNECT_OPEN_OFFICE.getGraphicNode());
        this.connect.setTooltip(new Tooltip(Localization.lang("Connect", new Object[0])));
        this.connect.setMaxWidth(Double.MAX_VALUE);
        this.manualConnect = new Button();
        this.manualConnect.setGraphic(IconTheme.JabRefIcons.CONNECT_OPEN_OFFICE.getGraphicNode());
        this.manualConnect.setTooltip(new Tooltip(Localization.lang("Manual connect", new Object[0])));
        this.manualConnect.setMaxWidth(Double.MAX_VALUE);
        this.help = factory.createIconButton(StandardActions.HELP, (Command)new HelpAction(HelpFile.OPENOFFICE_LIBREOFFICE, dialogService, preferencesService.getFilePreferences()));
        this.help.setMaxWidth(Double.MAX_VALUE);
        this.selectDocument = new Button();
        this.selectDocument.setGraphic(IconTheme.JabRefIcons.OPEN.getGraphicNode());
        this.selectDocument.setTooltip(new Tooltip(Localization.lang("Select Writer document", new Object[0])));
        this.selectDocument.setMaxWidth(Double.MAX_VALUE);
        this.update = new Button();
        this.update.setGraphic(IconTheme.JabRefIcons.REFRESH.getGraphicNode());
        this.update.setTooltip(new Tooltip(Localization.lang("Sync OpenOffice/LibreOffice bibliography", new Object[0])));
        this.update.setMaxWidth(Double.MAX_VALUE);
        this.loader = new StyleLoader(preferencesService.getOpenOfficePreferences(), preferencesService.getLayoutFormatterPreferences(), abbreviationRepository);
        this.initPanel();
    }

    public Node getContent() {
        return this.vbox;
    }

    private boolean getOrUpdateTheStyle(String title) {
        boolean FAIL = true;
        boolean PASS = false;
        if (this.style == null) {
            this.style = this.loader.getUsedStyle();
        } else {
            try {
                this.style.ensureUpToDate();
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to reload style file '" + this.style.getPath() + "'", (Throwable)ex);
                String msg = Localization.lang("Unable to reload style file", new Object[0]) + "'" + this.style.getPath() + "'\n" + ex.getMessage();
                new OOError(title, msg, ex).showErrorDialog(this.dialogService);
                return true;
            }
        }
        return false;
    }

    private void initPanel() {
        this.connect.setOnAction(e -> this.connectAutomatically());
        this.manualConnect.setOnAction(e -> this.connectManually());
        this.selectDocument.setTooltip(new Tooltip(Localization.lang("Select which open Writer document to work on", new Object[0])));
        this.selectDocument.setOnAction(e -> this.ooBase.guiActionSelectDocument(false));
        this.setStyleFile.setMaxWidth(Double.MAX_VALUE);
        this.setStyleFile.setOnAction(event -> this.dialogService.showCustomDialogAndWait(new StyleSelectDialogView(this.loader)).ifPresent(selectedStyle -> {
            this.style = selectedStyle;
            try {
                this.style.ensureUpToDate();
            }
            catch (IOException e) {
                LOGGER.warn("Unable to reload style file '" + this.style.getPath() + "'", (Throwable)e);
            }
            this.dialogService.notify(Localization.lang("Current style is '%0'", this.style.getName()));
        }));
        this.pushEntries.setTooltip(new Tooltip(Localization.lang("Cite selected entries between parenthesis", new Object[0])));
        this.pushEntries.setOnAction(e -> this.pushEntries(CitationType.AUTHORYEAR_PAR, false));
        this.pushEntries.setMaxWidth(Double.MAX_VALUE);
        this.pushEntriesInt.setTooltip(new Tooltip(Localization.lang("Cite selected entries with in-text citation", new Object[0])));
        this.pushEntriesInt.setOnAction(e -> this.pushEntries(CitationType.AUTHORYEAR_INTEXT, false));
        this.pushEntriesInt.setMaxWidth(Double.MAX_VALUE);
        this.pushEntriesEmpty.setTooltip(new Tooltip(Localization.lang("Insert a citation without text (the entry will appear in the reference list)", new Object[0])));
        this.pushEntriesEmpty.setOnAction(e -> this.pushEntries(CitationType.INVISIBLE_CIT, false));
        this.pushEntriesEmpty.setMaxWidth(Double.MAX_VALUE);
        this.pushEntriesAdvanced.setTooltip(new Tooltip(Localization.lang("Cite selected entries with extra information", new Object[0])));
        this.pushEntriesAdvanced.setOnAction(e -> this.pushEntries(CitationType.AUTHORYEAR_INTEXT, true));
        this.pushEntriesAdvanced.setMaxWidth(Double.MAX_VALUE);
        this.update.setTooltip(new Tooltip(Localization.lang("Ensure that the bibliography is up-to-date", new Object[0])));
        this.update.setOnAction(event -> {
            String title = Localization.lang("Could not update bibliography", new Object[0]);
            if (this.getOrUpdateTheStyle(title)) {
                return;
            }
            List<BibDatabase> databases = this.getBaseList();
            this.ooBase.guiActionUpdateDocument(databases, this.style);
        });
        this.merge.setMaxWidth(Double.MAX_VALUE);
        this.merge.setTooltip(new Tooltip(Localization.lang("Combine pairs of citations that are separated by spaces only", new Object[0])));
        this.merge.setOnAction(e -> this.ooBase.guiActionMergeCitationGroups(this.getBaseList(), this.style));
        this.unmerge.setMaxWidth(Double.MAX_VALUE);
        this.unmerge.setTooltip(new Tooltip(Localization.lang("Separate merged citations", new Object[0])));
        this.unmerge.setOnAction(e -> this.ooBase.guiActionSeparateCitations(this.getBaseList(), this.style));
        ContextMenu settingsMenu = this.createSettingsPopup();
        this.settingsB.setMaxWidth(Double.MAX_VALUE);
        this.settingsB.setContextMenu(settingsMenu);
        this.settingsB.setOnAction(e -> settingsMenu.show((Node)this.settingsB, Side.BOTTOM, 0.0, 0.0));
        this.manageCitations.setMaxWidth(Double.MAX_VALUE);
        this.manageCitations.setOnAction(e -> {
            ManageCitationsDialogView dialog = new ManageCitationsDialogView(this.ooBase);
            if (dialog.isOkToShowThisDialog()) {
                this.dialogService.showCustomDialogAndWait(dialog);
            }
        });
        this.exportCitations.setMaxWidth(Double.MAX_VALUE);
        this.exportCitations.setOnAction(event -> this.exportEntries());
        this.updateButtonAvailability();
        HBox hbox = new HBox();
        hbox.getChildren().addAll((Object[])new Node[]{this.connect, this.manualConnect, this.selectDocument, this.update, this.help});
        hbox.getChildren().forEach(btn -> HBox.setHgrow((Node)btn, (Priority)Priority.ALWAYS));
        FlowPane flow = new FlowPane();
        flow.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        flow.setVgap(4.0);
        flow.setHgap(4.0);
        flow.setPrefWrapLength(200.0);
        flow.getChildren().addAll((Object[])new Node[]{this.setStyleFile, this.pushEntries, this.pushEntriesInt});
        flow.getChildren().addAll((Object[])new Node[]{this.pushEntriesAdvanced, this.pushEntriesEmpty, this.merge, this.unmerge});
        flow.getChildren().addAll((Object[])new Node[]{this.manageCitations, this.exportCitations, this.settingsB});
        this.vbox.setFillWidth(true);
        this.vbox.getChildren().addAll((Object[])new Node[]{hbox, flow});
    }

    private void exportEntries() {
        boolean returnPartialResult;
        List<BibDatabase> databases = this.getBaseList();
        Optional<BibDatabase> newDatabase = this.ooBase.exportCitedHelper(databases, returnPartialResult = false);
        if (newDatabase.isPresent()) {
            BibDatabaseContext databaseContext = new BibDatabaseContext(newDatabase.get());
            LibraryTab libraryTab = LibraryTab.createLibraryTab(databaseContext, this.tabContainer, this.dialogService, this.preferencesService, this.stateManager, this.fileUpdateMonitor, this.entryTypesManager, this.undoManager, this.clipBoardManager, this.taskExecutor);
            this.tabContainer.addTab(libraryTab, true);
        }
    }

    private List<BibDatabase> getBaseList() {
        ArrayList<BibDatabase> databases = new ArrayList<BibDatabase>();
        if (this.preferencesService.getOpenOfficePreferences().getUseAllDatabases()) {
            for (BibDatabaseContext database : this.stateManager.getOpenDatabases()) {
                databases.add(database.getDatabase());
            }
        } else {
            databases.add(this.stateManager.getActiveDatabase().map(BibDatabaseContext::getDatabase).orElse(new BibDatabase()));
        }
        return databases;
    }

    private void connectAutomatically() {
        DetectOpenOfficeInstallation officeInstallation = new DetectOpenOfficeInstallation(this.preferencesService.getOpenOfficePreferences(), this.dialogService);
        if (officeInstallation.isExecutablePathDefined()) {
            this.connect();
        } else {
            Task<List<Path>> taskConnectIfInstalled = new Task<List<Path>>(this){

                protected List<Path> call() {
                    return OpenOfficeFileSearch.detectInstallations();
                }
            };
            taskConnectIfInstalled.setOnSucceeded(arg_0 -> this.lambda$connectAutomatically$16((Task)taskConnectIfInstalled, officeInstallation, arg_0));
            taskConnectIfInstalled.setOnFailed(arg_0 -> this.lambda$connectAutomatically$17((Task)taskConnectIfInstalled, arg_0));
            this.dialogService.showProgressDialog(Localization.lang("Autodetecting paths...", new Object[0]), Localization.lang("Autodetecting paths...", new Object[0]), taskConnectIfInstalled);
            this.taskExecutor.execute(taskConnectIfInstalled);
        }
    }

    private void connectManually() {
        DirectoryDialogConfiguration fileDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(System.getProperty("user.home")).build();
        Optional<Path> selectedPath = this.dialogService.showDirectorySelectionDialog(fileDialogConfiguration);
        DetectOpenOfficeInstallation officeInstallation = new DetectOpenOfficeInstallation(this.preferencesService.getOpenOfficePreferences(), this.dialogService);
        if (selectedPath.isPresent()) {
            BackgroundTask.wrap(() -> officeInstallation.setOpenOfficePreferences((Path)selectedPath.get())).withInitialMessage("Searching for executable").onFailure(this.dialogService::showErrorDialogAndWait).onSuccess(value -> {
                if (value.booleanValue()) {
                    this.connect();
                } else {
                    this.dialogService.showErrorDialogAndWait(Localization.lang("Could not connect to running OpenOffice/LibreOffice.", new Object[0]), Localization.lang("If connecting manually, please verify program and library paths.", new Object[0]));
                }
            }).executeWith(this.taskExecutor);
        } else {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Could not connect to running OpenOffice/LibreOffice.", new Object[0]), Localization.lang("If connecting manually, please verify program and library paths.", new Object[0]));
        }
    }

    private void updateButtonAvailability() {
        boolean isConnected = this.ooBase != null;
        boolean isConnectedToDocument = isConnected && !this.ooBase.isDocumentConnectionMissing();
        boolean hasStyle = true;
        boolean hasDatabase = true;
        boolean hasSelectedBibEntry = true;
        this.selectDocument.setDisable(!isConnected);
        this.pushEntries.setDisable(!isConnectedToDocument || !hasStyle || !hasDatabase);
        boolean canCite = isConnectedToDocument && hasStyle && hasSelectedBibEntry;
        this.pushEntriesInt.setDisable(!canCite);
        this.pushEntriesEmpty.setDisable(!canCite);
        this.pushEntriesAdvanced.setDisable(!canCite);
        boolean canRefreshDocument = isConnectedToDocument && hasStyle;
        this.update.setDisable(!canRefreshDocument);
        this.merge.setDisable(!canRefreshDocument);
        this.unmerge.setDisable(!canRefreshDocument);
        this.manageCitations.setDisable(!canRefreshDocument);
        this.exportCitations.setDisable(!isConnectedToDocument || !hasDatabase);
    }

    private void connect() {
        Task<OOBibBase> connectTask = new Task<OOBibBase>(){

            protected OOBibBase call() throws Exception {
                this.updateProgress(-1.0, -1.0);
                Path path = Path.of(OpenOfficePanel.this.preferencesService.getOpenOfficePreferences().getExecutablePath(), new String[0]);
                return OpenOfficePanel.this.createBibBase(path);
            }
        };
        connectTask.setOnSucceeded(arg_0 -> this.lambda$connect$20((Task)connectTask, arg_0));
        connectTask.setOnFailed(arg_0 -> this.lambda$connect$21((Task)connectTask, arg_0));
        this.dialogService.showProgressDialog(Localization.lang("Autodetecting paths...", new Object[0]), Localization.lang("Autodetecting paths...", new Object[0]), connectTask);
        this.taskExecutor.execute(connectTask);
    }

    private OOBibBase createBibBase(Path loPath) throws BootstrapException, CreationException {
        return new OOBibBase(loPath, this.dialogService);
    }

    private static CitationType citationTypeFromOptions(boolean withText, boolean inParenthesis) {
        if (!withText) {
            return CitationType.INVISIBLE_CIT;
        }
        return inParenthesis ? CitationType.AUTHORYEAR_PAR : CitationType.AUTHORYEAR_INTEXT;
    }

    private void pushEntries(CitationType citationType, boolean addPageInfo) {
        String errorDialogTitle = Localization.lang("Error pushing entries", new Object[0]);
        if (this.stateManager.getActiveDatabase().isEmpty() || this.stateManager.getActiveDatabase().get().getDatabase() == null) {
            OOError.noDataBaseIsOpenForCiting().setTitle(errorDialogTitle).showErrorDialog(this.dialogService);
            return;
        }
        BibDatabase database = this.stateManager.getActiveDatabase().get().getDatabase();
        if (database == null) {
            OOError.noDataBaseIsOpenForCiting().setTitle(errorDialogTitle).showErrorDialog(this.dialogService);
            return;
        }
        ObservableList<BibEntry> entries = this.stateManager.getSelectedEntries();
        if (entries.isEmpty()) {
            OOError.noEntriesSelectedForCitation().setTitle(errorDialogTitle).showErrorDialog(this.dialogService);
            return;
        }
        if (this.getOrUpdateTheStyle(errorDialogTitle)) {
            return;
        }
        String pageInfo = null;
        if (addPageInfo) {
            boolean withText = citationType.withText();
            Optional<AdvancedCiteDialogViewModel> citeDialogViewModel = this.dialogService.showCustomDialogAndWait(new AdvancedCiteDialogView());
            if (citeDialogViewModel.isPresent()) {
                AdvancedCiteDialogViewModel model = citeDialogViewModel.get();
                if (!model.pageInfoProperty().getValue().isEmpty()) {
                    pageInfo = model.pageInfoProperty().getValue();
                }
                citationType = OpenOfficePanel.citationTypeFromOptions(withText, model.citeInParProperty().getValue());
            } else {
                return;
            }
        }
        if (!this.checkThatEntriesHaveKeys((List<BibEntry>)entries)) {
            return;
        }
        Optional<Update.SyncOptions> syncOptions = this.preferencesService.getOpenOfficePreferences().getSyncWhenCiting() ? Optional.of(new Update.SyncOptions(this.getBaseList())) : Optional.empty();
        this.ooBase.guiActionInsertEntry((List<BibEntry>)entries, database, this.style, citationType, pageInfo, syncOptions);
    }

    private boolean checkThatEntriesHaveKeys(List<BibEntry> entries) {
        boolean emptyKeys = false;
        for (BibEntry entry : entries) {
            if (!entry.getCitationKey().isEmpty()) continue;
            emptyKeys = true;
            break;
        }
        if (!emptyKeys) {
            return true;
        }
        boolean citePressed = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Cite", new Object[0]), Localization.lang("Cannot cite entries without citation keys. Generate keys now?", new Object[0]), Localization.lang("Generate keys", new Object[0]), Localization.lang("Cancel", new Object[0]));
        Optional<BibDatabaseContext> databaseContext = this.stateManager.getActiveDatabase();
        if (citePressed && databaseContext.isPresent()) {
            CitationKeyPatternPreferences prefs = this.preferencesService.getCitationKeyPatternPreferences();
            NamedCompound undoCompound = new NamedCompound(Localization.lang("Cite", new Object[0]));
            for (BibEntry entry : entries) {
                if (!entry.getCitationKey().isEmpty()) continue;
                new CitationKeyGenerator(databaseContext.get(), prefs).generateAndSetKey(entry).ifPresent(change -> undoCompound.addEdit(new UndoableKeyChange((FieldChange)change)));
            }
            undoCompound.end();
            this.undoManager.addEdit(undoCompound);
            return true;
        }
        return false;
    }

    private ContextMenu createSettingsPopup() {
        OpenOfficePreferences openOfficePreferences = this.preferencesService.getOpenOfficePreferences();
        ContextMenu contextMenu = new ContextMenu();
        CheckMenuItem autoSync = new CheckMenuItem(Localization.lang("Automatically sync bibliography when inserting citations", new Object[0]));
        autoSync.selectedProperty().set(this.preferencesService.getOpenOfficePreferences().getSyncWhenCiting());
        ToggleGroup toggleGroup = new ToggleGroup();
        RadioMenuItem useActiveBase = new RadioMenuItem(Localization.lang("Look up BibTeX entries in the active tab only", new Object[0]));
        RadioMenuItem useAllBases = new RadioMenuItem(Localization.lang("Look up BibTeX entries in all open libraries", new Object[0]));
        useActiveBase.setToggleGroup(toggleGroup);
        useAllBases.setToggleGroup(toggleGroup);
        MenuItem clearConnectionSettings = new MenuItem(Localization.lang("Clear connection settings", new Object[0]));
        if (openOfficePreferences.getUseAllDatabases()) {
            useAllBases.setSelected(true);
        } else {
            useActiveBase.setSelected(true);
        }
        autoSync.setOnAction(e -> openOfficePreferences.setSyncWhenCiting(autoSync.isSelected()));
        useAllBases.setOnAction(e -> openOfficePreferences.setUseAllDatabases(useAllBases.isSelected()));
        useActiveBase.setOnAction(e -> openOfficePreferences.setUseAllDatabases(!useActiveBase.isSelected()));
        clearConnectionSettings.setOnAction(e -> {
            openOfficePreferences.clearConnectionSettings();
            this.dialogService.notify(Localization.lang("Cleared connection settings", new Object[0]));
        });
        contextMenu.getItems().addAll((Object[])new MenuItem[]{autoSync, new SeparatorMenuItem(), useActiveBase, useAllBases, new SeparatorMenuItem(), clearConnectionSettings});
        return contextMenu;
    }

    private /* synthetic */ void lambda$connect$21(Task connectTask, WorkerStateEvent value) {
        Throwable ex = connectTask.getException();
        LOGGER.error("autodetect failed", ex);
        if (ex instanceof UnsatisfiedLinkError) {
            LOGGER.warn("Could not connect to running OpenOffice/LibreOffice", ex);
            this.dialogService.showErrorDialogAndWait(Localization.lang("Unable to connect. One possible reason is that JabRef and OpenOffice/LibreOffice are not both running in either 32 bit mode or 64 bit mode.", new Object[0]));
        } else if (ex instanceof IOException) {
            LOGGER.warn("Could not connect to running OpenOffice/LibreOffice", ex);
            this.dialogService.showErrorDialogAndWait(Localization.lang("Could not connect to running OpenOffice/LibreOffice.", new Object[0]), Localization.lang("Could not connect to running OpenOffice/LibreOffice.", new Object[0]) + "\n" + Localization.lang("Make sure you have installed OpenOffice/LibreOffice with Java support.", new Object[0]) + "\n" + Localization.lang("If connecting manually, please verify program and library paths.", new Object[0]) + "\n\n" + Localization.lang("Error message:", new Object[0]), ex);
        } else if (ex instanceof BootstrapException) {
            BootstrapException bootstrapEx = (BootstrapException)ex;
            LOGGER.error("Exception boostrap cause", (Throwable)bootstrapEx.getTargetException());
            this.dialogService.showErrorDialogAndWait("Bootstrap error", bootstrapEx.getTargetException());
        } else {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Autodetection failed", new Object[0]), Localization.lang("Autodetection failed", new Object[0]), ex);
        }
    }

    private /* synthetic */ void lambda$connect$20(Task connectTask, WorkerStateEvent value) {
        this.ooBase = (OOBibBase)connectTask.getValue();
        this.ooBase.guiActionSelectDocument(true);
        this.updateButtonAvailability();
    }

    private /* synthetic */ void lambda$connectAutomatically$17(Task taskConnectIfInstalled, WorkerStateEvent value) {
        this.dialogService.showErrorDialogAndWait(Localization.lang("Autodetection failed", new Object[0]), Localization.lang("Autodetection failed", new Object[0]), taskConnectIfInstalled.getException());
    }

    private /* synthetic */ void lambda$connectAutomatically$16(Task taskConnectIfInstalled, DetectOpenOfficeInstallation officeInstallation, WorkerStateEvent evt) {
        Optional<Path> chosenInstallationDirectory;
        ArrayList<Path> installations = new ArrayList<Path>((Collection)taskConnectIfInstalled.getValue());
        if (installations.isEmpty()) {
            officeInstallation.selectInstallationPath().ifPresent(installations::add);
        }
        if ((chosenInstallationDirectory = officeInstallation.chooseAmongInstallations(installations)).isPresent() && officeInstallation.setOpenOfficePreferences(chosenInstallationDirectory.get())) {
            this.connect();
        }
    }
}

