/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.controlsfx.control.textfield.CustomTextField;
import org.jabref.gui.DialogService;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesDialogViewModel;
import org.jabref.gui.preferences.PreferencesSearchHandler;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.PreferencesService;

public class PreferencesDialogView
extends BaseDialog<PreferencesDialogViewModel> {
    @FXML
    private CustomTextField searchBox;
    @FXML
    private ListView<PreferencesTab> preferenceTabList;
    @FXML
    private ScrollPane preferencesContainer;
    @FXML
    private ButtonType saveButton;
    @FXML
    private ToggleButton memoryStickMode;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private ThemeManager themeManager;
    private PreferencesDialogViewModel viewModel;
    private final Class<? extends PreferencesTab> preferencesTabToSelectClass;

    public PreferencesDialogView(Class<? extends PreferencesTab> preferencesTabToSelectClass) {
        this.setTitle(Localization.lang("JabRef preferences", new Object[0]));
        this.preferencesTabToSelectClass = preferencesTabToSelectClass;
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        ControlHelper.setAction(this.saveButton, this.getDialogPane(), event -> this.savePreferencesAndCloseDialog());
        this.searchBox.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                event.consume();
            }
        });
        this.themeManager.updateFontStyle(this.getDialogPane().getScene());
    }

    public PreferencesDialogViewModel getViewModel() {
        return this.viewModel;
    }

    @FXML
    private void initialize() {
        this.viewModel = new PreferencesDialogViewModel(this.dialogService, this.preferencesService);
        this.preferenceTabList.itemsProperty().setValue(this.viewModel.getPreferenceTabs());
        this.preferenceTabList.setOnKeyReleased(key -> {
            if (this.preferencesService.getKeyBindingRepository().checkKeyCombinationEquality(KeyBinding.CLOSE, (KeyEvent)key)) {
                this.closeDialog();
            }
        });
        PreferencesSearchHandler searchHandler = new PreferencesSearchHandler((List<PreferencesTab>)this.viewModel.getPreferenceTabs());
        this.preferenceTabList.itemsProperty().bindBidirectional(searchHandler.filteredPreferenceTabsProperty());
        this.searchBox.textProperty().addListener((observable, previousText, newText) -> {
            searchHandler.filterTabs(newText.toLowerCase(Locale.ROOT));
            this.preferenceTabList.getSelectionModel().clearSelection();
            this.preferenceTabList.getSelectionModel().selectFirst();
        });
        this.searchBox.setPromptText(Localization.lang("Search", new Object[0]) + "...");
        this.searchBox.setLeft(IconTheme.JabRefIcons.SEARCH.getGraphicNode());
        EasyBind.subscribe((ObservableValue)this.preferenceTabList.getSelectionModel().selectedItemProperty(), tab -> {
            if (tab instanceof AbstractPreferenceTabView) {
                AbstractPreferenceTabView preferencesTab = (AbstractPreferenceTabView)tab;
                this.preferencesContainer.setContent(preferencesTab.getBuilder());
                preferencesTab.prefWidthProperty().bind((ObservableValue)this.preferencesContainer.widthProperty().subtract(10.0));
                preferencesTab.getStyleClass().add((Object)"preferencesTab");
            } else {
                this.preferencesContainer.setContent(null);
            }
        });
        if (this.preferencesTabToSelectClass != null) {
            Optional<PreferencesTab> tabToSelectIfExist = this.preferenceTabList.getItems().stream().filter(prefTab -> prefTab.getClass().equals(this.preferencesTabToSelectClass)).findFirst();
            tabToSelectIfExist.ifPresent(preferencesTab -> this.preferenceTabList.getSelectionModel().select(preferencesTab));
        } else {
            this.preferenceTabList.getSelectionModel().selectFirst();
        }
        new ViewModelListCellFactory().withText(PreferencesTab::getTabName).install(this.preferenceTabList);
        this.memoryStickMode.selectedProperty().bindBidirectional((Property)this.viewModel.getMemoryStickProperty());
        this.viewModel.setValues();
    }

    @FXML
    private void closeDialog() {
        this.close();
    }

    @FXML
    private void savePreferencesAndCloseDialog() {
        if (this.viewModel.validSettings()) {
            this.viewModel.storeAllSettings();
            this.closeDialog();
        }
    }

    @FXML
    void exportPreferences() {
        this.viewModel.exportPreferences();
    }

    @FXML
    void importPreferences() {
        this.viewModel.importPreferences();
    }

    @FXML
    void showAllPreferences() {
        this.viewModel.showPreferences();
    }

    @FXML
    void resetPreferences() {
        this.viewModel.resetPreferences();
    }
}

