/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.autocompletion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.util.StringConverter;
import org.jabref.gui.autocompleter.AutoCompleteFirstNameMode;
import org.jabref.gui.autocompleter.AutoCompletePreferences;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;

public class AutoCompletionTabViewModel
implements PreferenceTabViewModel {
    private final BooleanProperty enableAutoCompleteProperty = new SimpleBooleanProperty();
    private final ListProperty<Field> autoCompleteFieldsProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final BooleanProperty autoCompleteFirstLastProperty = new SimpleBooleanProperty();
    private final BooleanProperty autoCompleteLastFirstProperty = new SimpleBooleanProperty();
    private final BooleanProperty autoCompleteBothProperty = new SimpleBooleanProperty();
    private final BooleanProperty firstNameModeAbbreviatedProperty = new SimpleBooleanProperty();
    private final BooleanProperty firstNameModeFullProperty = new SimpleBooleanProperty();
    private final BooleanProperty firstNameModeBothProperty = new SimpleBooleanProperty();
    private final AutoCompletePreferences autoCompletePreferences;
    private final List<String> restartWarnings = new ArrayList<String>();

    public AutoCompletionTabViewModel(AutoCompletePreferences autoCompletePreferences) {
        this.autoCompletePreferences = autoCompletePreferences;
    }

    @Override
    public void setValues() {
        this.enableAutoCompleteProperty.setValue(Boolean.valueOf(this.autoCompletePreferences.shouldAutoComplete()));
        this.autoCompleteFieldsProperty.setValue(FXCollections.observableArrayList(this.autoCompletePreferences.getCompleteFields()));
        if (this.autoCompletePreferences.getNameFormat() == AutoCompletePreferences.NameFormat.FIRST_LAST) {
            this.autoCompleteFirstLastProperty.setValue(Boolean.valueOf(true));
        } else if (this.autoCompletePreferences.getNameFormat() == AutoCompletePreferences.NameFormat.LAST_FIRST) {
            this.autoCompleteLastFirstProperty.setValue(Boolean.valueOf(true));
        } else {
            this.autoCompleteBothProperty.setValue(Boolean.valueOf(true));
        }
        switch (this.autoCompletePreferences.getFirstNameMode()) {
            case ONLY_ABBREVIATED: {
                this.firstNameModeAbbreviatedProperty.setValue(Boolean.valueOf(true));
                break;
            }
            case ONLY_FULL: {
                this.firstNameModeFullProperty.setValue(Boolean.valueOf(true));
                break;
            }
            default: {
                this.firstNameModeBothProperty.setValue(Boolean.valueOf(true));
            }
        }
    }

    @Override
    public void storeSettings() {
        this.autoCompletePreferences.setAutoComplete(this.enableAutoCompleteProperty.getValue());
        if (this.autoCompleteBothProperty.getValue().booleanValue()) {
            this.autoCompletePreferences.setNameFormat(AutoCompletePreferences.NameFormat.BOTH);
        } else if (this.autoCompleteFirstLastProperty.getValue().booleanValue()) {
            this.autoCompletePreferences.setNameFormat(AutoCompletePreferences.NameFormat.FIRST_LAST);
        } else if (this.autoCompleteLastFirstProperty.getValue().booleanValue()) {
            this.autoCompletePreferences.setNameFormat(AutoCompletePreferences.NameFormat.LAST_FIRST);
        }
        if (this.firstNameModeBothProperty.getValue().booleanValue()) {
            this.autoCompletePreferences.setFirstNameMode(AutoCompleteFirstNameMode.BOTH);
        } else if (this.firstNameModeAbbreviatedProperty.getValue().booleanValue()) {
            this.autoCompletePreferences.setFirstNameMode(AutoCompleteFirstNameMode.ONLY_ABBREVIATED);
        } else if (this.firstNameModeFullProperty.getValue().booleanValue()) {
            this.autoCompletePreferences.setFirstNameMode(AutoCompleteFirstNameMode.ONLY_FULL);
        }
        if (this.autoCompletePreferences.shouldAutoComplete() != this.enableAutoCompleteProperty.getValue().booleanValue()) {
            if (this.enableAutoCompleteProperty.getValue().booleanValue()) {
                this.restartWarnings.add(Localization.lang("Auto complete enabled.", new Object[0]));
            } else {
                this.restartWarnings.add(Localization.lang("Auto complete disabled.", new Object[0]));
            }
        }
        this.autoCompletePreferences.getCompleteFields().clear();
        this.autoCompletePreferences.getCompleteFields().addAll((Collection)this.autoCompleteFieldsProperty.getValue());
    }

    @Override
    public List<String> getRestartWarnings() {
        return this.restartWarnings;
    }

    public BooleanProperty enableAutoCompleteProperty() {
        return this.enableAutoCompleteProperty;
    }

    public ListProperty<Field> autoCompleteFieldsProperty() {
        return this.autoCompleteFieldsProperty;
    }

    public BooleanProperty autoCompleteFirstLastProperty() {
        return this.autoCompleteFirstLastProperty;
    }

    public BooleanProperty autoCompleteLastFirstProperty() {
        return this.autoCompleteLastFirstProperty;
    }

    public BooleanProperty autoCompleteBothProperty() {
        return this.autoCompleteBothProperty;
    }

    public BooleanProperty firstNameModeAbbreviatedProperty() {
        return this.firstNameModeAbbreviatedProperty;
    }

    public BooleanProperty firstNameModeFullProperty() {
        return this.firstNameModeFullProperty;
    }

    public BooleanProperty firstNameModeBothProperty() {
        return this.firstNameModeBothProperty;
    }

    public StringConverter<Field> getFieldStringConverter() {
        return new StringConverter<Field>(this){

            public String toString(Field field) {
                return field.getDisplayName();
            }

            public Field fromString(String string) {
                return FieldFactory.parseField(string);
            }
        };
    }

    public List<Field> getSuggestions(String request) {
        return FieldFactory.getAllFieldsWithOutInternal().stream().filter(field -> field.getDisplayName().toLowerCase().contains(request.toLowerCase())).collect(Collectors.toList());
    }
}

