/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.customentrytypes;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import jakarta.inject.Inject;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import org.jabref.gui.DragAndDropDataFormats;
import org.jabref.gui.StateManager;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.customentrytypes.CustomEntryTypeViewModel;
import org.jabref.gui.preferences.customentrytypes.CustomEntryTypesTabViewModel;
import org.jabref.gui.preferences.customentrytypes.EntryTypeViewModel;
import org.jabref.gui.preferences.customentrytypes.FieldViewModel;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.CustomLocalDragboard;
import org.jabref.gui.util.FieldsUtil;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.gui.util.ViewModelTableRowFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.Field;

public class CustomEntryTypesTab
extends AbstractPreferenceTabView<CustomEntryTypesTabViewModel>
implements PreferencesTab {
    @FXML
    private TableView<EntryTypeViewModel> entryTypesTable;
    @FXML
    private TableColumn<EntryTypeViewModel, String> entryTypColumn;
    @FXML
    private TableColumn<EntryTypeViewModel, String> entryTypeActionsColumn;
    @FXML
    private TextField addNewEntryType;
    @FXML
    private TableView<FieldViewModel> fields;
    @FXML
    private TableColumn<FieldViewModel, String> fieldNameColumn;
    @FXML
    private TableColumn<FieldViewModel, Boolean> fieldTypeColumn;
    @FXML
    private TableColumn<FieldViewModel, String> fieldTypeActionColumn;
    @FXML
    private TableColumn<FieldViewModel, Boolean> fieldTypeMultilineColumn;
    @FXML
    private ComboBox<Field> addNewField;
    @FXML
    private Button addNewEntryTypeButton;
    @FXML
    private Button addNewFieldButton;
    @Inject
    private StateManager stateManager;
    private final ControlsFxVisualizer visualizer = new ControlsFxVisualizer();
    private CustomLocalDragboard localDragboard;

    public CustomEntryTypesTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Entry types", new Object[0]);
    }

    public void initialize() {
        BibDatabaseMode mode = this.stateManager.getActiveDatabase().map(BibDatabaseContext::getMode).orElse(this.preferencesService.getLibraryPreferences().getDefaultBibDatabaseMode());
        BibEntryTypesManager entryTypesRepository = this.preferencesService.getCustomEntryTypesRepository();
        this.viewModel = new CustomEntryTypesTabViewModel(mode, entryTypesRepository, this.dialogService, this.preferencesService);
        this.localDragboard = this.stateManager.getLocalDragboard();
        this.setupEntryTypesTable();
        this.setupFieldsTable();
        this.addNewEntryTypeButton.disableProperty().bind((ObservableValue)((CustomEntryTypesTabViewModel)this.viewModel).entryTypeValidationStatus().validProperty().not());
        this.addNewFieldButton.disableProperty().bind((ObservableValue)((CustomEntryTypesTabViewModel)this.viewModel).fieldValidationStatus().validProperty().not().or((ObservableBooleanValue)((CustomEntryTypesTabViewModel)this.viewModel).selectedEntryTypeProperty().isNull()));
        Platform.runLater(() -> {
            this.visualizer.initVisualization(((CustomEntryTypesTabViewModel)this.viewModel).entryTypeValidationStatus(), (Control)this.addNewEntryType, true);
            this.visualizer.initVisualization(((CustomEntryTypesTabViewModel)this.viewModel).fieldValidationStatus(), this.addNewField, true);
        });
    }

    private void setupEntryTypesTable() {
        this.fields.setEditable(true);
        this.entryTypColumn.setCellValueFactory(cellData -> new ReadOnlyStringWrapper(((BibEntryType)((EntryTypeViewModel)cellData.getValue()).entryType().get()).getType().getDisplayName()));
        this.entryTypesTable.setItems(((CustomEntryTypesTabViewModel)this.viewModel).entryTypes());
        this.entryTypesTable.getSelectionModel().selectFirst();
        this.entryTypeActionsColumn.setSortable(false);
        this.entryTypeActionsColumn.setReorderable(false);
        this.entryTypeActionsColumn.setCellValueFactory(cellData -> new ReadOnlyStringWrapper(((BibEntryType)((EntryTypeViewModel)cellData.getValue()).entryType().get()).getType().getDisplayName()));
        new ValueTableCellFactory<EntryTypeViewModel, String>().withGraphic((type, name) -> {
            if (type instanceof CustomEntryTypeViewModel) {
                return IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode();
            }
            return null;
        }).withTooltip((type, name) -> {
            if (type instanceof CustomEntryTypeViewModel) {
                return Localization.lang("Remove entry type", new Object[0]) + " " + name;
            }
            return null;
        }).withOnMouseClickedEvent((type, name) -> {
            if (type instanceof CustomEntryTypeViewModel) {
                return evt -> ((CustomEntryTypesTabViewModel)this.viewModel).removeEntryType((EntryTypeViewModel)this.entryTypesTable.getSelectionModel().getSelectedItem());
            }
            return evt -> {};
        }).install(this.entryTypeActionsColumn);
        ((CustomEntryTypesTabViewModel)this.viewModel).selectedEntryTypeProperty().bind((ObservableValue)this.entryTypesTable.getSelectionModel().selectedItemProperty());
        ((CustomEntryTypesTabViewModel)this.viewModel).entryTypeToAddProperty().bindBidirectional((Property)this.addNewEntryType.textProperty());
        EasyBind.subscribe(((CustomEntryTypesTabViewModel)this.viewModel).selectedEntryTypeProperty(), type -> {
            if (type != null) {
                ObservableList<FieldViewModel> items = type.fields();
                this.fields.setItems(items);
            } else {
                this.fields.setItems(null);
            }
        });
    }

    private void setupFieldsTable() {
        this.fieldNameColumn.setCellValueFactory(item -> ((FieldViewModel)item.getValue()).displayNameProperty());
        this.fieldNameColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.fieldNameColumn.setEditable(true);
        this.fieldNameColumn.setOnEditCommit(event -> {
            boolean fieldExists;
            String newDisplayName = (String)event.getNewValue();
            if (newDisplayName.isBlank()) {
                this.dialogService.notify(Localization.lang("Name cannot be empty", new Object[0]));
                event.getTableView().edit(-1, null);
                event.getTableView().refresh();
                return;
            }
            FieldViewModel fieldViewModel = (FieldViewModel)event.getRowValue();
            String currentDisplayName = fieldViewModel.displayNameProperty().getValue();
            EntryTypeViewModel selectedEntryType = (EntryTypeViewModel)((CustomEntryTypesTabViewModel)this.viewModel).selectedEntryTypeProperty().get();
            ObservableList<FieldViewModel> entryFields = selectedEntryType.fields();
            boolean bl = fieldExists = !newDisplayName.equals(currentDisplayName) && ((CustomEntryTypesTabViewModel)this.viewModel).displayNameExists(newDisplayName);
            if (fieldExists) {
                this.dialogService.notify(Localization.lang("Unable to change field name. \"%0\" already in use.", newDisplayName));
                event.getTableView().edit(-1, null);
            } else {
                fieldViewModel.displayNameProperty().setValue(newDisplayName);
            }
            event.getTableView().refresh();
        });
        this.fieldTypeColumn.setCellFactory(CheckBoxTableCell.forTableColumn(this.fieldTypeColumn));
        this.fieldTypeColumn.setCellValueFactory(item -> ((FieldViewModel)item.getValue()).requiredProperty());
        this.makeRotatedColumnHeader(this.fieldTypeColumn, Localization.lang("Required", new Object[0]));
        this.fieldTypeMultilineColumn.setCellFactory(CheckBoxTableCell.forTableColumn(this.fieldTypeMultilineColumn));
        this.fieldTypeMultilineColumn.setCellValueFactory(item -> ((FieldViewModel)item.getValue()).multilineProperty());
        this.makeRotatedColumnHeader(this.fieldTypeMultilineColumn, Localization.lang("Multiline", new Object[0]));
        this.fieldTypeActionColumn.setSortable(false);
        this.fieldTypeActionColumn.setReorderable(false);
        this.fieldTypeActionColumn.setEditable(false);
        this.fieldTypeActionColumn.setCellValueFactory(cellData -> ((FieldViewModel)cellData.getValue()).displayNameProperty());
        new ValueTableCellFactory().withGraphic(item -> IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode()).withTooltip(name -> Localization.lang("Remove field %0 from currently selected entry type", name)).withOnMouseClickedEvent(item -> evt -> ((CustomEntryTypesTabViewModel)this.viewModel).removeField((FieldViewModel)this.fields.getSelectionModel().getSelectedItem())).install(this.fieldTypeActionColumn);
        new ViewModelTableRowFactory().setOnDragDetected(this::handleOnDragDetected).setOnDragDropped(this::handleOnDragDropped).setOnDragOver(this::handleOnDragOver).setOnDragExited(this::handleOnDragExited).install(this.fields);
        this.addNewField.setItems(((CustomEntryTypesTabViewModel)this.viewModel).fieldsForAdding());
        this.addNewField.setConverter(FieldsUtil.FIELD_STRING_CONVERTER);
        ((CustomEntryTypesTabViewModel)this.viewModel).newFieldToAddProperty().bindBidirectional((Property)this.addNewField.valueProperty());
        EasyBind.subscribe((ObservableValue)this.addNewField.getEditor().textProperty(), text -> this.addNewField.setValue((Object)((Field)FieldsUtil.FIELD_STRING_CONVERTER.fromString(text))));
    }

    private void makeRotatedColumnHeader(TableColumn<?, ?> column, String text) {
        Label label = new Label();
        label.setText(text);
        label.setRotate(-90.0);
        label.setMinWidth(80.0);
        column.setGraphic((Node)new Group(new Node[]{label}));
        column.getStyleClass().add((Object)"rotated");
    }

    private void handleOnDragOver(TableRow<FieldViewModel> row, FieldViewModel originalItem, DragEvent event) {
        if (event.getGestureSource() != originalItem && event.getDragboard().hasContent(DragAndDropDataFormats.FIELD)) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            ControlHelper.setDroppingPseudoClasses(row, event);
        }
    }

    private void handleOnDragDetected(TableRow<FieldViewModel> row, FieldViewModel fieldViewModel, MouseEvent event) {
        row.startFullDrag();
        FieldViewModel field = (FieldViewModel)this.fields.getSelectionModel().getSelectedItem();
        ClipboardContent content = new ClipboardContent();
        Dragboard dragboard = this.fields.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
        content.put((Object)DragAndDropDataFormats.FIELD, (Object)"");
        this.localDragboard.putValue(FieldViewModel.class, field);
        dragboard.setContent((Map)content);
        event.consume();
    }

    private void handleOnDragDropped(TableRow<FieldViewModel> row, FieldViewModel originalItem, DragEvent event) {
        if (this.localDragboard.hasType(FieldViewModel.class)) {
            FieldViewModel field = this.localDragboard.getValue(FieldViewModel.class);
            this.fields.getItems().remove((Object)field);
            if (row.isEmpty()) {
                this.fields.getItems().add((Object)field);
            } else {
                int offset = event.getY() > row.getHeight() / 2.0 ? 1 : 0;
                this.fields.getItems().add(row.getIndex() + offset, (Object)field);
            }
        }
        event.setDropCompleted(true);
        event.consume();
    }

    private void handleOnDragExited(TableRow<FieldViewModel> row, FieldViewModel fieldViewModel, DragEvent dragEvent) {
        ControlHelper.removeDroppingPseudoClasses(row);
    }

    @FXML
    void addEntryType() {
        EntryTypeViewModel newlyAdded = ((CustomEntryTypesTabViewModel)this.viewModel).addNewCustomEntryType();
        this.entryTypesTable.getSelectionModel().select((Object)newlyAdded);
        this.entryTypesTable.scrollTo((Object)newlyAdded);
    }

    @FXML
    void addNewField() {
        ((CustomEntryTypesTabViewModel)this.viewModel).addNewField();
    }

    @FXML
    void resetEntryTypes() {
        boolean reset = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Reset entry types and fields to defaults", new Object[0]), Localization.lang("This will reset all entry types to their default values and remove all custom entry types", new Object[0]), Localization.lang("Reset to default", new Object[0]));
        if (reset) {
            ((CustomEntryTypesTabViewModel)this.viewModel).resetAllCustomEntryTypes();
            this.fields.getSelectionModel().clearSelection();
            this.entryTypesTable.getSelectionModel().clearSelection();
            ((CustomEntryTypesTabViewModel)this.viewModel).setValues();
            this.entryTypesTable.refresh();
        }
    }
}

