/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.customentrytypes;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.preferences.customentrytypes.FieldViewModel;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.field.Field;

public class EntryTypeViewModel {
    private final ObjectProperty<BibEntryType> entryType = new SimpleObjectProperty();
    private final ObservableList<FieldViewModel> fields;

    public EntryTypeViewModel(BibEntryType entryType, Predicate<Field> isMultiline) {
        this.entryType.set((Object)entryType);
        List allFieldsForType = entryType.getAllBibFields().stream().map(bibField -> new FieldViewModel(bibField.field(), entryType.isRequired(bibField.field()) ? FieldViewModel.Mandatory.REQUIRED : FieldViewModel.Mandatory.OPTIONAL, bibField.priority(), isMultiline.test(bibField.field()))).collect(Collectors.toList());
        this.fields = FXCollections.observableArrayList(allFieldsForType);
    }

    public int hashCode() {
        return Objects.hash(this.entryType, this.fields);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntryTypeViewModel)) {
            return false;
        }
        EntryTypeViewModel other = (EntryTypeViewModel)obj;
        return Objects.equals(this.entryType, other.entryType) && Objects.equals(this.fields, other.fields);
    }

    public void addField(FieldViewModel field) {
        this.fields.add((Object)field);
    }

    public ObservableList<FieldViewModel> fields() {
        return this.fields;
    }

    public ObjectProperty<BibEntryType> entryType() {
        return this.entryType;
    }

    public void removeField(FieldViewModel focusedItem) {
        this.fields.remove((Object)focusedItem);
    }

    public String toString() {
        return "CustomEntryTypeViewModel [entryType=" + String.valueOf(this.entryType) + ", fields=" + String.valueOf(this.fields) + "]";
    }
}

