/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.customexporter;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.DialogService;
import org.jabref.gui.exporter.CreateModifyExporterDialogView;
import org.jabref.gui.exporter.ExporterViewModel;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.logic.exporter.TemplateExporter;
import org.jabref.preferences.PreferencesService;

public class CustomExporterTabViewModel
implements PreferenceTabViewModel {
    private final ListProperty<ExporterViewModel> exporters = new SimpleListProperty(FXCollections.observableArrayList());
    private final ListProperty<ExporterViewModel> selectedExporters = new SimpleListProperty(FXCollections.observableArrayList());
    private final PreferencesService preferences;
    private final DialogService dialogService;

    public CustomExporterTabViewModel(PreferencesService preferences, DialogService dialogService) {
        this.preferences = preferences;
        this.dialogService = dialogService;
    }

    @Override
    public void setValues() {
        ObservableList<TemplateExporter> exportersLogic = this.preferences.getExportPreferences().getCustomExporters();
        this.exporters.clear();
        for (TemplateExporter exporter : exportersLogic) {
            this.exporters.add((Object)new ExporterViewModel(exporter));
        }
    }

    @Override
    public void storeSettings() {
        List<TemplateExporter> exportersLogic = this.exporters.stream().map(ExporterViewModel::getLogic).collect(Collectors.toList());
        this.preferences.getExportPreferences().setCustomExporters(exportersLogic);
    }

    public void addExporter() {
        CreateModifyExporterDialogView dialog = new CreateModifyExporterDialogView(null);
        Optional<ExporterViewModel> exporter = this.dialogService.showCustomDialogAndWait(dialog);
        if (exporter != null && exporter.isPresent()) {
            this.exporters.add((Object)exporter.get());
        }
    }

    public void modifyExporter() {
        if (this.selectedExporters.isEmpty()) {
            return;
        }
        ExporterViewModel exporterToModify = (ExporterViewModel)this.selectedExporters.getFirst();
        CreateModifyExporterDialogView dialog = new CreateModifyExporterDialogView(exporterToModify);
        Optional<ExporterViewModel> exporter = this.dialogService.showCustomDialogAndWait(dialog);
        if (exporter != null && exporter.isPresent()) {
            this.exporters.remove((Object)exporterToModify);
            this.exporters.add((Object)exporter.get());
        }
    }

    public void removeExporters() {
        this.exporters.removeAll(this.selectedExporters);
    }

    public ListProperty<ExporterViewModel> selectedExportersProperty() {
        return this.selectedExporters;
    }

    public ListProperty<ExporterViewModel> exportersProperty() {
        return this.exporters;
    }
}

