/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.entry;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.logic.bibtex.FieldPreferences;
import org.jabref.logic.preferences.OwnerPreferences;
import org.jabref.logic.preferences.TimestampPreferences;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.preferences.BibEntryPreferences;
import org.jabref.preferences.PreferencesService;

public class EntryTabViewModel
implements PreferenceTabViewModel {
    private final StringProperty keywordSeparatorProperty = new SimpleStringProperty("");
    private final BooleanProperty resolveStringsProperty = new SimpleBooleanProperty();
    private final StringProperty resolveStringsForFieldsProperty = new SimpleStringProperty("");
    private final StringProperty nonWrappableFieldsProperty = new SimpleStringProperty("");
    private final BooleanProperty markOwnerProperty = new SimpleBooleanProperty();
    private final StringProperty markOwnerNameProperty = new SimpleStringProperty("");
    private final BooleanProperty markOwnerOverwriteProperty = new SimpleBooleanProperty();
    private final BooleanProperty addCreationDateProperty = new SimpleBooleanProperty();
    private final BooleanProperty addModificationDateProperty = new SimpleBooleanProperty();
    private final FieldPreferences fieldPreferences;
    private final BibEntryPreferences bibEntryPreferences;
    private final OwnerPreferences ownerPreferences;
    private final TimestampPreferences timestampPreferences;

    public EntryTabViewModel(PreferencesService preferencesService) {
        this.bibEntryPreferences = preferencesService.getBibEntryPreferences();
        this.fieldPreferences = preferencesService.getFieldPreferences();
        this.ownerPreferences = preferencesService.getOwnerPreferences();
        this.timestampPreferences = preferencesService.getTimestampPreferences();
    }

    @Override
    public void setValues() {
        this.keywordSeparatorProperty.setValue(this.bibEntryPreferences.getKeywordSeparator().toString());
        this.resolveStringsProperty.setValue(Boolean.valueOf(this.fieldPreferences.shouldResolveStrings()));
        this.resolveStringsForFieldsProperty.setValue(FieldFactory.serializeFieldsList(this.fieldPreferences.getResolvableFields()));
        this.nonWrappableFieldsProperty.setValue(FieldFactory.serializeFieldsList(this.fieldPreferences.getNonWrappableFields()));
        this.markOwnerProperty.setValue(Boolean.valueOf(this.ownerPreferences.isUseOwner()));
        this.markOwnerNameProperty.setValue(this.ownerPreferences.getDefaultOwner());
        this.markOwnerOverwriteProperty.setValue(Boolean.valueOf(this.ownerPreferences.isOverwriteOwner()));
        this.addCreationDateProperty.setValue(Boolean.valueOf(this.timestampPreferences.shouldAddCreationDate()));
        this.addModificationDateProperty.setValue(Boolean.valueOf(this.timestampPreferences.shouldAddModificationDate()));
    }

    @Override
    public void storeSettings() {
        this.bibEntryPreferences.keywordSeparatorProperty().setValue((Object)Character.valueOf(this.keywordSeparatorProperty.getValue().charAt(0)));
        this.fieldPreferences.setResolveStrings(this.resolveStringsProperty.getValue());
        this.fieldPreferences.setResolvableFields(FieldFactory.parseFieldList(this.resolveStringsForFieldsProperty.getValue().trim()));
        this.fieldPreferences.setNonWrappableFields(FieldFactory.parseFieldList(this.nonWrappableFieldsProperty.getValue().trim()));
        this.ownerPreferences.setUseOwner(this.markOwnerProperty.getValue());
        this.ownerPreferences.setDefaultOwner(this.markOwnerNameProperty.getValue());
        this.ownerPreferences.setOverwriteOwner(this.markOwnerOverwriteProperty.getValue());
        this.timestampPreferences.setAddCreationDate(this.addCreationDateProperty.getValue());
        this.timestampPreferences.setAddModificationDate(this.addModificationDateProperty.getValue());
    }

    public StringProperty keywordSeparatorProperty() {
        return this.keywordSeparatorProperty;
    }

    public BooleanProperty resolveStringsProperty() {
        return this.resolveStringsProperty;
    }

    public StringProperty resolveStringsForFieldsProperty() {
        return this.resolveStringsForFieldsProperty;
    }

    public StringProperty nonWrappableFieldsProperty() {
        return this.nonWrappableFieldsProperty;
    }

    public BooleanProperty markOwnerProperty() {
        return this.markOwnerProperty;
    }

    public StringProperty markOwnerNameProperty() {
        return this.markOwnerNameProperty;
    }

    public BooleanProperty markOwnerOverwriteProperty() {
        return this.markOwnerOverwriteProperty;
    }

    public BooleanProperty addCreationDateProperty() {
        return this.addCreationDateProperty;
    }

    public BooleanProperty addModificationDateProperty() {
        return this.addModificationDateProperty;
    }
}

