/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.externalfiletypes;

import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import jakarta.inject.Inject;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.preferences.externalfiletypes.EditExternalFileTypeViewModel;
import org.jabref.gui.preferences.externalfiletypes.ExternalFileTypeItemViewModel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.IconValidationDecorator;

public class EditExternalFileTypeEntryDialog
extends BaseDialog<Void> {
    @FXML
    private RadioButton defaultApplication;
    @FXML
    private ToggleGroup applicationToggleGroup;
    @FXML
    private TextField extension;
    @FXML
    private TextField name;
    @FXML
    private TextField mimeType;
    @FXML
    private RadioButton customApplication;
    @FXML
    private TextField selectedApplication;
    @FXML
    private Button btnBrowse;
    @FXML
    private Label icon;
    @Inject
    private DialogService dialogService;
    private final FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(JabRefDesktop.getApplicationDirectory()).build();
    private final ExternalFileTypeItemViewModel item;
    private final ObservableList<ExternalFileTypeItemViewModel> fileTypes;
    private EditExternalFileTypeViewModel viewModel;
    private final ControlsFxVisualizer visualizer = new ControlsFxVisualizer();

    public EditExternalFileTypeEntryDialog(ExternalFileTypeItemViewModel item, String dialogTitle, ObservableList<ExternalFileTypeItemViewModel> fileTypes) {
        this.item = item;
        this.fileTypes = fileTypes;
        this.setTitle(dialogTitle);
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Button confirmDialogButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        confirmDialogButton.disableProperty().bind((ObservableValue)this.viewModel.validationStatus().validProperty().not());
        this.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                this.viewModel.storeSettings();
            }
            return null;
        });
    }

    @FXML
    public void initialize() {
        this.visualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        this.viewModel = new EditExternalFileTypeViewModel(this.item, this.fileTypes);
        this.icon.setGraphic(this.viewModel.getIcon());
        this.defaultApplication.selectedProperty().bindBidirectional((Property)this.viewModel.defaultApplicationSelectedProperty());
        this.customApplication.selectedProperty().bindBidirectional((Property)this.viewModel.customApplicationSelectedProperty());
        this.selectedApplication.disableProperty().bind((ObservableValue)this.viewModel.defaultApplicationSelectedProperty());
        this.btnBrowse.disableProperty().bind((ObservableValue)this.viewModel.defaultApplicationSelectedProperty());
        this.extension.textProperty().bindBidirectional((Property)this.viewModel.extensionProperty());
        this.name.textProperty().bindBidirectional((Property)this.viewModel.nameProperty());
        this.mimeType.textProperty().bindBidirectional((Property)this.viewModel.mimeTypeProperty());
        this.selectedApplication.textProperty().bindBidirectional((Property)this.viewModel.selectedApplicationProperty());
        Platform.runLater(() -> {
            this.visualizer.initVisualization(this.viewModel.extensionValidation(), (Control)this.extension, true);
            this.visualizer.initVisualization(this.viewModel.nameValidation(), (Control)this.name, true);
            this.visualizer.initVisualization(this.viewModel.mimeTypeValidation(), (Control)this.mimeType, true);
        });
    }

    @FXML
    private void openFileChooser(ActionEvent event) {
        this.dialogService.showFileOpenDialog(this.fileDialogConfiguration).ifPresent(path -> this.viewModel.selectedApplicationProperty().setValue(path.toAbsolutePath().toString()));
    }
}

