/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.linkedfiles;

import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import org.jabref.gui.DialogService;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.AutoLinkPreferences;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.PreferencesService;

public class LinkedFilesTabViewModel
implements PreferenceTabViewModel {
    private final StringProperty mainFileDirectoryProperty = new SimpleStringProperty("");
    private final BooleanProperty useMainFileDirectoryProperty = new SimpleBooleanProperty();
    private final BooleanProperty useBibLocationAsPrimaryProperty = new SimpleBooleanProperty();
    private final BooleanProperty autolinkFileStartsBibtexProperty = new SimpleBooleanProperty();
    private final BooleanProperty autolinkFileExactBibtexProperty = new SimpleBooleanProperty();
    private final BooleanProperty autolinkUseRegexProperty = new SimpleBooleanProperty();
    private final StringProperty autolinkRegexKeyProperty = new SimpleStringProperty("");
    private final ListProperty<String> defaultFileNamePatternsProperty = new SimpleListProperty(FXCollections.observableArrayList((Object[])FilePreferences.DEFAULT_FILENAME_PATTERNS));
    private final BooleanProperty fulltextIndex = new SimpleBooleanProperty();
    private final StringProperty fileNamePatternProperty = new SimpleStringProperty();
    private final StringProperty fileDirectoryPatternProperty = new SimpleStringProperty();
    private final BooleanProperty confirmLinkedFileDeleteProperty = new SimpleBooleanProperty();
    private final BooleanProperty moveToTrashProperty = new SimpleBooleanProperty();
    private final Validator mainFileDirValidator;
    private final DialogService dialogService;
    private final FilePreferences filePreferences;
    private final AutoLinkPreferences autoLinkPreferences;

    public LinkedFilesTabViewModel(DialogService dialogService, PreferencesService preferences) {
        this.dialogService = dialogService;
        this.filePreferences = preferences.getFilePreferences();
        this.autoLinkPreferences = preferences.getAutoLinkPreferences();
        this.mainFileDirValidator = new FunctionBasedValidator((ObservableValue)this.mainFileDirectoryProperty, mainDirectoryPath -> {
            ValidationMessage error = ValidationMessage.error((String)Localization.lang("Main file directory '%0' not found.\nCheck the tab \"Linked files\".", mainDirectoryPath));
            try {
                Path path = Path.of(mainDirectoryPath, new String[0]);
                if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
                    return error;
                }
            }
            catch (InvalidPathException ex) {
                return error;
            }
            return null;
        });
    }

    @Override
    public void setValues() {
        this.mainFileDirectoryProperty.setValue(this.filePreferences.getMainFileDirectory().orElse(Path.of("", new String[0])).toString());
        this.useMainFileDirectoryProperty.setValue(Boolean.valueOf(!this.filePreferences.shouldStoreFilesRelativeToBibFile()));
        this.useBibLocationAsPrimaryProperty.setValue(Boolean.valueOf(this.filePreferences.shouldStoreFilesRelativeToBibFile()));
        this.fulltextIndex.setValue(Boolean.valueOf(this.filePreferences.shouldFulltextIndexLinkedFiles()));
        this.fileNamePatternProperty.setValue(this.filePreferences.getFileNamePattern());
        this.fileDirectoryPatternProperty.setValue(this.filePreferences.getFileDirectoryPattern());
        this.confirmLinkedFileDeleteProperty.setValue(Boolean.valueOf(this.filePreferences.confirmDeleteLinkedFile()));
        this.moveToTrashProperty.setValue(Boolean.valueOf(this.filePreferences.moveToTrash()));
        switch (this.autoLinkPreferences.getCitationKeyDependency()) {
            case START: {
                this.autolinkFileStartsBibtexProperty.setValue(Boolean.valueOf(true));
                break;
            }
            case EXACT: {
                this.autolinkFileExactBibtexProperty.setValue(Boolean.valueOf(true));
                break;
            }
            case REGEX: {
                this.autolinkUseRegexProperty.setValue(Boolean.valueOf(true));
            }
        }
        this.autolinkRegexKeyProperty.setValue(this.autoLinkPreferences.getRegularExpression());
    }

    @Override
    public void storeSettings() {
        this.filePreferences.setMainFileDirectory(this.mainFileDirectoryProperty.getValue());
        this.filePreferences.setStoreFilesRelativeToBibFile(this.useBibLocationAsPrimaryProperty.getValue());
        this.filePreferences.setFileNamePattern(this.fileNamePatternProperty.getValue());
        this.filePreferences.setFileDirectoryPattern(this.fileDirectoryPatternProperty.getValue());
        this.filePreferences.setFulltextIndexLinkedFiles(this.fulltextIndex.getValue());
        if (this.autolinkFileStartsBibtexProperty.getValue().booleanValue()) {
            this.autoLinkPreferences.setCitationKeyDependency(AutoLinkPreferences.CitationKeyDependency.START);
        } else if (this.autolinkFileExactBibtexProperty.getValue().booleanValue()) {
            this.autoLinkPreferences.setCitationKeyDependency(AutoLinkPreferences.CitationKeyDependency.EXACT);
        } else if (this.autolinkUseRegexProperty.getValue().booleanValue()) {
            this.autoLinkPreferences.setCitationKeyDependency(AutoLinkPreferences.CitationKeyDependency.REGEX);
        }
        this.autoLinkPreferences.setRegularExpression(this.autolinkRegexKeyProperty.getValue());
        this.filePreferences.confirmDeleteLinkedFile(this.confirmLinkedFileDeleteProperty.getValue());
        this.filePreferences.moveToTrash(this.moveToTrashProperty.getValue());
    }

    ValidationStatus mainFileDirValidationStatus() {
        return this.mainFileDirValidator.getValidationStatus();
    }

    @Override
    public boolean validateSettings() {
        ValidationStatus validationStatus = this.mainFileDirValidationStatus();
        if (!validationStatus.isValid() && this.useMainFileDirectoryProperty().get()) {
            validationStatus.getHighestMessage().ifPresent(message -> this.dialogService.showErrorDialogAndWait(message.getMessage()));
            return false;
        }
        return true;
    }

    public void mainFileDirBrowse() {
        DirectoryDialogConfiguration dirDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(Path.of(this.mainFileDirectoryProperty.getValue(), new String[0])).build();
        this.dialogService.showDirectorySelectionDialog(dirDialogConfiguration).ifPresent(f -> this.mainFileDirectoryProperty.setValue(f.toString()));
    }

    public StringProperty mainFileDirectoryProperty() {
        return this.mainFileDirectoryProperty;
    }

    public BooleanProperty useBibLocationAsPrimaryProperty() {
        return this.useBibLocationAsPrimaryProperty;
    }

    public BooleanProperty autolinkFileStartsBibtexProperty() {
        return this.autolinkFileStartsBibtexProperty;
    }

    public BooleanProperty autolinkFileExactBibtexProperty() {
        return this.autolinkFileExactBibtexProperty;
    }

    public BooleanProperty autolinkUseRegexProperty() {
        return this.autolinkUseRegexProperty;
    }

    public StringProperty autolinkRegexKeyProperty() {
        return this.autolinkRegexKeyProperty;
    }

    public BooleanProperty fulltextIndexProperty() {
        return this.fulltextIndex;
    }

    public ListProperty<String> defaultFileNamePatternsProperty() {
        return this.defaultFileNamePatternsProperty;
    }

    public StringProperty fileNamePatternProperty() {
        return this.fileNamePatternProperty;
    }

    public StringProperty fileDirectoryPatternProperty() {
        return this.fileDirectoryPatternProperty;
    }

    public BooleanProperty useMainFileDirectoryProperty() {
        return this.useMainFileDirectoryProperty;
    }

    public BooleanProperty confirmLinkedFileDeleteProperty() {
        return this.confirmLinkedFileDeleteProperty;
    }

    public BooleanProperty moveToTrashProperty() {
        return this.moveToTrashProperty;
    }
}

