/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.protectedterms;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.preferences.protectedterms.NewProtectedTermsFileDialog;
import org.jabref.gui.preferences.protectedterms.ProtectedTermsListItemModel;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.protectedterms.ProtectedTermsList;
import org.jabref.logic.protectedterms.ProtectedTermsLoader;
import org.jabref.logic.protectedterms.ProtectedTermsPreferences;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.util.OptionalUtil;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedTermsTabViewModel
implements PreferenceTabViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtectedTermsTabViewModel.class);
    private final ProtectedTermsLoader termsLoader;
    private final ListProperty<ProtectedTermsListItemModel> termsFilesProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final FilePreferences filePreferences;
    private final DialogService dialogService;
    private final ProtectedTermsPreferences protectedTermsPreferences;

    public ProtectedTermsTabViewModel(ProtectedTermsLoader termsLoader, DialogService dialogService, PreferencesService preferencesService) {
        this.termsLoader = termsLoader;
        this.dialogService = dialogService;
        this.filePreferences = preferencesService.getFilePreferences();
        this.protectedTermsPreferences = preferencesService.getProtectedTermsPreferences();
    }

    @Override
    public void setValues() {
        this.termsFilesProperty.clear();
        this.termsFilesProperty.addAll(this.termsLoader.getProtectedTermsLists().stream().map(ProtectedTermsListItemModel::new).toList());
    }

    @Override
    public void storeSettings() {
        ArrayList<String> enabledExternalList = new ArrayList<String>();
        ArrayList<String> disabledExternalList = new ArrayList<String>();
        ArrayList<String> enabledInternalList = new ArrayList<String>();
        ArrayList<String> disabledInternalList = new ArrayList<String>();
        for (ProtectedTermsList list : this.termsFilesProperty.getValue().stream().map(ProtectedTermsListItemModel::getTermsList).toList()) {
            if (list.isInternalList()) {
                if (list.isEnabled()) {
                    enabledInternalList.add(list.getLocation());
                    continue;
                }
                disabledInternalList.add(list.getLocation());
                continue;
            }
            if (list.isEnabled()) {
                enabledExternalList.add(list.getLocation());
                continue;
            }
            disabledExternalList.add(list.getLocation());
        }
        this.protectedTermsPreferences.setEnabledInternalTermLists(enabledInternalList);
        this.protectedTermsPreferences.setEnabledExternalTermLists(enabledExternalList);
        this.protectedTermsPreferences.setDisabledInternalTermLists(disabledInternalList);
        this.protectedTermsPreferences.setDisabledExternalTermLists(disabledExternalList);
        this.termsLoader.update(this.protectedTermsPreferences);
    }

    public void addFile() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(Localization.lang("Protected terms file", new Object[0]), (FileType)StandardFileType.TERMS).withDefaultExtension(Localization.lang("Protected terms file", new Object[0]), StandardFileType.TERMS).withInitialDirectory(this.filePreferences.getWorkingDirectory()).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(file -> {
            Path fileName = file.toAbsolutePath();
            this.termsFilesProperty.add((Object)new ProtectedTermsListItemModel(ProtectedTermsLoader.readProtectedTermsListFromFile(fileName, true)));
        });
    }

    public void removeList(ProtectedTermsListItemModel itemModel) {
        ProtectedTermsList list = itemModel.getTermsList();
        if (!list.isInternalList() && this.dialogService.showConfirmationDialogAndWait(Localization.lang("Remove protected terms file", new Object[0]), Localization.lang("Are you sure you want to remove the protected terms file?", new Object[0]), Localization.lang("Remove protected terms file", new Object[0]), Localization.lang("Cancel", new Object[0]))) {
            itemModel.enabledProperty().setValue(Boolean.valueOf(false));
            if (!this.termsFilesProperty.remove((Object)itemModel)) {
                LOGGER.info("Problem removing protected terms file");
            }
        }
    }

    public void createNewFile() {
        this.dialogService.showCustomDialogAndWait(new NewProtectedTermsFileDialog((List<ProtectedTermsListItemModel>)this.termsFilesProperty, this.dialogService, this.filePreferences));
    }

    public void edit(ProtectedTermsListItemModel file) {
        Optional<ExternalFileType> termsFileType = OptionalUtil.orElse(ExternalFileTypes.getExternalFileTypeByExt("terms", this.filePreferences), ExternalFileTypes.getExternalFileTypeByExt("txt", this.filePreferences));
        String fileName = file.getTermsList().getLocation();
        try {
            JabRefDesktop.openExternalFileAnyFormat(new BibDatabaseContext(), this.filePreferences, fileName, termsFileType);
        }
        catch (IOException e) {
            LOGGER.warn("Problem open protected terms file editor", (Throwable)e);
        }
    }

    public void displayContent(ProtectedTermsListItemModel itemModel) {
        ProtectedTermsList list = itemModel.getTermsList();
        TextArea listingView = new TextArea(list.getTermListing());
        listingView.setEditable(false);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setContent((Node)listingView);
        DialogPane dialogPane = new DialogPane();
        dialogPane.setContent((Node)scrollPane);
        this.dialogService.showCustomDialogAndWait(list.getDescription() + " - " + list.getLocation(), dialogPane, ButtonType.OK);
    }

    public void reloadList(ProtectedTermsListItemModel oldItemModel) {
        ProtectedTermsList oldList = oldItemModel.getTermsList();
        ProtectedTermsList newList = ProtectedTermsLoader.readProtectedTermsListFromFile(Path.of(oldList.getLocation(), new String[0]), oldList.isEnabled());
        int index = this.termsFilesProperty.indexOf((Object)oldItemModel);
        if (index >= 0) {
            this.termsFilesProperty.set(index, (Object)new ProtectedTermsListItemModel(newList));
        } else {
            LOGGER.warn("Problem reloading protected terms file {}.", (Object)oldList.getLocation());
        }
    }

    public ListProperty<ProtectedTermsListItemModel> termsFilesProperty() {
        return this.termsFilesProperty;
    }
}

