/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.table;

import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.EnumSet;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.scene.control.SelectionModel;
import javafx.util.StringConverter;
import org.jabref.gui.DialogService;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.maintable.ColumnPreferences;
import org.jabref.gui.maintable.MainTableColumnModel;
import org.jabref.gui.maintable.MainTablePreferences;
import org.jabref.gui.maintable.NameDisplayPreferences;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.specialfields.SpecialFieldsPreferences;
import org.jabref.gui.util.NoSelectionModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.PreferencesService;

public class TableTabViewModel
implements PreferenceTabViewModel {
    static StringConverter<MainTableColumnModel> columnNameStringConverter = new StringConverter<MainTableColumnModel>(){

        public String toString(MainTableColumnModel object) {
            if (object != null) {
                return object.getName();
            }
            return "";
        }

        public MainTableColumnModel fromString(String string) {
            return MainTableColumnModel.parse(string);
        }
    };
    private final ListProperty<MainTableColumnModel> columnsListProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<SelectionModel<MainTableColumnModel>> selectedColumnModelProperty = new SimpleObjectProperty(new NoSelectionModel());
    private final ListProperty<MainTableColumnModel> availableColumnsProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<MainTableColumnModel> addColumnProperty = new SimpleObjectProperty();
    private final BooleanProperty specialFieldsEnabledProperty = new SimpleBooleanProperty();
    private final BooleanProperty extraFileColumnsEnabledProperty = new SimpleBooleanProperty();
    private final BooleanProperty autoResizeColumnsProperty = new SimpleBooleanProperty();
    private final BooleanProperty namesNatbibProperty = new SimpleBooleanProperty();
    private final BooleanProperty nameAsIsProperty = new SimpleBooleanProperty();
    private final BooleanProperty nameFirstLastProperty = new SimpleBooleanProperty();
    private final BooleanProperty nameLastFirstProperty = new SimpleBooleanProperty();
    private final BooleanProperty abbreviationDisabledProperty = new SimpleBooleanProperty();
    private final BooleanProperty abbreviationEnabledProperty = new SimpleBooleanProperty();
    private final BooleanProperty abbreviationLastNameOnlyProperty = new SimpleBooleanProperty();
    private final Validator columnsNotEmptyValidator;
    private final DialogService dialogService;
    private final PreferencesService preferences;
    private ColumnPreferences initialColumnPreferences;
    private final SpecialFieldsPreferences specialFieldsPreferences;
    private final NameDisplayPreferences nameDisplayPreferences;
    private final MainTablePreferences mainTablePreferences;

    public TableTabViewModel(DialogService dialogService, PreferencesService preferences) {
        this.dialogService = dialogService;
        this.preferences = preferences;
        this.specialFieldsPreferences = preferences.getSpecialFieldsPreferences();
        this.nameDisplayPreferences = preferences.getNameDisplayPreferences();
        this.mainTablePreferences = preferences.getMainTablePreferences();
        this.specialFieldsEnabledProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.insertSpecialFieldColumns();
            } else {
                this.removeSpecialFieldColumns();
            }
        });
        this.extraFileColumnsEnabledProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.insertExtraFileColumns();
            } else {
                this.removeExtraFileColumns();
            }
        });
        this.columnsNotEmptyValidator = new FunctionBasedValidator(this.columnsListProperty, list -> !list.isEmpty(), ValidationMessage.error((String)"%s > %s %n %n %s".formatted(Localization.lang("Entry table columns", new Object[0]), Localization.lang("Columns", new Object[0]), Localization.lang("List must not be empty.", new Object[0]))));
    }

    @Override
    public void setValues() {
        this.initialColumnPreferences = this.mainTablePreferences.getColumnPreferences();
        this.specialFieldsEnabledProperty.setValue(Boolean.valueOf(this.specialFieldsPreferences.isSpecialFieldsEnabled()));
        this.extraFileColumnsEnabledProperty.setValue(Boolean.valueOf(this.mainTablePreferences.getExtraFileColumnsEnabled()));
        this.autoResizeColumnsProperty.setValue(Boolean.valueOf(this.mainTablePreferences.getResizeColumnsToFit()));
        this.fillColumnList();
        this.availableColumnsProperty.clear();
        this.availableColumnsProperty.addAll((Object[])new MainTableColumnModel[]{new MainTableColumnModel(MainTableColumnModel.Type.INDEX), new MainTableColumnModel(MainTableColumnModel.Type.LINKED_IDENTIFIER), new MainTableColumnModel(MainTableColumnModel.Type.GROUPS), new MainTableColumnModel(MainTableColumnModel.Type.GROUP_ICONS), new MainTableColumnModel(MainTableColumnModel.Type.FILES), new MainTableColumnModel(MainTableColumnModel.Type.NORMALFIELD, StandardField.TIMESTAMP.getName()), new MainTableColumnModel(MainTableColumnModel.Type.NORMALFIELD, StandardField.OWNER.getName()), new MainTableColumnModel(MainTableColumnModel.Type.NORMALFIELD, StandardField.GROUPS.getName()), new MainTableColumnModel(MainTableColumnModel.Type.NORMALFIELD, InternalField.KEY_FIELD.getName()), new MainTableColumnModel(MainTableColumnModel.Type.NORMALFIELD, InternalField.TYPE_HEADER.getName())});
        EnumSet.allOf(StandardField.class).stream().map(Field::getName).map(name -> new MainTableColumnModel(MainTableColumnModel.Type.NORMALFIELD, (String)name)).forEach(item -> this.availableColumnsProperty.getValue().add(item));
        if (this.specialFieldsEnabledProperty.getValue().booleanValue()) {
            this.insertSpecialFieldColumns();
        }
        if (this.mainTablePreferences.getExtraFileColumnsEnabled()) {
            this.insertExtraFileColumns();
        }
        switch (this.nameDisplayPreferences.getDisplayStyle()) {
            case NATBIB: {
                this.namesNatbibProperty.setValue(Boolean.valueOf(true));
                break;
            }
            case AS_IS: {
                this.nameAsIsProperty.setValue(Boolean.valueOf(true));
                break;
            }
            case FIRSTNAME_LASTNAME: {
                this.nameFirstLastProperty.setValue(Boolean.valueOf(true));
                break;
            }
            case LASTNAME_FIRSTNAME: {
                this.nameLastFirstProperty.setValue(Boolean.valueOf(true));
            }
        }
        switch (this.nameDisplayPreferences.getAbbreviationStyle()) {
            case FULL: {
                this.abbreviationEnabledProperty.setValue(Boolean.valueOf(true));
                break;
            }
            case LASTNAME_ONLY: {
                this.abbreviationLastNameOnlyProperty.setValue(Boolean.valueOf(true));
                break;
            }
            case NONE: {
                this.abbreviationDisabledProperty.setValue(Boolean.valueOf(true));
            }
        }
    }

    public void fillColumnList() {
        this.columnsListProperty.getValue().clear();
        if (this.initialColumnPreferences != null) {
            this.initialColumnPreferences.getColumns().forEach(arg_0 -> this.columnsListProperty.getValue().add(arg_0));
        }
    }

    private void insertSpecialFieldColumns() {
        EnumSet.allOf(SpecialField.class).stream().map(Field::getName).map(name -> new MainTableColumnModel(MainTableColumnModel.Type.SPECIALFIELD, (String)name)).forEach(item -> this.availableColumnsProperty.getValue().addFirst(item));
    }

    private void removeSpecialFieldColumns() {
        this.columnsListProperty.getValue().removeIf(column -> column.getType() == MainTableColumnModel.Type.SPECIALFIELD);
        this.availableColumnsProperty.getValue().removeIf(column -> column.getType() == MainTableColumnModel.Type.SPECIALFIELD);
    }

    private void insertExtraFileColumns() {
        this.preferences.getFilePreferences().getExternalFileTypes().stream().map(ExternalFileType::getName).map(name -> new MainTableColumnModel(MainTableColumnModel.Type.EXTRAFILE, (String)name)).forEach(item -> this.availableColumnsProperty.getValue().add(item));
    }

    private void removeExtraFileColumns() {
        this.columnsListProperty.getValue().removeIf(column -> column.getType() == MainTableColumnModel.Type.EXTRAFILE);
        this.availableColumnsProperty.getValue().removeIf(column -> column.getType() == MainTableColumnModel.Type.EXTRAFILE);
    }

    public void insertColumnInList() {
        if (this.addColumnProperty.getValue() == null) {
            return;
        }
        if (this.columnsListProperty.getValue().stream().filter(item -> item.equals(this.addColumnProperty.getValue())).findAny().isEmpty()) {
            this.columnsListProperty.add((Object)((MainTableColumnModel)this.addColumnProperty.getValue()));
            this.addColumnProperty.setValue(null);
        }
    }

    public void removeColumn(MainTableColumnModel column) {
        this.columnsListProperty.remove((Object)column);
    }

    public void moveColumnUp() {
        MainTableColumnModel selectedColumn = (MainTableColumnModel)((SelectionModel)this.selectedColumnModelProperty.getValue()).getSelectedItem();
        int row = this.columnsListProperty.getValue().indexOf((Object)selectedColumn);
        if (selectedColumn == null || row < 1) {
            return;
        }
        this.columnsListProperty.remove((Object)selectedColumn);
        this.columnsListProperty.add(row - 1, (Object)selectedColumn);
        ((SelectionModel)this.selectedColumnModelProperty.getValue()).clearAndSelect(row - 1);
    }

    public void moveColumnDown() {
        MainTableColumnModel selectedColumn = (MainTableColumnModel)((SelectionModel)this.selectedColumnModelProperty.getValue()).getSelectedItem();
        int row = this.columnsListProperty.getValue().indexOf((Object)selectedColumn);
        if (selectedColumn == null || row > this.columnsListProperty.getValue().size() - 2) {
            return;
        }
        this.columnsListProperty.remove((Object)selectedColumn);
        this.columnsListProperty.add(row + 1, (Object)selectedColumn);
        ((SelectionModel)this.selectedColumnModelProperty.getValue()).clearAndSelect(row + 1);
    }

    @Override
    public void storeSettings() {
        this.mainTablePreferences.getColumnPreferences().setColumns((List<MainTableColumnModel>)this.columnsListProperty.getValue());
        this.mainTablePreferences.setResizeColumnsToFit(this.autoResizeColumnsProperty.getValue());
        this.mainTablePreferences.setExtraFileColumnsEnabled(this.extraFileColumnsEnabledProperty.getValue());
        this.specialFieldsPreferences.setSpecialFieldsEnabled(this.specialFieldsEnabledProperty.getValue());
        if (this.nameLastFirstProperty.getValue().booleanValue()) {
            this.nameDisplayPreferences.setDisplayStyle(NameDisplayPreferences.DisplayStyle.LASTNAME_FIRSTNAME);
        } else if (this.namesNatbibProperty.getValue().booleanValue()) {
            this.nameDisplayPreferences.setDisplayStyle(NameDisplayPreferences.DisplayStyle.NATBIB);
        } else if (this.nameAsIsProperty.getValue().booleanValue()) {
            this.nameDisplayPreferences.setDisplayStyle(NameDisplayPreferences.DisplayStyle.AS_IS);
        } else if (this.nameFirstLastProperty.getValue().booleanValue()) {
            this.nameDisplayPreferences.setDisplayStyle(NameDisplayPreferences.DisplayStyle.FIRSTNAME_LASTNAME);
        }
        if (this.abbreviationDisabledProperty.getValue().booleanValue()) {
            this.nameDisplayPreferences.setAbbreviationStyle(NameDisplayPreferences.AbbreviationStyle.NONE);
        } else if (this.abbreviationEnabledProperty.getValue().booleanValue()) {
            this.nameDisplayPreferences.setAbbreviationStyle(NameDisplayPreferences.AbbreviationStyle.FULL);
        } else if (this.abbreviationLastNameOnlyProperty.getValue().booleanValue()) {
            this.nameDisplayPreferences.setAbbreviationStyle(NameDisplayPreferences.AbbreviationStyle.LASTNAME_ONLY);
        }
    }

    ValidationStatus columnsListValidationStatus() {
        return this.columnsNotEmptyValidator.getValidationStatus();
    }

    @Override
    public boolean validateSettings() {
        ValidationStatus validationStatus = this.columnsListValidationStatus();
        if (!validationStatus.isValid()) {
            validationStatus.getHighestMessage().ifPresent(message -> this.dialogService.showErrorDialogAndWait(message.getMessage()));
            return false;
        }
        return true;
    }

    public ListProperty<MainTableColumnModel> columnsListProperty() {
        return this.columnsListProperty;
    }

    public ObjectProperty<SelectionModel<MainTableColumnModel>> selectedColumnModelProperty() {
        return this.selectedColumnModelProperty;
    }

    public ListProperty<MainTableColumnModel> availableColumnsProperty() {
        return this.availableColumnsProperty;
    }

    public ObjectProperty<MainTableColumnModel> addColumnProperty() {
        return this.addColumnProperty;
    }

    public BooleanProperty specialFieldsEnabledProperty() {
        return this.specialFieldsEnabledProperty;
    }

    public BooleanProperty extraFileColumnsEnabledProperty() {
        return this.extraFileColumnsEnabledProperty;
    }

    public BooleanProperty autoResizeColumnsProperty() {
        return this.autoResizeColumnsProperty;
    }

    public BooleanProperty namesNatbibProperty() {
        return this.namesNatbibProperty;
    }

    public BooleanProperty nameAsIsProperty() {
        return this.nameAsIsProperty;
    }

    public BooleanProperty nameFirstLastProperty() {
        return this.nameFirstLastProperty;
    }

    public BooleanProperty nameLastFirstProperty() {
        return this.nameLastFirstProperty;
    }

    public BooleanProperty abbreviationDisabledProperty() {
        return this.abbreviationDisabledProperty;
    }

    public BooleanProperty abbreviationEnabledProperty() {
        return this.abbreviationEnabledProperty;
    }

    public BooleanProperty abbreviationLastNameOnlyProperty() {
        return this.abbreviationLastNameOnlyProperty;
    }
}

