/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.MenuItem;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.Action;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.push.PushToApplication;
import org.jabref.gui.push.PushToApplications;
import org.jabref.gui.push.PushToEmacs;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushToApplicationCommand
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushToApplicationCommand.class);
    private final StateManager stateManager;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final List<Object> reconfigurableControls = new ArrayList<Object>();
    private final TaskExecutor taskExecutor;
    private PushToApplication application;

    public PushToApplicationCommand(StateManager stateManager, DialogService dialogService, PreferencesService preferencesService, TaskExecutor taskExecutor) {
        this.stateManager = stateManager;
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.taskExecutor = taskExecutor;
        this.setApplication(preferencesService.getPushToApplicationPreferences().getActiveApplicationName());
        EasyBind.subscribe((ObservableValue)preferencesService.getPushToApplicationPreferences().activeApplicationNameProperty(), this::setApplication);
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager).and((ObservableBooleanValue)ActionHelper.needsEntriesSelected(stateManager)));
        this.statusMessage.bind(BindingsHelper.ifThenElse((ObservableValue<Boolean>)this.executable, "", Localization.lang("This operation requires one or more entries to be selected.", new Object[0])));
    }

    public void registerReconfigurable(Object node) {
        if (!(node instanceof MenuItem) && !(node instanceof ButtonBase)) {
            LOGGER.error("Node must be either a MenuItem or a ButtonBase");
            return;
        }
        this.reconfigurableControls.add(node);
    }

    private void setApplication(String applicationName) {
        ActionFactory factory = new ActionFactory();
        PushToApplication application = PushToApplications.getApplicationByName(applicationName, this.dialogService, this.preferencesService).orElse(new PushToEmacs(this.dialogService, this.preferencesService));
        this.preferencesService.getPushToApplicationPreferences().setActiveApplicationName(application.getDisplayName());
        this.application = Objects.requireNonNull(application);
        this.reconfigurableControls.forEach(object -> {
            if (object instanceof MenuItem) {
                MenuItem item = (MenuItem)object;
                factory.configureMenuItem(application.getAction(), (Command)this, item);
            } else if (object instanceof ButtonBase) {
                ButtonBase base = (ButtonBase)object;
                factory.configureIconButton(application.getAction(), (Command)this, base);
            }
        });
    }

    public Action getAction() {
        return this.application.getAction();
    }

    private static String getKeyString(List<BibEntry> entries, String delimiter) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (BibEntry bes : entries) {
            Optional<String> citeKey = bes.getCitationKey();
            if (citeKey.isEmpty() || citeKey.get().isEmpty()) continue;
            if (first) {
                result.append(citeKey.get());
                first = false;
                continue;
            }
            result.append(delimiter).append(citeKey.get());
        }
        return result.toString();
    }

    public void execute() {
        if (this.application.requiresCitationKeys()) {
            for (BibEntry entry : this.stateManager.getSelectedEntries()) {
                if (!StringUtil.isBlank(entry.getCitationKey())) continue;
                this.dialogService.showErrorDialogAndWait(this.application.getDisplayName(), Localization.lang("This operation requires all selected entries to have citation keys defined.", new Object[0]));
                return;
            }
        }
        BackgroundTask.wrap(this::pushEntries).onSuccess(s -> this.application.onOperationCompleted()).onFailure(ex -> LOGGER.error("Error pushing citation", (Throwable)ex)).executeWith(this.taskExecutor);
    }

    private void pushEntries() {
        BibDatabaseContext database = this.stateManager.getActiveDatabase().orElseThrow(() -> new NullPointerException("Database null"));
        this.application.pushEntries(database, (List<BibEntry>)this.stateManager.getSelectedEntries(), PushToApplicationCommand.getKeyString(this.stateManager.getSelectedEntries(), this.application.getDelimiter()));
    }
}

