/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jabref.gui.DialogService;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.push.AbstractPushToApplication;
import org.jabref.gui.push.PushToApplication;
import org.jabref.gui.push.PushToApplicationSettings;
import org.jabref.gui.push.PushToLyxSettings;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.HeadlessExecutorService;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;
import org.jabref.preferences.PushToApplicationPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushToLyx
extends AbstractPushToApplication {
    public static final String NAME = "LyX/Kile";
    private static final Logger LOGGER = LoggerFactory.getLogger(PushToLyx.class);

    public PushToLyx(DialogService dialogService, PreferencesService preferencesService) {
        super(dialogService, preferencesService);
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    @Override
    public JabRefIcon getApplicationIcon() {
        return IconTheme.JabRefIcons.APPLICATION_LYX;
    }

    @Override
    public void onOperationCompleted() {
        if (this.couldNotPush) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error pushing entries", new Object[0]), Localization.lang("Verify that LyX is running and that the lyxpipe is valid.", new Object[0]) + "[" + this.commandPath + "]");
        } else if (this.couldNotCall) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Unable to write to %0.", this.commandPath + ".in"));
        } else {
            super.onOperationCompleted();
        }
    }

    @Override
    public PushToApplicationSettings getSettings(PushToApplication application, PushToApplicationPreferences preferences) {
        return new PushToLyxSettings(application, this.dialogService, this.preferencesService.getFilePreferences(), preferences);
    }

    @Override
    public void pushEntries(BibDatabaseContext database, List<BibEntry> entries, String keyString) {
        File lp;
        this.couldNotPush = false;
        this.couldNotCall = false;
        this.notDefined = false;
        this.commandPath = (String)this.preferencesService.getPushToApplicationPreferences().getCommandPaths().get((Object)this.getDisplayName());
        if (this.commandPath == null || this.commandPath.trim().isEmpty()) {
            this.notDefined = true;
            return;
        }
        if (!this.commandPath.endsWith(".in")) {
            this.commandPath = this.commandPath + ".in";
        }
        if (!((lp = new File(this.commandPath)).exists() && lp.canWrite() || (lp = new File(this.commandPath + ".in")).exists() && lp.canWrite())) {
            this.couldNotPush = true;
            return;
        }
        File lyxpipe = lp;
        HeadlessExecutorService.INSTANCE.executeAndWait(() -> {
            try (FileWriter fw = new FileWriter(lyxpipe, StandardCharsets.UTF_8);
                 BufferedWriter lyxOut = new BufferedWriter(fw);){
                String citeStr = "LYXCMD:sampleclient:citation-insert:" + keyString;
                lyxOut.write(citeStr + "\n");
            }
            catch (IOException excep) {
                this.couldNotCall = true;
                LOGGER.warn("Problem pushing to LyX/Kile.", (Throwable)excep);
            }
        });
    }
}

