/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search.rules.describer;

import java.util.EnumSet;
import java.util.List;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.jabref.gui.search.rules.describer.SearchDescriber;
import org.jabref.gui.util.TooltipTextUtil;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.model.search.rules.SentenceAnalyzer;

public class ContainsAndRegexBasedSearchRuleDescriber
implements SearchDescriber {
    private final EnumSet<SearchRules.SearchFlags> searchFlags;
    private final String query;

    public ContainsAndRegexBasedSearchRuleDescriber(EnumSet<SearchRules.SearchFlags> searchFlags, String query) {
        this.searchFlags = searchFlags;
        this.query = query;
    }

    @Override
    public TextFlow getDescription() {
        List<String> words = new SentenceAnalyzer(this.query).getWords();
        String firstWord = words.isEmpty() ? "" : words.getFirst();
        String temp = this.searchFlags.contains((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION) ? Localization.lang("This search contains entries in which any field contains the regular expression <b>%0</b>", new Object[0]) : Localization.lang("This search contains entries in which any field contains the term <b>%0</b>", new Object[0]);
        List<Text> textList = TooltipTextUtil.formatToTexts(temp, new TooltipTextUtil.TextReplacement("<b>%0</b>", firstWord, TooltipTextUtil.TextType.BOLD));
        if (words.size() > 1) {
            List<String> unprocessedWords = words.subList(1, words.size());
            for (String word : unprocessedWords) {
                textList.add(TooltipTextUtil.createText(" %s ".formatted(Localization.lang("and", new Object[0])), TooltipTextUtil.TextType.NORMAL));
                textList.add(TooltipTextUtil.createText(word, TooltipTextUtil.TextType.BOLD));
            }
        }
        textList.add(this.getCaseSensitiveDescription());
        TextFlow searchDescription = new TextFlow();
        searchDescription.getChildren().setAll(textList);
        return searchDescription;
    }

    private Text getCaseSensitiveDescription() {
        if (this.searchFlags.contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE)) {
            return TooltipTextUtil.createText(" (%s). ".formatted(Localization.lang("case sensitive", new Object[0])), TooltipTextUtil.TextType.NORMAL);
        }
        return TooltipTextUtil.createText(" (%s). ".formatted(Localization.lang("case insensitive", new Object[0])), TooltipTextUtil.TextType.NORMAL);
    }
}

