/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.sidepane;

import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.groups.GroupTreeView;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.sidepane.SidePaneContentFactory;
import org.jabref.gui.sidepane.SidePaneType;
import org.jabref.logic.l10n.Localization;

public class SidePaneComponent
extends BorderPane {
    private final SidePaneType sidePaneType;
    private final SimpleCommand closeCommand;
    private final SimpleCommand moveUpCommand;
    private final SimpleCommand moveDownCommand;
    private final SidePaneContentFactory contentFactory;
    private HBox buttonContainer;

    public SidePaneComponent(SidePaneType sidePaneType, SimpleCommand closeCommand, SimpleCommand moveUpCommand, SimpleCommand moveDownCommand, SidePaneContentFactory contentFactory) {
        this.sidePaneType = sidePaneType;
        this.closeCommand = closeCommand;
        this.moveUpCommand = moveUpCommand;
        this.moveDownCommand = moveDownCommand;
        this.contentFactory = contentFactory;
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"sidePaneComponent");
        this.setTop(this.createHeaderView());
        this.setCenter(this.contentFactory.create(this.sidePaneType));
        VBox.setVgrow((Node)this, (Priority)(this.sidePaneType == SidePaneType.GROUPS ? Priority.ALWAYS : Priority.NEVER));
    }

    private Node createHeaderView() {
        Button closeButton = IconTheme.JabRefIcons.CLOSE.asButton();
        closeButton.setTooltip(new Tooltip(Localization.lang("Hide panel", new Object[0])));
        closeButton.setOnAction(e -> this.closeCommand.execute());
        Button upButton = IconTheme.JabRefIcons.UP.asButton();
        upButton.setTooltip(new Tooltip(Localization.lang("Move panel up", new Object[0])));
        upButton.setOnAction(e -> this.moveUpCommand.execute());
        Button downButton = IconTheme.JabRefIcons.DOWN.asButton();
        downButton.setTooltip(new Tooltip(Localization.lang("Move panel down", new Object[0])));
        downButton.setOnAction(e -> this.moveDownCommand.execute());
        this.buttonContainer = new HBox();
        this.buttonContainer.getChildren().addAll((Object[])new Node[]{upButton, downButton, closeButton});
        Label label = new Label(this.sidePaneType.getTitle());
        BorderPane headerView = new BorderPane();
        headerView.setLeft((Node)label);
        headerView.setRight((Node)this.buttonContainer);
        headerView.getStyleClass().add((Object)"sidePaneComponentHeader");
        return headerView;
    }

    protected void addExtraButtonToHeader(Button button, int position) {
        this.buttonContainer.getChildren().add(position, (Object)button);
    }

    public void requestFocus() {
        for (Node child : this.getChildren()) {
            if (!(child instanceof GroupTreeView)) continue;
            GroupTreeView groupTreeView = (GroupTreeView)child;
            groupTreeView.requestFocusGroupTree();
            break;
        }
    }
}

