/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.slr;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.importer.actions.OpenDatabaseAction;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.crawler.Crawler;
import org.jabref.logic.git.SlrGitHandler;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExistingStudySearchAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExistingStudySearchAction.class);
    protected final DialogService dialogService;
    protected Path studyDirectory;
    protected final PreferencesService preferencesService;
    protected final StateManager stateManager;
    private final FileUpdateMonitor fileUpdateMonitor;
    private final TaskExecutor taskExecutor;
    private final LibraryTabContainer tabContainer;
    private final Supplier<OpenDatabaseAction> openDatabaseActionSupplier;

    public ExistingStudySearchAction(LibraryTabContainer tabContainer, Supplier<OpenDatabaseAction> openDatabaseActionSupplier, DialogService dialogService, FileUpdateMonitor fileUpdateMonitor, TaskExecutor taskExecutor, PreferencesService preferencesService, StateManager stateManager) {
        this(tabContainer, openDatabaseActionSupplier, dialogService, fileUpdateMonitor, taskExecutor, preferencesService, stateManager, false);
    }

    protected ExistingStudySearchAction(LibraryTabContainer tabContainer, Supplier<OpenDatabaseAction> openDatabaseActionSupplier, DialogService dialogService, FileUpdateMonitor fileUpdateMonitor, TaskExecutor taskExecutor, PreferencesService preferencesService, StateManager stateManager, boolean isNew) {
        this.tabContainer = tabContainer;
        this.openDatabaseActionSupplier = openDatabaseActionSupplier;
        this.dialogService = dialogService;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.taskExecutor = taskExecutor;
        this.preferencesService = preferencesService;
        this.stateManager = stateManager;
        if (!isNew) {
            this.executable.bind((ObservableValue)ActionHelper.needsStudyDatabase(stateManager));
        }
    }

    public void execute() {
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            LOGGER.error("Database is not present, even if it should");
            return;
        }
        BibDatabaseContext bibDatabaseContext = this.stateManager.getActiveDatabase().get();
        if (bibDatabaseContext.getDatabasePath().isEmpty()) {
            LOGGER.error("Database path is not present, even if it should");
            return;
        }
        this.studyDirectory = bibDatabaseContext.getDatabasePath().get().getParent();
        this.crawl();
    }

    protected void crawl() {
        Crawler crawler;
        try {
            this.crawlPreparation(this.studyDirectory);
        }
        catch (IOException | GitAPIException e2) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Study repository could not be created", new Object[0]), e2);
            return;
        }
        try {
            crawler = new Crawler(this.studyDirectory, new SlrGitHandler(this.studyDirectory), this.preferencesService, new BibEntryTypesManager(), this.fileUpdateMonitor);
        }
        catch (IOException | ParseException e3) {
            LOGGER.error("Error during reading of study definition file.", (Throwable)e3);
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error during reading of study definition file.", new Object[0]), e3);
            return;
        }
        this.dialogService.notify(Localization.lang("Searching...", new Object[0]));
        BackgroundTask.wrap(() -> {
            crawler.performCrawl();
            return 0;
        }).onFailure(e -> {
            LOGGER.error("Error during persistence of crawling results.");
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error during persistence of crawling results.", new Object[0]), (Throwable)e);
        }).onSuccess(unused -> {
            this.dialogService.notify(Localization.lang("Finished Searching", new Object[0]));
            this.openDatabaseActionSupplier.get().openFile(Path.of(this.studyDirectory.toString(), "studyResult.bib"));
        }).executeWith(this.taskExecutor);
    }

    protected void crawlPreparation(Path studyRepositoryRoot) throws IOException, GitAPIException {
        this.tabContainer.closeTab(this.tabContainer.getCurrentLibraryTab());
    }
}

