/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.theme;

import java.net.URL;
import org.jabref.gui.theme.StyleSheet;
import org.jabref.gui.theme.StyleSheetFile;

public class StyleSheetDataUrl
extends StyleSheet {
    private final URL url;
    private volatile String dataUrl;

    StyleSheetDataUrl(URL url) {
        this.url = url;
        this.reload();
    }

    @Override
    URL getSceneStylesheet() {
        return this.url;
    }

    @Override
    public String getWebEngineStylesheet() {
        return this.dataUrl;
    }

    @Override
    void reload() {
        StyleSheetFile.getDataUrl(this.url).ifPresentOrElse(createdUrl -> {
            this.dataUrl = createdUrl;
        }, () -> {
            this.dataUrl = "data:text/css;charset=utf-8;base64,";
        });
    }

    @Override
    public String toString() {
        return "StyleSheet{" + String.valueOf(this.getSceneStylesheet()) + "}";
    }
}

