/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.undo;

import org.jabref.gui.undo.AbstractUndoableJabRefEdit;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibtexString;
import org.jabref.model.strings.StringUtil;

public class UndoableStringChange
extends AbstractUndoableJabRefEdit {
    private final BibtexString string;
    private final String oldValue;
    private final String newValue;
    private final boolean nameChange;

    public UndoableStringChange(BibtexString string, boolean nameChange, String oldValue, String newValue) {
        this.string = string;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.nameChange = nameChange;
    }

    @Override
    public String getPresentationName() {
        return this.nameChange ? Localization.lang("change string name %0 to %1", StringUtil.boldHTML(this.oldValue), StringUtil.boldHTML(this.newValue)) : Localization.lang("change string content %0 to %1", StringUtil.boldHTML(this.oldValue), StringUtil.boldHTML(this.newValue));
    }

    @Override
    public void undo() {
        super.undo();
        if (this.nameChange) {
            this.string.setName(this.oldValue);
        } else {
            this.string.setContent(this.oldValue);
        }
    }

    @Override
    public void redo() {
        super.redo();
        if (this.nameChange) {
            this.string.setName(this.newValue);
        } else {
            this.string.setContent(this.newValue);
        }
    }
}

