/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.jabref.model.util.DirectoryMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDirectoryMonitor
implements DirectoryMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDirectoryMonitor.class);
    private static final int POLL_INTERVAL = 1000;
    private final FileAlterationMonitor monitor = new FileAlterationMonitor(1000L);

    public DefaultDirectoryMonitor() {
        this.start();
    }

    @Override
    public void addObserver(FileAlterationObserver observer, FileAlterationListener listener) {
        if (observer != null) {
            observer.addListener(listener);
            this.monitor.addObserver(observer);
        }
    }

    @Override
    public void removeObserver(FileAlterationObserver observer) {
        if (observer != null) {
            this.monitor.removeObserver(observer);
        }
    }

    @Override
    public void start() {
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            LOGGER.error("Error starting directory monitor", (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.monitor.stop();
        }
        catch (Exception e) {
            LOGGER.error("Error stopping directory monitor", (Throwable)e);
        }
    }
}

