/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jabref.logic.JabRefException;
import org.jabref.logic.WatchServiceUnavailableException;
import org.jabref.model.util.FileUpdateListener;
import org.jabref.model.util.FileUpdateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileUpdateMonitor
implements Runnable,
FileUpdateMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileUpdateMonitor.class);
    private final Multimap<Path, FileUpdateListener> listeners = ArrayListMultimap.create((int)20, (int)4);
    private volatile WatchService watcher;
    private final AtomicBoolean notShutdown = new AtomicBoolean(true);
    private final AtomicReference<Optional<JabRefException>> filesystemMonitorFailure = new AtomicReference(Optional.empty());

    @Override
    public void run() {
        try (WatchService watcher = FileSystems.getDefault().newWatchService();){
            this.watcher = watcher;
            this.filesystemMonitorFailure.set(Optional.empty());
            while (this.notShutdown.get()) {
                WatchKey key;
                try {
                    key = watcher.take();
                }
                catch (InterruptedException | ClosedWatchServiceException e) {
                    if (watcher != null) {
                        watcher.close();
                    }
                    return;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        Thread.yield();
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        WatchEvent<?> ev = event;
                        Path path = ((Path)key.watchable()).resolve((Path)ev.context());
                        this.notifyAboutChange(path);
                    }
                    key.reset();
                }
                Thread.yield();
            }
        }
        catch (IOException e) {
            WatchServiceUnavailableException exception = new WatchServiceUnavailableException(e.getMessage(), e.getLocalizedMessage(), e.getCause());
            this.filesystemMonitorFailure.set(Optional.of(exception));
            LOGGER.warn("Error during watching", (Throwable)e);
        }
    }

    @Override
    public boolean isActive() {
        return this.filesystemMonitorFailure.get().isEmpty();
    }

    private void notifyAboutChange(Path path) {
        this.listeners.get((Object)path).forEach(FileUpdateListener::fileUpdated);
    }

    @Override
    public void addListenerForFile(Path file, FileUpdateListener listener) throws IOException {
        if (this.isActive()) {
            Path directory = file.toAbsolutePath().getParent();
            directory.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.listeners.put((Object)file, (Object)listener);
        } else {
            LOGGER.warn("Not adding listener {} to file {} because the file update monitor isn't active", (Object)listener, (Object)file);
        }
    }

    @Override
    public void removeListener(Path path, FileUpdateListener listener) {
        this.listeners.remove((Object)path, (Object)listener);
    }

    @Override
    public void shutdown() {
        try {
            this.notShutdown.set(false);
            WatchService watcher = this.watcher;
            if (watcher != null) {
                watcher.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("error closing watcher", (Throwable)e);
        }
    }
}

