/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import com.tobiasdiez.easybind.EasyBind;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.util.Callback;

public class RecursiveTreeItem<T>
extends CheckBoxTreeItem<T> {
    private final Callback<T, BooleanProperty> expandedProperty;
    private final Callback<T, ObservableList<T>> childrenFactory;
    private final ObjectProperty<Predicate<T>> filter = new SimpleObjectProperty();
    private FilteredList<RecursiveTreeItem<T>> children;

    public RecursiveTreeItem(T value, Callback<T, ObservableList<T>> func) {
        this(value, func, null, null);
    }

    public RecursiveTreeItem(T value, Callback<T, ObservableList<T>> func, Callback<T, BooleanProperty> expandedProperty, ObservableValue<Predicate<T>> filter) {
        this(value, null, func, expandedProperty, filter);
    }

    public RecursiveTreeItem(T value, Callback<T, ObservableList<T>> func, ObservableValue<Predicate<T>> filter) {
        this(value, null, func, null, filter);
    }

    private RecursiveTreeItem(T value, Node graphic, Callback<T, ObservableList<T>> func, Callback<T, BooleanProperty> expandedProperty, ObservableValue<Predicate<T>> filter) {
        super(value, graphic);
        this.childrenFactory = func;
        this.expandedProperty = expandedProperty;
        if (filter != null) {
            this.filter.bind(filter);
        }
        if (value != null) {
            this.addChildrenListener(value);
            this.bindExpandedProperty(value, expandedProperty);
        }
        this.valueProperty().addListener((obs, oldValue, newValue) -> {
            if (newValue != null) {
                this.addChildrenListener(newValue);
                this.bindExpandedProperty(newValue, expandedProperty);
            }
        });
    }

    private void bindExpandedProperty(T value, Callback<T, BooleanProperty> expandedProperty) {
        if (expandedProperty != null) {
            this.expandedProperty().bindBidirectional((Property)expandedProperty.call(value));
        }
    }

    private void addChildrenListener(T value) {
        this.children = EasyBind.mapBacked((ObservableList)((ObservableList)this.childrenFactory.call(value)), child -> new RecursiveTreeItem<Object>(child, this.getGraphic(), (Callback<Object, ObservableList<Object>>)this.childrenFactory, (Callback<Object, BooleanProperty>)this.expandedProperty, (ObservableValue<Predicate<Object>>)this.filter)).filtered((ObservableValue)Bindings.createObjectBinding(() -> this::showNode, (Observable[])new Observable[]{this.filter}));
        Bindings.bindContent((List)this.getChildren(), this.children);
    }

    private boolean showNode(RecursiveTreeItem<T> node) {
        if (this.filter.get() == null) {
            return true;
        }
        if (((Predicate)this.filter.get()).test(node.getValue())) {
            return true;
        }
        return node.children.getSource().stream().anyMatch(this::showNode);
    }
}

