/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamGobbler
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamGobbler.class);
    private InputStream inputStream;
    private Consumer<String> consumer;

    public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
        this.inputStream = inputStream;
        this.consumer = consumer;
    }

    @Override
    public void run() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));){
            reader.lines().forEach(this.consumer);
        }
        catch (IOException e) {
            LOGGER.error("Error when reading process stream from external application", (Throwable)e);
        }
    }
}

