/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.function.BiFunction;
import java.util.function.Function;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.Screen;
import javafx.util.Callback;
import org.jabref.model.strings.StringUtil;

public class ValueTableCellFactory<S, T>
implements Callback<TableColumn<S, T>, TableCell<S, T>> {
    private Function<T, String> toText;
    private BiFunction<S, T, Node> toGraphic;
    private BiFunction<S, T, EventHandler<? super MouseEvent>> toOnMouseClickedEvent;
    private BiFunction<S, T, EventHandler<? super MouseEvent>> toOnMouseEnterEvent;
    private Function<T, BooleanExpression> toDisableExpression;
    private Function<T, BooleanExpression> toVisibleExpression;
    private BiFunction<S, T, String> toTooltip;
    private BiFunction<S, T, Tooltip> tooltip;
    private Function<T, ContextMenu> contextMenuFactory;
    private BiFunction<S, T, ContextMenu> menuFactory;

    public ValueTableCellFactory<S, T> withText(Function<T, String> toText) {
        this.toText = toText;
        return this;
    }

    public ValueTableCellFactory<S, T> withGraphic(Function<T, Node> toGraphic) {
        this.toGraphic = (rowItem, value) -> (Node)toGraphic.apply(value);
        return this;
    }

    public ValueTableCellFactory<S, T> withGraphic(BiFunction<S, T, Node> toGraphic) {
        this.toGraphic = toGraphic;
        return this;
    }

    public ValueTableCellFactory<S, T> withTooltip(BiFunction<S, T, String> toTooltip) {
        this.toTooltip = toTooltip;
        return this;
    }

    public ValueTableCellFactory<S, T> graphicTooltip(BiFunction<S, T, Tooltip> tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ValueTableCellFactory<S, T> withTooltip(Function<T, String> toTooltip) {
        this.toTooltip = (rowItem, value) -> (String)toTooltip.apply(value);
        return this;
    }

    public ValueTableCellFactory<S, T> withOnMouseClickedEvent(BiFunction<S, T, EventHandler<? super MouseEvent>> toOnMouseClickedEvent) {
        this.toOnMouseClickedEvent = toOnMouseClickedEvent;
        return this;
    }

    public ValueTableCellFactory<S, T> withOnMouseClickedEvent(Function<T, EventHandler<? super MouseEvent>> toOnMouseClickedEvent) {
        this.toOnMouseClickedEvent = (rowItem, value) -> (EventHandler)toOnMouseClickedEvent.apply(value);
        return this;
    }

    public ValueTableCellFactory<S, T> withDisableExpression(Function<T, BooleanExpression> toDisableBinding) {
        this.toDisableExpression = toDisableBinding;
        return this;
    }

    public ValueTableCellFactory<S, T> withVisibleExpression(Function<T, BooleanExpression> toVisibleBinding) {
        this.toVisibleExpression = toVisibleBinding;
        return this;
    }

    public ValueTableCellFactory<S, T> withContextMenu(Function<T, ContextMenu> contextMenuFactory) {
        this.contextMenuFactory = contextMenuFactory;
        return this;
    }

    public ValueTableCellFactory<S, T> withMenu(BiFunction<S, T, ContextMenu> menuFactory) {
        this.menuFactory = menuFactory;
        return this;
    }

    public TableCell<S, T> call(TableColumn<S, T> param) {
        return new TableCell<S, T>(){

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null || this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    this.setText(null);
                    this.setGraphic(null);
                    this.setOnMouseClicked(null);
                    this.setTooltip(null);
                } else {
                    String tooltipText;
                    Object rowItem = this.getTableRow().getItem();
                    if (ValueTableCellFactory.this.toText != null) {
                        this.setText(ValueTableCellFactory.this.toText.apply(item));
                    }
                    if (ValueTableCellFactory.this.toGraphic != null) {
                        this.setGraphic(ValueTableCellFactory.this.toGraphic.apply(rowItem, item));
                    }
                    if (ValueTableCellFactory.this.toTooltip != null && StringUtil.isNotBlank(tooltipText = ValueTableCellFactory.this.toTooltip.apply(rowItem, item))) {
                        Screen currentScreen = Screen.getPrimary();
                        double maxWidth = currentScreen.getBounds().getWidth();
                        Tooltip tooltip = new Tooltip(tooltipText);
                        tooltip.setMaxWidth(maxWidth * 2.0 / 3.0);
                        tooltip.setWrapText(true);
                        this.setTooltip(tooltip);
                    }
                    if (ValueTableCellFactory.this.contextMenuFactory != null) {
                        this.setOnContextMenuRequested(event -> {
                            if (!this.isEmpty()) {
                                this.setContextMenu(ValueTableCellFactory.this.contextMenuFactory.apply(item));
                                this.getContextMenu().show((Node)this, event.getScreenX(), event.getScreenY());
                            }
                            event.consume();
                        });
                    }
                    this.setOnMouseEntered(event -> {
                        if (ValueTableCellFactory.this.tooltip != null) {
                            this.setTooltip(ValueTableCellFactory.this.tooltip.apply(rowItem, item));
                        }
                    });
                    this.setOnMouseClicked(event -> {
                        ContextMenu menu;
                        if (ValueTableCellFactory.this.toOnMouseClickedEvent != null) {
                            ValueTableCellFactory.this.toOnMouseClickedEvent.apply(rowItem, item).handle(event);
                        }
                        if (ValueTableCellFactory.this.menuFactory != null && !event.isConsumed() && event.getButton() == MouseButton.PRIMARY && (menu = ValueTableCellFactory.this.menuFactory.apply(rowItem, item)) != null) {
                            menu.show((Node)this, event.getScreenX(), event.getScreenY());
                            event.consume();
                        }
                    });
                    if (ValueTableCellFactory.this.toDisableExpression != null) {
                        this.disableProperty().bind((ObservableValue)ValueTableCellFactory.this.toDisableExpression.apply(item));
                    }
                    if (ValueTableCellFactory.this.toVisibleExpression != null) {
                        this.visibleProperty().bind((ObservableValue)ValueTableCellFactory.this.toVisibleExpression.apply(item));
                    }
                }
            }
        };
    }

    public void install(TableColumn<S, T> column) {
        column.setCellFactory((Callback)this);
    }
}

