/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import com.tobiasdiez.easybind.Subscription;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.model.strings.StringUtil;

public class ViewModelListCellFactory<T>
implements Callback<ListView<T>, ListCell<T>> {
    private static final PseudoClass INVALID_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"invalid");
    private Callback<T, String> toText;
    private Callback<T, Node> toGraphic;
    private Callback<T, Tooltip> toTooltip;
    private BiConsumer<T, ? super MouseEvent> toOnMouseClickedEvent;
    private Callback<T, String> toStyleClass;
    private Callback<T, ContextMenu> toContextMenu;
    private BiConsumer<T, ? super MouseEvent> toOnDragDetected;
    private BiConsumer<T, ? super DragEvent> toOnDragDropped;
    private BiConsumer<T, ? super DragEvent> toOnDragEntered;
    private BiConsumer<T, ? super DragEvent> toOnDragExited;
    private BiConsumer<T, ? super DragEvent> toOnDragOver;
    private final Map<PseudoClass, Callback<T, ObservableValue<Boolean>>> pseudoClasses = new HashMap<PseudoClass, Callback<T, ObservableValue<Boolean>>>();
    private Callback<T, ValidationStatus> validationStatusProperty;

    public ViewModelListCellFactory<T> withText(Callback<T, String> toText) {
        this.toText = toText;
        return this;
    }

    public ViewModelListCellFactory<T> withGraphic(Callback<T, Node> toGraphic) {
        this.toGraphic = toGraphic;
        return this;
    }

    public ViewModelListCellFactory<T> withIcon(Callback<T, JabRefIcon> toIcon) {
        this.toGraphic = viewModel -> {
            JabRefIcon icon = (JabRefIcon)toIcon.call(viewModel);
            if (icon != null) {
                return icon.getGraphicNode();
            }
            return null;
        };
        return this;
    }

    public ViewModelListCellFactory<T> withIcon(Callback<T, JabRefIcon> toIcon, Callback<T, Color> toColor) {
        this.toGraphic = viewModel -> ((JabRefIcon)toIcon.call(viewModel)).withColor((Color)toColor.call(viewModel)).getGraphicNode();
        return this;
    }

    public ViewModelListCellFactory<T> withStringTooltip(Callback<T, String> toStringTooltip) {
        this.toTooltip = viewModel -> {
            String tooltipText = (String)toStringTooltip.call(viewModel);
            if (StringUtil.isNotBlank(tooltipText)) {
                return new Tooltip(tooltipText);
            }
            return null;
        };
        return this;
    }

    public ViewModelListCellFactory<T> withTooltip(Callback<T, Tooltip> toTooltip) {
        this.toTooltip = toTooltip;
        return this;
    }

    public ViewModelListCellFactory<T> withContextMenu(Callback<T, ContextMenu> toContextMenu) {
        this.toContextMenu = toContextMenu;
        return this;
    }

    public ViewModelListCellFactory<T> withStyleClass(Callback<T, String> toStyleClass) {
        this.toStyleClass = toStyleClass;
        return this;
    }

    public ViewModelListCellFactory<T> withOnMouseClickedEvent(BiConsumer<T, ? super MouseEvent> toOnMouseClickedEvent) {
        this.toOnMouseClickedEvent = toOnMouseClickedEvent;
        return this;
    }

    public ViewModelListCellFactory<T> setOnDragDetected(BiConsumer<T, ? super MouseEvent> toOnDragDetected) {
        this.toOnDragDetected = toOnDragDetected;
        return this;
    }

    public ViewModelListCellFactory<T> setOnDragDropped(BiConsumer<T, ? super DragEvent> toOnDragDropped) {
        this.toOnDragDropped = toOnDragDropped;
        return this;
    }

    public ViewModelListCellFactory<T> setOnDragEntered(BiConsumer<T, ? super DragEvent> toOnDragEntered) {
        this.toOnDragEntered = toOnDragEntered;
        return this;
    }

    public ViewModelListCellFactory<T> setOnDragExited(BiConsumer<T, ? super DragEvent> toOnDragExited) {
        this.toOnDragExited = toOnDragExited;
        return this;
    }

    public ViewModelListCellFactory<T> setOnDragOver(BiConsumer<T, ? super DragEvent> toOnDragOver) {
        this.toOnDragOver = toOnDragOver;
        return this;
    }

    public ViewModelListCellFactory<T> withPseudoClass(PseudoClass pseudoClass, Callback<T, ObservableValue<Boolean>> toCondition) {
        this.pseudoClasses.putIfAbsent(pseudoClass, toCondition);
        return this;
    }

    public ViewModelListCellFactory<T> withValidation(Callback<T, ValidationStatus> validationStatusProperty) {
        this.validationStatusProperty = validationStatusProperty;
        return this;
    }

    public void install(ComboBox<T> comboBox) {
        comboBox.setButtonCell(this.call(null));
        comboBox.setCellFactory((Callback)this);
    }

    public void install(ListView<T> listView) {
        listView.setCellFactory((Callback)this);
    }

    public ListCell<T> call(ListView<T> param) {
        return new ListCell<T>(){
            final List<Subscription> subscriptions = new ArrayList<Subscription>();

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                this.subscriptions.forEach(Subscription::unsubscribe);
                this.subscriptions.clear();
                Object viewModel = this.getItem();
                if (empty || viewModel == null) {
                    this.setText(null);
                    this.setGraphic(null);
                    this.setOnMouseClicked(null);
                    this.setTooltip(null);
                    this.pseudoClassStateChanged(INVALID_PSEUDO_CLASS, false);
                } else {
                    if (ViewModelListCellFactory.this.toText != null) {
                        this.setText((String)ViewModelListCellFactory.this.toText.call(viewModel));
                    }
                    if (ViewModelListCellFactory.this.toGraphic != null) {
                        this.setGraphic((Node)ViewModelListCellFactory.this.toGraphic.call(viewModel));
                    }
                    if (ViewModelListCellFactory.this.toOnMouseClickedEvent != null) {
                        this.setOnMouseClicked(event -> ViewModelListCellFactory.this.toOnMouseClickedEvent.accept(viewModel, (MouseEvent)event));
                    }
                    if (ViewModelListCellFactory.this.toStyleClass != null) {
                        this.getStyleClass().setAll((Object[])new String[]{(String)ViewModelListCellFactory.this.toStyleClass.call(viewModel)});
                    }
                    if (ViewModelListCellFactory.this.toTooltip != null) {
                        this.setTooltip((Tooltip)ViewModelListCellFactory.this.toTooltip.call(viewModel));
                    }
                    if (ViewModelListCellFactory.this.toContextMenu != null) {
                        this.setContextMenu((ContextMenu)ViewModelListCellFactory.this.toContextMenu.call(viewModel));
                    }
                    if (ViewModelListCellFactory.this.toOnDragDetected != null) {
                        this.setOnDragDetected(event -> ViewModelListCellFactory.this.toOnDragDetected.accept(viewModel, (MouseEvent)event));
                    }
                    if (ViewModelListCellFactory.this.toOnDragDropped != null) {
                        this.setOnDragDropped(event -> ViewModelListCellFactory.this.toOnDragDropped.accept(viewModel, (DragEvent)event));
                    }
                    if (ViewModelListCellFactory.this.toOnDragEntered != null) {
                        this.setOnDragEntered(event -> ViewModelListCellFactory.this.toOnDragEntered.accept(viewModel, (DragEvent)event));
                    }
                    if (ViewModelListCellFactory.this.toOnDragExited != null) {
                        this.setOnDragExited(event -> ViewModelListCellFactory.this.toOnDragExited.accept(viewModel, (DragEvent)event));
                    }
                    if (ViewModelListCellFactory.this.toOnDragOver != null) {
                        this.setOnDragOver(event -> ViewModelListCellFactory.this.toOnDragOver.accept(viewModel, (DragEvent)event));
                    }
                    for (Map.Entry pseudoClassWithCondition : ViewModelListCellFactory.this.pseudoClasses.entrySet()) {
                        ObservableValue condition = (ObservableValue)pseudoClassWithCondition.getValue().call(viewModel);
                        this.subscriptions.add(BindingsHelper.includePseudoClassWhen((Node)this, pseudoClassWithCondition.getKey(), (ObservableValue<? extends Boolean>)condition));
                    }
                    if (ViewModelListCellFactory.this.validationStatusProperty != null) {
                        ((ValidationStatus)ViewModelListCellFactory.this.validationStatusProperty.call(viewModel)).getHighestMessage().ifPresent(message -> this.setTooltip(new Tooltip(message.getMessage())));
                        this.subscriptions.add(BindingsHelper.includePseudoClassWhen((Node)this, INVALID_PSEUDO_CLASS, (ObservableValue<? extends Boolean>)((ValidationStatus)ViewModelListCellFactory.this.validationStatusProperty.call(viewModel)).validProperty().not()));
                    }
                }
            }
        };
    }
}

