/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.jabref.model.strings.StringUtil;
import org.reactfx.util.TriConsumer;

public class ViewModelTableRowFactory<S>
implements Callback<TableView<S>, TableRow<S>> {
    private BiConsumer<S, ? super MouseEvent> onMouseClickedEvent;
    private Function<S, ContextMenu> contextMenuFactory;
    private TriConsumer<TableRow<S>, S, ? super MouseEvent> toOnDragDetected;
    private TriConsumer<TableRow<S>, S, ? super DragEvent> toOnDragDropped;
    private BiConsumer<S, ? super DragEvent> toOnDragEntered;
    private TriConsumer<TableRow<S>, S, ? super DragEvent> toOnDragExited;
    private TriConsumer<TableRow<S>, S, ? super DragEvent> toOnDragOver;
    private TriConsumer<TableRow<S>, S, ? super MouseDragEvent> toOnMouseDragEntered;
    private Callback<S, String> toTooltip;

    public ViewModelTableRowFactory<S> withOnMouseClickedEvent(BiConsumer<S, ? super MouseEvent> onMouseClickedEvent) {
        this.onMouseClickedEvent = onMouseClickedEvent;
        return this;
    }

    public ViewModelTableRowFactory<S> withContextMenu(Function<S, ContextMenu> contextMenuFactory) {
        this.contextMenuFactory = contextMenuFactory;
        return this;
    }

    public ViewModelTableRowFactory<S> setOnDragDetected(TriConsumer<TableRow<S>, S, ? super MouseEvent> toOnDragDetected) {
        this.toOnDragDetected = toOnDragDetected;
        return this;
    }

    public ViewModelTableRowFactory<S> setOnDragDetected(BiConsumer<S, ? super MouseEvent> toOnDragDetected) {
        this.toOnDragDetected = (row, viewModel, event) -> toOnDragDetected.accept((Object)viewModel, (MouseEvent)event);
        return this;
    }

    public ViewModelTableRowFactory<S> setOnDragDropped(TriConsumer<TableRow<S>, S, ? super DragEvent> toOnDragDropped) {
        this.toOnDragDropped = toOnDragDropped;
        return this;
    }

    public ViewModelTableRowFactory<S> setOnDragDropped(BiConsumer<S, ? super DragEvent> toOnDragDropped) {
        return this.setOnDragDropped((row, viewModel, event) -> toOnDragDropped.accept((Object)viewModel, (DragEvent)event));
    }

    public ViewModelTableRowFactory<S> setOnDragEntered(BiConsumer<S, ? super DragEvent> toOnDragEntered) {
        this.toOnDragEntered = toOnDragEntered;
        return this;
    }

    public ViewModelTableRowFactory<S> setOnMouseDragEntered(TriConsumer<TableRow<S>, S, ? super MouseDragEvent> toOnDragEntered) {
        this.toOnMouseDragEntered = toOnDragEntered;
        return this;
    }

    public ViewModelTableRowFactory<S> setOnMouseDragEntered(BiConsumer<S, ? super MouseDragEvent> toOnDragEntered) {
        return this.setOnMouseDragEntered((row, viewModel, event) -> toOnDragEntered.accept((Object)viewModel, (MouseDragEvent)event));
    }

    public ViewModelTableRowFactory<S> setOnDragExited(TriConsumer<TableRow<S>, S, ? super DragEvent> toOnDragExited) {
        this.toOnDragExited = toOnDragExited;
        return this;
    }

    public ViewModelTableRowFactory<S> setOnDragExited(BiConsumer<S, ? super DragEvent> toOnDragExited) {
        return this.setOnDragExited((row, viewModel, event) -> toOnDragExited.accept((Object)viewModel, (DragEvent)event));
    }

    public ViewModelTableRowFactory<S> setOnDragOver(TriConsumer<TableRow<S>, S, ? super DragEvent> toOnDragOver) {
        this.toOnDragOver = toOnDragOver;
        return this;
    }

    public ViewModelTableRowFactory<S> setOnDragOver(BiConsumer<S, ? super DragEvent> toOnDragOver) {
        return this.setOnDragOver((row, viewModel, event) -> toOnDragOver.accept((Object)viewModel, (DragEvent)event));
    }

    public ViewModelTableRowFactory<S> withTooltip(Callback<S, String> toTooltip) {
        this.toTooltip = toTooltip;
        return this;
    }

    public TableRow<S> call(TableView<S> tableView) {
        String tooltipText;
        TableRow row = new TableRow();
        if (this.toTooltip != null && StringUtil.isNotBlank(tooltipText = (String)this.toTooltip.call(row.getItem()))) {
            row.setTooltip(new Tooltip(tooltipText));
        }
        if (this.onMouseClickedEvent != null) {
            row.setOnMouseClicked(event -> {
                if (!row.isEmpty()) {
                    this.onMouseClickedEvent.accept(row.getItem(), (MouseEvent)event);
                }
            });
        }
        if (this.contextMenuFactory != null) {
            row.setOnContextMenuRequested(event -> {
                if (!row.isEmpty()) {
                    row.setContextMenu(this.contextMenuFactory.apply(row.getItem()));
                    row.getContextMenu().show((Node)row, event.getScreenX(), event.getScreenY());
                }
                event.consume();
            });
            tableView.addEventHandler(KeyEvent.KEY_RELEASED, event -> {
                boolean rowFocused;
                boolean bl = rowFocused = !row.isEmpty() && tableView.getFocusModel().getFocusedIndex() == row.getIndex();
                if (event.getCode() == KeyCode.CONTEXT_MENU && rowFocused) {
                    Bounds anchorBounds = row.getBoundsInParent();
                    double x = anchorBounds.getMinX() + anchorBounds.getWidth() / 2.0;
                    double y = anchorBounds.getMinY() + anchorBounds.getHeight() / 2.0;
                    Point2D screenPosition = row.getParent().localToScreen(x, y);
                    if (row.getContextMenu() == null) {
                        row.setContextMenu(this.contextMenuFactory.apply(row.getItem()));
                    }
                    row.getContextMenu().show((Node)row, screenPosition.getX(), screenPosition.getY());
                }
            });
        }
        if (this.toOnDragDetected != null) {
            row.setOnDragDetected(event -> {
                if (!row.isEmpty()) {
                    this.toOnDragDetected.accept((Object)row, row.getItem(), (Object)event);
                }
            });
        }
        if (this.toOnDragDropped != null) {
            row.setOnDragDropped(event -> {
                if (!row.isEmpty()) {
                    this.toOnDragDropped.accept((Object)row, row.getItem(), (Object)event);
                }
            });
        }
        if (this.toOnDragEntered != null) {
            row.setOnDragEntered(event -> {
                if (!row.isEmpty()) {
                    this.toOnDragEntered.accept(row.getItem(), (DragEvent)event);
                }
            });
        }
        if (this.toOnDragExited != null) {
            row.setOnDragExited(event -> {
                if (!row.isEmpty()) {
                    this.toOnDragExited.accept((Object)row, row.getItem(), (Object)event);
                }
            });
        }
        if (this.toOnDragOver != null) {
            row.setOnDragOver(event -> {
                if (!row.isEmpty()) {
                    this.toOnDragOver.accept((Object)row, row.getItem(), (Object)event);
                }
            });
        }
        if (this.toOnMouseDragEntered != null) {
            row.setOnMouseDragEntered(event -> {
                if (!row.isEmpty()) {
                    this.toOnMouseDragEntered.accept((Object)row, row.getItem(), (Object)event);
                }
            });
        }
        return row;
    }

    public void install(TableView<S> table) {
        table.setRowFactory((Callback)this);
    }
}

