/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.model.strings.StringUtil;

public class ViewModelTreeTableCellFactory<S>
implements Callback<TreeTableColumn<S, S>, TreeTableCell<S, S>> {
    private Callback<S, String> toText;
    private Callback<S, Node> toGraphic;
    private Callback<S, EventHandler<? super MouseEvent>> toOnMouseClickedEvent;
    private Callback<S, String> toTooltip;

    public ViewModelTreeTableCellFactory<S> withText(Callback<S, String> toText) {
        this.toText = toText;
        return this;
    }

    public ViewModelTreeTableCellFactory<S> withGraphic(Callback<S, Node> toGraphic) {
        this.toGraphic = toGraphic;
        return this;
    }

    public ViewModelTreeTableCellFactory<S> withIcon(Callback<S, JabRefIcon> toIcon) {
        this.toGraphic = viewModel -> ((JabRefIcon)toIcon.call(viewModel)).getGraphicNode();
        return this;
    }

    public ViewModelTreeTableCellFactory<S> withTooltip(Callback<S, String> toTooltip) {
        this.toTooltip = toTooltip;
        return this;
    }

    public ViewModelTreeTableCellFactory<S> withOnMouseClickedEvent(Callback<S, EventHandler<? super MouseEvent>> toOnMouseClickedEvent) {
        this.toOnMouseClickedEvent = toOnMouseClickedEvent;
        return this;
    }

    public TreeTableCell<S, S> call(TreeTableColumn<S, S> param) {
        return new TreeTableCell<S, S>(){

            protected void updateItem(S viewModel, boolean empty) {
                super.updateItem(viewModel, empty);
                if (empty || viewModel == null) {
                    this.setText(null);
                    this.setGraphic(null);
                    this.setOnMouseClicked(null);
                } else {
                    String tooltip;
                    if (ViewModelTreeTableCellFactory.this.toText != null) {
                        this.setText((String)ViewModelTreeTableCellFactory.this.toText.call(viewModel));
                    }
                    if (ViewModelTreeTableCellFactory.this.toGraphic != null) {
                        this.setGraphic((Node)ViewModelTreeTableCellFactory.this.toGraphic.call(viewModel));
                    }
                    if (ViewModelTreeTableCellFactory.this.toTooltip != null && StringUtil.isNotBlank(tooltip = (String)ViewModelTreeTableCellFactory.this.toTooltip.call(viewModel))) {
                        this.setTooltip(new Tooltip(tooltip));
                    }
                    if (ViewModelTreeTableCellFactory.this.toOnMouseClickedEvent != null) {
                        this.setOnMouseClicked((EventHandler)ViewModelTreeTableCellFactory.this.toOnMouseClickedEvent.call(viewModel));
                    }
                }
            }
        };
    }

    public void install(TreeTableColumn<S, S> column) {
        column.setCellValueFactory(cellData -> cellData.getValue().valueProperty());
        column.setCellFactory((Callback)this);
    }
}

