/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.jabref.gui.util.BaseDialog;
import org.jabref.logic.l10n.Localization;

public class ZipFileChooser
extends BaseDialog<Path> {
    public ZipFileChooser(FileSystem zipFile) throws IOException {
        this.setTitle(Localization.lang("Select file from ZIP-archive", new Object[0]));
        TableView table = new TableView(ZipFileChooser.getSelectableZipEntries(zipFile));
        TableColumn nameColumn = new TableColumn(Localization.lang("Name", new Object[0]));
        TableColumn modifiedColumn = new TableColumn(Localization.lang("Last modified", new Object[0]));
        TableColumn sizeColumn = new TableColumn(Localization.lang("Size", new Object[0]));
        table.getColumns().add((Object)nameColumn);
        table.getColumns().add((Object)modifiedColumn);
        table.getColumns().add((Object)sizeColumn);
        nameColumn.setCellValueFactory(data -> new ReadOnlyStringWrapper(((Path)data.getValue()).toString()));
        modifiedColumn.setCellValueFactory(data -> {
            try {
                return new ReadOnlyStringWrapper(ZonedDateTime.ofInstant(Files.getLastModifiedTime((Path)data.getValue(), new LinkOption[0]).toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM)));
            }
            catch (IOException e) {
                return new ReadOnlyStringWrapper("");
            }
        });
        sizeColumn.setCellValueFactory(data -> {
            try {
                return new ReadOnlyLongWrapper(Files.size((Path)data.getValue()));
            }
            catch (IOException e) {
                return new ReadOnlyLongWrapper(0L);
            }
        });
        table.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.getDialogPane().setContent((Node)table);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setResultConverter(button -> {
            if (button == ButtonType.OK) {
                return (Path)table.getSelectionModel().getSelectedItem();
            }
            return null;
        });
    }

    private static ObservableList<Path> getSelectableZipEntries(FileSystem zipFile) throws IOException {
        Path rootDir = zipFile.getRootDirectories().iterator().next();
        return FXCollections.observableArrayList((Collection)Files.walk(rootDir, new FileVisitOption[0]).filter(file -> file.endsWith(".class")).collect(Collectors.toList()));
    }
}

