/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex;

import java.util.Collection;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.model.entry.field.Field;

public class FieldPreferences {
    private final BooleanProperty resolveStrings = new SimpleBooleanProperty();
    private final ObservableList<Field> resolvableFields;
    private final ObservableList<Field> nonWrappableFields;

    public FieldPreferences(boolean resolveStrings, List<Field> resolvableFields, List<Field> nonWrappableFields) {
        this.resolveStrings.set(resolveStrings);
        this.resolvableFields = FXCollections.observableArrayList(resolvableFields);
        this.nonWrappableFields = FXCollections.observableArrayList(nonWrappableFields);
    }

    public boolean shouldResolveStrings() {
        return this.resolveStrings.get();
    }

    public BooleanProperty resolveStringsProperty() {
        return this.resolveStrings;
    }

    public void setResolveStrings(boolean resolveStrings) {
        this.resolveStrings.set(resolveStrings);
    }

    public ObservableList<Field> getResolvableFields() {
        return this.resolvableFields;
    }

    public void setResolvableFields(Collection<Field> list) {
        this.resolvableFields.clear();
        this.resolvableFields.addAll(list);
    }

    public ObservableList<Field> getNonWrappableFields() {
        return this.nonWrappableFields;
    }

    public void setNonWrappableFields(Collection<Field> list) {
        this.nonWrappableFields.clear();
        this.nonWrappableFields.addAll(list);
    }
}

