/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex;

import org.jabref.logic.bibtex.FieldPreferences;
import org.jabref.logic.bibtex.InvalidFieldValueException;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldWriter {
    public static final char BIBTEX_STRING_START_END_SYMBOL = '#';
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldWriter.class);
    private static final char FIELD_START = '{';
    private static final char FIELD_END = '}';
    private final boolean neverFailOnHashes;
    private final FieldPreferences preferences;

    public FieldWriter(FieldPreferences preferences) {
        this(true, preferences);
    }

    private FieldWriter(boolean neverFailOnHashes, FieldPreferences preferences) {
        this.neverFailOnHashes = neverFailOnHashes;
        this.preferences = preferences;
    }

    public static FieldWriter buildIgnoreHashes(FieldPreferences prefs) {
        return new FieldWriter(true, prefs);
    }

    private static void checkBraces(String text) throws InvalidFieldValueException {
        int left = 0;
        int right = 0;
        for (int i = 0; i < text.length(); ++i) {
            char item = text.charAt(i);
            boolean charBeforeIsEscape = false;
            if (i > 0 && text.charAt(i - 1) == '\\') {
                charBeforeIsEscape = true;
            }
            if (!charBeforeIsEscape && item == '{') {
                ++left;
                continue;
            }
            if (charBeforeIsEscape || item != '}') continue;
            ++right;
        }
        if (right != 0 && left == 0) {
            LOGGER.error("Unescaped '}' character without opening bracket ends string prematurely. Field value: {}", (Object)text);
            throw new InvalidFieldValueException("Unescaped '}' character without opening bracket ends string prematurely. Field value: " + text);
        }
        if (right != 0 && right < left) {
            LOGGER.error("Unescaped '}' character without opening bracket ends string prematurely. Field value: {}", (Object)text);
            throw new InvalidFieldValueException("Unescaped '}' character without opening bracket ends string prematurely. Field value: " + text);
        }
        if (left != right) {
            LOGGER.error("Braces don't match. Field value: {}", (Object)text);
            throw new InvalidFieldValueException("Braces don't match. Field value: " + text);
        }
    }

    public String write(Field field, String content) throws InvalidFieldValueException {
        if (content == null) {
            return "{}";
        }
        if (!this.shouldResolveStrings(field) || field.equals(InternalField.BIBTEX_STRING)) {
            return this.formatWithoutResolvingStrings(content, field);
        }
        return this.formatAndResolveStrings(content, field);
    }

    private String formatAndResolveStrings(String content, Field field) throws InvalidFieldValueException {
        FieldWriter.checkBraces(content);
        content = content.replace("##", "");
        StringBuilder stringBuilder = new StringBuilder();
        int pivot = 0;
        while (pivot < content.length()) {
            int pos2;
            int pos1 = FieldWriter.getFirstOccurrenceOfStartEndSymbol(content, pivot);
            if (pos1 == -1) {
                pos1 = content.length();
                pos2 = -1;
            } else {
                pos2 = content.indexOf(35, pos1 + 1);
            }
            if (pos2 == -1) {
                if (this.neverFailOnHashes) {
                    pos1 = content.length();
                } else {
                    LOGGER.error("The character {} is not allowed in BibTeX strings unless escaped as in '\\{}'. In JabRef, use pairs of # characters to indicate a string. Note that the entry causing the problem has been selected. Field value: {}", new Object[]{Character.valueOf('#'), Character.valueOf('#'), content});
                    throw new InvalidFieldValueException("The character # is not allowed in BibTeX strings unless escaped as in '\\#'.\nIn JabRef, use pairs of # characters to indicate a string.\nNote that the entry causing the problem has been selected. Field value: " + content);
                }
            }
            if (pos1 > pivot) {
                this.writeText(stringBuilder, content, pivot, pos1);
            }
            if (pos1 < content.length() && pos2 - 1 > pos1) {
                this.writeStringLabel(stringBuilder, content, pos1 + 1, pos2, pos1 == pivot, pos2 + 1 == content.length());
            }
            if (pos2 > -1) {
                pivot = pos2 + 1;
                continue;
            }
            pivot = pos1 + 1;
        }
        return stringBuilder.toString();
    }

    private static int getFirstOccurrenceOfStartEndSymbol(String content, int pivot) {
        int goFrom = pivot;
        int pos1 = pivot;
        while (goFrom == pos1 && (pos1 = content.indexOf(35, goFrom)) > 0 && content.charAt(pos1 - 1) == '\\') {
            goFrom = ++pos1;
        }
        return pos1;
    }

    private boolean shouldResolveStrings(Field field) {
        if (this.preferences.shouldResolveStrings()) {
            return this.preferences.getResolvableFields().contains((Object)field);
        }
        return false;
    }

    private String formatWithoutResolvingStrings(String content, Field field) throws InvalidFieldValueException {
        FieldWriter.checkBraces(content);
        StringBuilder stringBuilder = new StringBuilder(String.valueOf('{'));
        stringBuilder.append(content);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private void writeText(StringBuilder stringBuilder, String text, int startPos, int endPos) {
        stringBuilder.append('{');
        stringBuilder.append(text, startPos, endPos);
        stringBuilder.append('}');
    }

    private void writeStringLabel(StringBuilder stringBuilder, String text, int startPos, int endPos, boolean isFirst, boolean isLast) {
        String line = (isFirst ? "" : " # ") + text.substring(startPos, endPos) + (isLast ? "" : " # ");
        stringBuilder.append(line);
    }
}

