/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex.comparator;

import java.util.Objects;
import java.util.Optional;
import org.jabref.model.database.BibDatabaseContext;

public class PreambleDiff {
    private final String originalPreamble;
    private final String newPreamble;

    PreambleDiff(String originalPreamble, String newPreamble) {
        this.originalPreamble = originalPreamble;
        this.newPreamble = newPreamble;
    }

    public static Optional<PreambleDiff> compare(BibDatabaseContext originalDatabase, BibDatabaseContext newDatabase) {
        Optional<String> newPreamble;
        Optional<String> originalPreamble = originalDatabase.getDatabase().getPreamble();
        if (originalPreamble.equals(newPreamble = newDatabase.getDatabase().getPreamble())) {
            return Optional.empty();
        }
        return Optional.of(new PreambleDiff(originalPreamble.orElse(""), newPreamble.orElse("")));
    }

    public String getNewPreamble() {
        return this.newPreamble;
    }

    public String getOriginalPreamble() {
        return this.originalPreamble;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PreambleDiff that = (PreambleDiff)other;
        return Objects.equals(this.newPreamble, that.newPreamble) && Objects.equals(this.originalPreamble, that.originalPreamble);
    }

    public int hashCode() {
        return Objects.hash(this.originalPreamble, this.newPreamble);
    }

    public String toString() {
        return "PreambleDiff{originalPreamble='" + this.originalPreamble + "', newPreamble='" + this.newPreamble + "'}";
    }
}

