/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bst;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jabref.logic.bst.BstVM;
import org.jabref.logic.cleanup.ConvertToBibtexCleanup;
import org.jabref.logic.formatter.bibtexfields.RemoveNewlinesFormatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.format.LatexToUnicodeFormatter;
import org.jabref.logic.layout.format.RemoveLatexCommandsFormatter;
import org.jabref.logic.layout.format.RemoveTilde;
import org.jabref.logic.preview.PreviewLayout;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BstPreviewLayout
implements PreviewLayout {
    private static final Logger LOGGER = LoggerFactory.getLogger(BstPreviewLayout.class);
    private final String name;
    private String source;
    private BstVM bstVM;
    private String error;

    public BstPreviewLayout(Path path) {
        try {
            this.source = String.join((CharSequence)"\n", Files.readAllLines(path));
        }
        catch (IOException e) {
            LOGGER.error("Error reading file", (Throwable)e);
            this.source = "";
        }
        this.name = path.getFileName().toString();
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.error("File {} not found", (Object)path.toAbsolutePath());
            this.error = Localization.lang("Error opening file '%0'", path.toString());
            return;
        }
        try {
            this.bstVM = new BstVM(path);
        }
        catch (Exception e) {
            LOGGER.error("Could not read {}.", (Object)path.toAbsolutePath(), (Object)e);
            this.error = Localization.lang("Error opening file '%0'", path.toString());
        }
    }

    @Override
    public String generatePreview(BibEntry originalEntry, BibDatabaseContext databaseContext) {
        if (this.error != null) {
            return this.error;
        }
        BibEntry entry = (BibEntry)originalEntry.clone();
        new ConvertToBibtexCleanup().cleanup(entry);
        String result = this.bstVM.render(List.of(entry));
        result = result.replaceAll("%.*", "");
        result = result.replace("\\begin{thebibliography}{1}", "");
        result = result.replace("\\end{thebibliography}", "");
        result = result.replaceAll("\\\\bibitem[{].*[}]", "");
        result = result.replace("\\newblock", " ");
        result = result.replaceAll("(?m)^\\\\.*$", "");
        result = result.replace("#2}}", "");
        result = new LatexToUnicodeFormatter().format(result);
        result = result.replace("``", "\"");
        result = result.replace("''", "\"");
        result = new RemoveNewlinesFormatter().format(result);
        result = new RemoveLatexCommandsFormatter().format(result);
        result = new RemoveTilde().format(result);
        result = result.trim().replaceAll("  +", " ");
        return result;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getText() {
        return this.source;
    }

    public static boolean isBstStyleFile(String styleFile) {
        return StandardFileType.BST.getExtensions().stream().anyMatch(styleFile::endsWith);
    }
}

