/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.citationkeypattern;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.logic.citationkeypattern.CitationKeyPattern;
import org.jabref.model.entry.types.EntryType;

public abstract class AbstractCitationKeyPatterns {
    protected CitationKeyPattern defaultPattern = CitationKeyPattern.NULL_CITATION_KEY_PATTERN;
    protected Map<EntryType, CitationKeyPattern> data = new HashMap<EntryType, CitationKeyPattern>();

    public void addCitationKeyPattern(EntryType type, String pattern) {
        this.data.put(type, new CitationKeyPattern(pattern));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractCitationKeyPattern{");
        sb.append("defaultPattern=").append(this.defaultPattern);
        sb.append(", data=").append(this.data);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCitationKeyPatterns that = (AbstractCitationKeyPatterns)o;
        return Objects.equals(this.defaultPattern, that.defaultPattern) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.defaultPattern, this.data);
    }

    public CitationKeyPattern getValue(EntryType entryType) {
        CitationKeyPattern result = this.data.get(entryType);
        if (result == null && ((result = this.getDefaultValue()) == null || CitationKeyPattern.NULL_CITATION_KEY_PATTERN.equals(result))) {
            return this.getLastLevelCitationKeyPattern(entryType);
        }
        return result;
    }

    public final boolean isDefaultValue(EntryType entryType) {
        return this.data.get(entryType) == null;
    }

    public CitationKeyPattern getDefaultValue() {
        return this.defaultPattern;
    }

    public void setDefaultValue(String bibtexKeyPattern) {
        Objects.requireNonNull(bibtexKeyPattern);
        this.defaultPattern = new CitationKeyPattern(bibtexKeyPattern);
    }

    public Set<EntryType> getAllKeys() {
        return this.data.keySet();
    }

    public Map<EntryType, CitationKeyPattern> getPatterns() {
        return this.data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public abstract CitationKeyPattern getLastLevelCitationKeyPattern(EntryType var1);
}

