/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.citationkeypattern;

import java.math.BigInteger;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jabref.logic.citationkeypattern.CitationKeyGenerator;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.formatter.Formatters;
import org.jabref.logic.formatter.casechanger.Word;
import org.jabref.logic.layout.format.RemoveLatexCommandsFormatter;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.KeywordList;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.strings.LatexToUnicodeAdapter;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BracketedPattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(BracketedPattern.class);
    private static final int CHARS_OF_FIRST = 5;
    private static final int MAX_ALPHA_AUTHORS = 4;
    private static final Pattern NOT_DECIMAL_DIGIT = Pattern.compile("\\P{Nd}");
    private static final Pattern NOT_CAPITAL_CHARACTER = Pattern.compile("[^A-Z]");
    private static final Pattern INLINE_ABBREVIATION = Pattern.compile("(?<=\\(\\{)[A-Z]+(?=}\\))");
    private static final Pattern DEPARTMENTS = Pattern.compile("^d[ei]p.*", 2);
    private static final Pattern WHITESPACE = Pattern.compile("\\p{javaWhitespace}");
    private final String pattern;

    public BracketedPattern() {
        this.pattern = null;
    }

    public BracketedPattern(String pattern) {
        this.pattern = pattern;
    }

    public String toString() {
        return this.getClass().getName() + "[pattern=" + this.pattern + "]";
    }

    public String expand(BibEntry bibentry) {
        return this.expand(bibentry, null);
    }

    public String expand(BibEntry bibentry, BibDatabase database) {
        Objects.requireNonNull(bibentry);
        Character keywordDelimiter = Character.valueOf(';');
        return this.expand(bibentry, keywordDelimiter, database);
    }

    public String expand(BibEntry bibentry, Character keywordDelimiter, BibDatabase database) {
        Objects.requireNonNull(bibentry);
        return BracketedPattern.expandBrackets(this.pattern, keywordDelimiter, bibentry, database);
    }

    public static String expandBrackets(String pattern, Character keywordDelimiter, BibEntry entry, BibDatabase database) {
        Objects.requireNonNull(pattern);
        Objects.requireNonNull(entry);
        return BracketedPattern.expandBrackets(pattern, BracketedPattern.expandBracketContent(keywordDelimiter, entry, database));
    }

    public static Function<String, String> expandBracketContent(Character keywordDelimiter, BibEntry entry, BibDatabase database) {
        return bracket -> {
            List<String> fieldParts = BracketedPattern.parseFieldAndModifiers(bracket);
            String expandedPattern = BracketedPattern.getFieldValue(entry, fieldParts.getFirst(), keywordDelimiter, database);
            if (fieldParts.size() > 1) {
                expandedPattern = BracketedPattern.applyModifiers(expandedPattern, fieldParts, 1, BracketedPattern.expandBracketContent(keywordDelimiter, entry, database));
            }
            return expandedPattern;
        };
    }

    public static String expandBrackets(String pattern, Function<String, String> bracketContentHandler) {
        Objects.requireNonNull(pattern);
        StringBuilder expandedPattern = new StringBuilder();
        StringTokenizer parsedPattern = new StringTokenizer(pattern, "\\[]\"", true);
        block10: while (parsedPattern.hasMoreTokens()) {
            String token;
            switch (token = parsedPattern.nextToken()) {
                case "\"": {
                    BracketedPattern.appendQuote(expandedPattern, parsedPattern);
                    continue block10;
                }
                case "[": {
                    String fieldMarker = BracketedPattern.contentBetweenBrackets(parsedPattern, pattern);
                    expandedPattern.append(bracketContentHandler.apply(fieldMarker));
                    continue block10;
                }
                case "\\": {
                    if (parsedPattern.hasMoreTokens()) {
                        expandedPattern.append(parsedPattern.nextToken());
                        continue block10;
                    }
                    LOGGER.warn("Found a \"\\\" that is not part of an escape sequence");
                    continue block10;
                }
            }
            expandedPattern.append(token);
        }
        return expandedPattern.toString();
    }

    private static String contentBetweenBrackets(StringTokenizer tokenizer, String pattern) {
        StringBuilder bracketContent = new StringBuilder();
        boolean foundClosingBracket = false;
        int subBrackets = 0;
        block10: while (tokenizer.hasMoreTokens() && !foundClosingBracket) {
            String token;
            switch (token = tokenizer.nextToken()) {
                case "\"": {
                    BracketedPattern.appendQuote(bracketContent, tokenizer);
                    continue block10;
                }
                case "]": {
                    if (subBrackets == 0) {
                        foundClosingBracket = true;
                        continue block10;
                    }
                    --subBrackets;
                    bracketContent.append(token);
                    continue block10;
                }
                case "[": {
                    ++subBrackets;
                    bracketContent.append(token);
                    continue block10;
                }
            }
            bracketContent.append(token);
        }
        if (!foundClosingBracket) {
            LOGGER.warn("Missing closing bracket ']' in '{}'", (Object)pattern);
        } else if (bracketContent.length() == 0) {
            LOGGER.warn("Found empty brackets \"[]\" in '{}'", (Object)pattern);
        }
        return bracketContent.toString();
    }

    private static void appendQuote(StringBuilder stringBuilder, StringTokenizer tokenizer) {
        stringBuilder.append("\"");
        String token = "";
        while (tokenizer.hasMoreTokens() && !"\"".equals(token)) {
            token = tokenizer.nextToken();
            stringBuilder.append(token);
        }
    }

    public static String getFieldValue(BibEntry entry, String pattern, Character keywordDelimiter, BibDatabase database) {
        try {
            if (pattern.startsWith("auth") || pattern.startsWith("pureauth")) {
                String unparsedAuthors = entry.getResolvedFieldOrAlias(StandardField.AUTHOR, database).orElse("");
                if (pattern.startsWith("pure")) {
                    pattern = pattern.substring(4);
                } else if (unparsedAuthors.isEmpty()) {
                    unparsedAuthors = entry.getResolvedFieldOrAlias(StandardField.EDITOR, database).orElse("");
                }
                AuthorList authorList = BracketedPattern.createAuthorList(unparsedAuthors);
                switch (pattern) {
                    case "auth": {
                        return BracketedPattern.firstAuthor(authorList);
                    }
                    case "authForeIni": {
                        return BracketedPattern.firstAuthorForenameInitials(authorList);
                    }
                    case "authFirstFull": {
                        return BracketedPattern.firstAuthorVonAndLast(authorList);
                    }
                    case "authors": {
                        return BracketedPattern.allAuthors(authorList);
                    }
                    case "authorsAlpha": {
                        return BracketedPattern.authorsAlpha(authorList);
                    }
                    case "authorLast": {
                        return BracketedPattern.lastAuthor(authorList);
                    }
                    case "authorLastForeIni": {
                        return BracketedPattern.lastAuthorForenameInitials(authorList);
                    }
                    case "authorIni": {
                        return BracketedPattern.oneAuthorPlusInitials(authorList);
                    }
                    case "auth.auth.ea": {
                        return BracketedPattern.authAuthEa(authorList);
                    }
                    case "auth.etal": {
                        return BracketedPattern.authEtal(authorList, ".", ".etal");
                    }
                    case "authEtAl": {
                        return BracketedPattern.authEtal(authorList, "", "EtAl");
                    }
                    case "authshort": {
                        return BracketedPattern.authShort(authorList);
                    }
                }
                if (pattern.matches("authIni[\\d]+")) {
                    int num = Integer.parseInt(pattern.substring(7));
                    return BracketedPattern.authIniN(authorList, num);
                }
                if (pattern.matches("auth[\\d]+_[\\d]+")) {
                    String[] nums = pattern.substring(4).split("_");
                    return BracketedPattern.authNofMth(authorList, Integer.parseInt(nums[0]), Integer.parseInt(nums[1]));
                }
                if (pattern.matches("auth\\d+")) {
                    int num = Integer.parseInt(pattern.substring(4));
                    return BracketedPattern.authN(authorList, num);
                }
                if (pattern.matches("authors\\d+")) {
                    return BracketedPattern.nAuthors(authorList, Integer.parseInt(pattern.substring(7)));
                }
                return entry.getResolvedFieldOrAlias(FieldFactory.parseField(pattern), database).orElse("");
            }
            if (pattern.startsWith("ed")) {
                String unparsedEditors = entry.getResolvedFieldOrAlias(StandardField.EDITOR, database).orElse("");
                AuthorList editorList = BracketedPattern.createAuthorList(unparsedEditors);
                switch (pattern) {
                    case "edtr": {
                        return BracketedPattern.firstAuthor(editorList);
                    }
                    case "edtrForeIni": {
                        return BracketedPattern.firstAuthorForenameInitials(editorList);
                    }
                    case "editors": {
                        return BracketedPattern.allAuthors(editorList);
                    }
                    case "editorLast": {
                        return BracketedPattern.lastAuthor(editorList);
                    }
                    case "editorLastForeIni": {
                        return BracketedPattern.lastAuthorForenameInitials(editorList);
                    }
                    case "editorIni": {
                        return BracketedPattern.oneAuthorPlusInitials(editorList);
                    }
                    case "edtr.edtr.ea": {
                        return BracketedPattern.authAuthEa(editorList);
                    }
                    case "edtrshort": {
                        return BracketedPattern.authShort(editorList);
                    }
                }
                if (pattern.matches("edtrIni[\\d]+")) {
                    int num = Integer.parseInt(pattern.substring(7));
                    return BracketedPattern.authIniN(editorList, num);
                }
                if (pattern.matches("edtr[\\d]+_[\\d]+")) {
                    String[] nums = pattern.substring(4).split("_");
                    return BracketedPattern.authNofMth(editorList, Integer.parseInt(nums[0]), Integer.parseInt(nums[1]));
                }
                if (pattern.matches("edtr\\d+")) {
                    String fa = BracketedPattern.firstAuthor(editorList);
                    int num = Integer.parseInt(pattern.substring(4));
                    if (num > fa.length()) {
                        num = fa.length();
                    }
                    return fa.substring(0, num);
                }
                return entry.getResolvedFieldOrAlias(FieldFactory.parseField(pattern), database).orElse("");
            }
            if ("firstpage".equals(pattern)) {
                return BracketedPattern.firstPage(entry.getResolvedFieldOrAlias(StandardField.PAGES, database).orElse(""));
            }
            if ("pageprefix".equals(pattern)) {
                return BracketedPattern.pagePrefix(entry.getResolvedFieldOrAlias(StandardField.PAGES, database).orElse(""));
            }
            if ("lastpage".equals(pattern)) {
                return BracketedPattern.lastPage(entry.getResolvedFieldOrAlias(StandardField.PAGES, database).orElse(""));
            }
            if ("title".equals(pattern)) {
                return BracketedPattern.camelizeSignificantWordsInTitle(entry.getResolvedFieldOrAlias(StandardField.TITLE, database).orElse(""));
            }
            if ("fulltitle".equals(pattern)) {
                return entry.getResolvedFieldOrAlias(StandardField.TITLE, database).orElse("");
            }
            if ("shorttitle".equals(pattern)) {
                return BracketedPattern.getTitleWords(3, BracketedPattern.removeSmallWords(entry.getResolvedFieldOrAlias(StandardField.TITLE, database).orElse("")));
            }
            if ("shorttitleINI".equals(pattern)) {
                return BracketedPattern.keepLettersAndDigitsOnly(BracketedPattern.applyModifiers(BracketedPattern.getTitleWordsWithSpaces(3, entry.getResolvedFieldOrAlias(StandardField.TITLE, database).orElse("")), Collections.singletonList("abbr"), 0, Function.identity()));
            }
            if ("veryshorttitle".equals(pattern)) {
                return BracketedPattern.getTitleWords(1, BracketedPattern.removeSmallWords(entry.getResolvedFieldOrAlias(StandardField.TITLE, database).orElse("")));
            }
            if (pattern.matches("camel[\\d]+")) {
                int num = Integer.parseInt(pattern.substring(5));
                return BracketedPattern.getCamelizedTitle_N(entry.getResolvedFieldOrAlias(StandardField.TITLE, database).orElse(""), num);
            }
            if ("camel".equals(pattern)) {
                return BracketedPattern.getCamelizedTitle(entry.getResolvedFieldOrAlias(StandardField.TITLE, database).orElse(""));
            }
            if ("shortyear".equals(pattern)) {
                String yearString = entry.getResolvedFieldOrAlias(StandardField.YEAR, database).orElse("");
                if (yearString.isEmpty()) {
                    return yearString;
                }
                if (yearString.startsWith("in") || yearString.startsWith("sub")) {
                    return "IP";
                }
                if (yearString.length() > 2) {
                    return yearString.substring(yearString.length() - 2);
                }
                return yearString;
            }
            if ("entrytype".equals(pattern)) {
                return entry.getResolvedFieldOrAlias(InternalField.TYPE_HEADER, database).orElse("");
            }
            if (pattern.matches("keyword\\d+")) {
                int num = Integer.parseInt(pattern.substring(7));
                KeywordList separatedKeywords = entry.getResolvedKeywords(keywordDelimiter, database);
                if (separatedKeywords.size() < num) {
                    return "";
                }
                return separatedKeywords.get(num - 1).toString();
            }
            if (pattern.matches("keywords\\d*")) {
                int num = pattern.length() > 8 ? Integer.parseInt(pattern.substring(8)) : Integer.MAX_VALUE;
                KeywordList separatedKeywords = entry.getResolvedKeywords(keywordDelimiter, database);
                StringBuilder sb = new StringBuilder();
                int i = 0;
                for (Keyword keyword : separatedKeywords) {
                    sb.append(keyword.toString().replaceAll("\\s+", ""));
                    if (++i < num) continue;
                    break;
                }
                return sb.toString();
            }
            return entry.getResolvedFieldOrAlias(FieldFactory.parseField(pattern), database).orElse("");
        }
        catch (NullPointerException ex) {
            LOGGER.debug("Problem making expanding bracketed expression", (Throwable)ex);
            return "";
        }
    }

    private static AuthorList createAuthorList(String unparsedAuthors) {
        return AuthorList.parse(unparsedAuthors).getAuthors().stream().map(author -> {
            String lastName = author.getFamilyName().map(lastPart -> BracketedPattern.isInstitution(author) ? BracketedPattern.generateInstitutionKey(lastPart) : LatexToUnicodeAdapter.format(lastPart)).orElse(null);
            return new Author(author.getGivenName().map(LatexToUnicodeAdapter::format).orElse(null), author.getGivenNameAbbreviated().map(LatexToUnicodeAdapter::format).orElse(null), author.getNamePrefix().map(LatexToUnicodeAdapter::format).orElse(null), lastName, author.getNameSuffix().map(LatexToUnicodeAdapter::format).orElse(null));
        }).collect(AuthorList.collect());
    }

    private static boolean isInstitution(Author author) {
        return author.getGivenName().isEmpty() && author.getGivenNameAbbreviated().isEmpty() && author.getNameSuffix().isEmpty() && author.getNamePrefix().isEmpty() && author.getFamilyName().isPresent() && WHITESPACE.matcher(author.getFamilyName().get()).find();
    }

    static String applyModifiers(String label, List<String> parts, int offset, Function<String, String> expandBracketContent) {
        String resultingLabel = label;
        for (int j = offset; j < parts.size(); ++j) {
            String modifier = parts.get(j);
            if ("abbr".equals(modifier)) {
                String[] words;
                StringBuilder abbreviateSB = new StringBuilder();
                for (String word : words = resultingLabel.replaceAll("[\\{\\}']", "").split("[\\(\\) \r\n\"]")) {
                    if (word.isEmpty()) continue;
                    abbreviateSB.append(word.charAt(0));
                }
                resultingLabel = abbreviateSB.toString();
                continue;
            }
            Optional<Formatter> formatter = Formatters.getFormatterForModifier(modifier);
            if (formatter.isPresent()) {
                resultingLabel = formatter.get().format(resultingLabel);
                continue;
            }
            if (!modifier.isEmpty() && modifier.length() >= 2 && modifier.charAt(0) == '(' && modifier.endsWith(")")) {
                if (!label.isEmpty() || modifier.length() <= 2) continue;
                resultingLabel = BracketedPattern.expandBrackets(modifier.substring(1, modifier.length() - 1), expandBracketContent);
                continue;
            }
            LOGGER.warn("Key generator warning: unknown modifier '{}'.", (Object)modifier);
        }
        return resultingLabel;
    }

    public static String getTitleWords(int number, String title) {
        return BracketedPattern.getTitleWordsWithSpaces(number, title);
    }

    private static String formatTitle(String title) {
        String ss = new RemoveLatexCommandsFormatter().format(title);
        StringBuilder stringBuilder = new StringBuilder();
        int piv = 0;
        while (piv < ss.length()) {
            StringBuilder current = new StringBuilder();
            while (piv < ss.length() && !Character.isWhitespace(ss.charAt(piv)) && ss.charAt(piv) != '-') {
                current.append(ss.charAt(piv));
                ++piv;
            }
            ++piv;
            String word = current.toString().trim();
            if (word.isEmpty()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(word);
        }
        return stringBuilder.toString();
    }

    public static String getCamelizedTitle(String title) {
        return BracketedPattern.keepLettersAndDigitsOnly(BracketedPattern.camelizeTitle(title));
    }

    private static String camelizeTitle(String title) {
        StringBuilder stringBuilder = new StringBuilder();
        String formattedTitle = BracketedPattern.formatTitle(title);
        try (Scanner titleScanner = new Scanner(formattedTitle);){
            while (titleScanner.hasNext()) {
                Object word = titleScanner.next();
                word = ((String)word).substring(0, 1).toUpperCase(Locale.ROOT) + ((String)word).substring(1);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append((String)word);
            }
        }
        return stringBuilder.toString();
    }

    public static String getCamelizedTitle_N(String title, int number) {
        return BracketedPattern.keepLettersAndDigitsOnly(BracketedPattern.camelizeTitle_N(title, number));
    }

    private static String camelizeTitle_N(String title, int number) {
        StringBuilder stringBuilder = new StringBuilder();
        String formattedTitle = BracketedPattern.formatTitle(title);
        try (Scanner titleScanner = new Scanner(formattedTitle);){
            while (titleScanner.hasNext()) {
                Object word = titleScanner.next();
                word = ((String)word).substring(0, 1).toUpperCase(Locale.ROOT) + ((String)word).substring(1);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append((String)word);
            }
        }
        String camelString = stringBuilder.toString();
        return BracketedPattern.getSomeWords(number, camelString);
    }

    public static String camelizeSignificantWordsInTitle(String title) {
        StringJoiner stringJoiner = new StringJoiner(" ");
        String formattedTitle = BracketedPattern.formatTitle(title);
        try (Scanner titleScanner = new Scanner(formattedTitle);){
            while (titleScanner.hasNext()) {
                Object word = titleScanner.next();
                boolean camelize = !Word.SMALLER_WORDS.contains(((String)word).toLowerCase(Locale.ROOT));
                word = camelize || stringJoiner.length() == 0 ? ((String)word).substring(0, 1).toUpperCase(Locale.ROOT) + ((String)word).substring(1) : ((String)word).substring(0, 1).toLowerCase(Locale.ROOT) + ((String)word).substring(1);
                stringJoiner.add((CharSequence)word);
            }
        }
        return stringJoiner.toString();
    }

    public static String removeSmallWords(String title) {
        String formattedTitle = BracketedPattern.formatTitle(title);
        try (Scanner titleScanner = new Scanner(formattedTitle);){
            String string = titleScanner.tokens().filter(Predicate.not(Word::isSmallerWord)).collect(Collectors.joining(" "));
            return string;
        }
    }

    private static String getTitleWordsWithSpaces(int number, String title) {
        String formattedTitle = BracketedPattern.formatTitle(title);
        return BracketedPattern.getSomeWords(number, formattedTitle);
    }

    private static String getSomeWords(int number, String string) {
        try (Scanner titleScanner = new Scanner(string);){
            String string2 = titleScanner.tokens().limit(number).collect(Collectors.joining(" "));
            return string2;
        }
    }

    private static String keepLettersAndDigitsOnly(String in) {
        return in.codePoints().filter(Character::isLetterOrDigit).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private static String firstAuthor(AuthorList authorList) {
        return authorList.getAuthors().stream().findFirst().flatMap(author -> author.getFamilyName().isPresent() ? author.getFamilyName() : author.getNamePrefix()).orElse("");
    }

    private static String firstAuthorForenameInitials(AuthorList authorList) {
        return authorList.getAuthors().stream().findFirst().flatMap(Author::getGivenNameAbbreviated).map(s -> s.substring(0, 1)).orElse("");
    }

    private static String firstAuthorVonAndLast(AuthorList authorList) {
        return authorList.isEmpty() ? "" : authorList.getAuthor(0).getNamePrefixAndFamilyName().replace(" ", "");
    }

    private static String lastAuthor(AuthorList authorList) {
        if (authorList.isEmpty()) {
            return "";
        }
        return authorList.getAuthors().get(authorList.getNumberOfAuthors() - 1).getFamilyName().orElse("");
    }

    private static String lastAuthorForenameInitials(AuthorList authorList) {
        if (authorList.isEmpty()) {
            return "";
        }
        return authorList.getAuthor(authorList.getNumberOfAuthors() - 1).getGivenNameAbbreviated().map(s -> s.substring(0, 1)).orElse("");
    }

    static String allAuthors(AuthorList authorList) {
        return BracketedPattern.joinAuthorsOnLastName(authorList, authorList.getNumberOfAuthors(), "", "EtAl");
    }

    static String authorsAlpha(AuthorList authorList) {
        boolean maxAuthorsExceeded;
        int maxAuthors;
        StringBuilder alphaStyle = new StringBuilder();
        if (authorList.getNumberOfAuthors() <= 4) {
            maxAuthors = authorList.getNumberOfAuthors();
            maxAuthorsExceeded = false;
        } else {
            maxAuthors = 3;
            maxAuthorsExceeded = true;
        }
        if (authorList.getNumberOfAuthors() == 1) {
            String[] firstAuthor = authorList.getAuthor(0).getNamePrefixAndFamilyName().replaceAll("\\s+", " ").trim().split(" ");
            for (int j = 0; j < firstAuthor.length - 1; ++j) {
                alphaStyle.append(firstAuthor[j], 0, 1);
            }
            alphaStyle.append(firstAuthor[firstAuthor.length - 1], 0, Math.min(3, firstAuthor[firstAuthor.length - 1].length()));
        } else {
            boolean andOthersPresent = authorList.getAuthor(maxAuthors - 1).equals(Author.OTHERS);
            if (andOthersPresent) {
                --maxAuthors;
            }
            List vonAndLastNames = authorList.getAuthors().stream().limit(maxAuthors).map(Author::getNamePrefixAndFamilyName).collect(Collectors.toList());
            for (String vonAndLast : vonAndLastNames) {
                String[] nameParts;
                for (String part : nameParts = vonAndLast.replaceAll("\\s+", " ").trim().split(" ")) {
                    alphaStyle.append(part, 0, 1);
                }
            }
            if (andOthersPresent || maxAuthorsExceeded) {
                alphaStyle.append("+");
            }
        }
        return alphaStyle.toString();
    }

    private static String joinAuthorsOnLastName(AuthorList authorList, int maxAuthors, String delimiter, String suffix) {
        String finalSuffix = authorList.getNumberOfAuthors() > maxAuthors ? suffix : "";
        return authorList.getAuthors().stream().map(author -> {
            if (author.equals(Author.OTHERS)) {
                if (suffix.startsWith(delimiter)) {
                    return Optional.of(suffix.substring(delimiter.length()));
                }
                return Optional.of(suffix);
            }
            return author.getFamilyName();
        }).flatMap(Optional::stream).limit(maxAuthors).collect(Collectors.joining(delimiter, "", finalSuffix));
    }

    private static String nAuthors(AuthorList authorList, int n) {
        return BracketedPattern.joinAuthorsOnLastName(authorList, n, "", "EtAl");
    }

    static String oneAuthorPlusInitials(AuthorList authorList) {
        if (authorList.isEmpty()) {
            return "";
        }
        StringBuilder authorSB = new StringBuilder();
        authorSB.append(BracketedPattern.authNofMth(authorList, 5, 1));
        for (int i = 2; i <= authorList.getNumberOfAuthors(); ++i) {
            authorSB.append(BracketedPattern.authNofMth(authorList, 1, i));
        }
        return authorSB.toString();
    }

    static String authAuthEa(AuthorList authorList) {
        return BracketedPattern.joinAuthorsOnLastName(authorList, 2, ".", ".ea");
    }

    static String authEtal(AuthorList authorList, String delim, String append) {
        if (authorList.isEmpty()) {
            return "";
        }
        if (!(authorList.getNumberOfAuthors() > 2 || authorList.getNumberOfAuthors() != 1 && authorList.getAuthor(1).equals(Author.OTHERS))) {
            return BracketedPattern.joinAuthorsOnLastName(authorList, 2, delim, "");
        }
        return authorList.getAuthor(0).getFamilyName().orElse("") + append;
    }

    private static String authNofMth(AuthorList authorList, int n, int m) {
        int mminusone = m - 1;
        if (authorList.getNumberOfAuthors() <= mminusone || n < 0 || mminusone < 0) {
            return "";
        }
        Author lastAuthor = authorList.getAuthor(mminusone);
        if (lastAuthor.equals(Author.OTHERS)) {
            return "+";
        }
        String lastName = lastAuthor.getFamilyName().map(CitationKeyGenerator::removeDefaultUnwantedCharacters).orElse("");
        return lastName.length() > n ? lastName.substring(0, n) : lastName;
    }

    private static String authN(AuthorList authorList, int num) {
        return BracketedPattern.authNofMth(authorList, num, 1);
    }

    static String authShort(AuthorList authorList) {
        StringBuilder author = new StringBuilder();
        int numberOfAuthors = authorList.getNumberOfAuthors();
        if (numberOfAuthors == 1) {
            author.append(authorList.getAuthor(0).getFamilyName().orElse(""));
        } else if (numberOfAuthors >= 2) {
            for (int i = 0; i < numberOfAuthors && i < 3; ++i) {
                author.append(BracketedPattern.authNofMth(authorList, 1, i + 1));
            }
            if (numberOfAuthors > 3) {
                author.append('+');
            }
        }
        return author.toString();
    }

    static String authIniN(AuthorList authorList, int n) {
        if (n <= 0 || authorList.isEmpty()) {
            return "";
        }
        int numberOfAuthors = authorList.getNumberOfAuthors();
        boolean lastAuthorIsOthers = authorList.getAuthor(numberOfAuthors - 1).equals(Author.OTHERS);
        if (n >= numberOfAuthors && lastAuthorIsOthers) {
            int limit = Math.min(n - 1, numberOfAuthors - 1);
            AuthorList allButOthers = AuthorList.of(authorList.getAuthors().stream().limit(limit).toList());
            return BracketedPattern.authIniN(allButOthers, n - 1) + "+";
        }
        StringBuilder author = new StringBuilder();
        int charsAll = n / numberOfAuthors;
        for (int i = 0; i < numberOfAuthors; ++i) {
            if (i < n % numberOfAuthors) {
                author.append(BracketedPattern.authNofMth(authorList, charsAll + 1, i + 1));
                continue;
            }
            author.append(BracketedPattern.authNofMth(authorList, charsAll, i + 1));
        }
        if (author.length() <= n) {
            return author.toString();
        }
        return author.substring(0, n);
    }

    public static String firstPage(String pages) {
        return NOT_DECIMAL_DIGIT.splitAsStream(pages).filter(Predicate.not(String::isBlank)).map(BigInteger::new).min(BigInteger::compareTo).map(BigInteger::toString).orElse("");
    }

    public static String pagePrefix(String pages) {
        if (pages.matches("^\\D+.*$")) {
            return pages.split("\\d+")[0];
        }
        return "";
    }

    public static String lastPage(String pages) {
        return NOT_DECIMAL_DIGIT.splitAsStream(pages).filter(Predicate.not(String::isBlank)).map(BigInteger::new).max(BigInteger::compareTo).map(BigInteger::toString).orElse("");
    }

    protected static List<String> parseFieldAndModifiers(String arg) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        int inParenthesis = 0;
        for (int i = 0; i < arg.length(); ++i) {
            char currentChar = arg.charAt(i);
            if (currentChar == ':' && !escaped && inParenthesis == 0) {
                parts.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            if (currentChar == '(' && !escaped) {
                ++inParenthesis;
                current.append(currentChar);
                continue;
            }
            if (currentChar == ')' && !escaped && inParenthesis > 0) {
                --inParenthesis;
                current.append(currentChar);
                continue;
            }
            if (currentChar == '\\') {
                if (escaped) {
                    escaped = false;
                    current.append(currentChar);
                    continue;
                }
                escaped = true;
                continue;
            }
            if (escaped) {
                current.append(currentChar);
                escaped = false;
                continue;
            }
            current.append(currentChar);
        }
        parts.add(current.toString());
        return parts;
    }

    private static String generateInstitutionKey(String content) {
        if (content == null) {
            return null;
        }
        if (content.isBlank()) {
            return "";
        }
        Matcher matcher = INLINE_ABBREVIATION.matcher(content);
        if (matcher.find()) {
            return LatexToUnicodeAdapter.format(matcher.group());
        }
        Optional<String> unicodeFormattedName = LatexToUnicodeAdapter.parse(content);
        if (unicodeFormattedName.isEmpty()) {
            LOGGER.warn("{} could not be converted to unicode. This can result in an incorrect or missing institute citation key", (Object)content);
        }
        String result = unicodeFormattedName.orElse(Normalizer.normalize(content, Normalizer.Form.NFC));
        result = StringUtil.replaceSpecialCharacters(result);
        String[] institutionNameTokens = result.split(",");
        String university = null;
        String department = null;
        String school = null;
        String rest = null;
        for (int index = 0; index < institutionNameTokens.length; ++index) {
            List<String> tokenParts = BracketedPattern.getValidInstitutionNameParts(institutionNameTokens[index]);
            EnumSet<Institution> tokenTypes = Institution.findTypes(tokenParts);
            if (tokenTypes.contains((Object)Institution.UNIVERSITY)) {
                StringBuilder universitySB = new StringBuilder();
                universitySB.append("Uni");
                for (String k : tokenParts) {
                    if ("uni".regionMatches(true, 0, k, 0, 3)) continue;
                    universitySB.append(k);
                }
                university = universitySB.toString();
                if (index <= 0 || department != null) continue;
                department = institutionNameTokens[index - 1];
                continue;
            }
            if ((tokenTypes.contains((Object)Institution.SCHOOL) || tokenTypes.contains((Object)Institution.DEPARTMENT)) && institutionNameTokens.length > 1) {
                StringBuilder schoolSB = new StringBuilder();
                StringBuilder departmentSB = new StringBuilder();
                for (String k : tokenParts) {
                    if (!BracketedPattern.noOtherInstitutionKeyWord(k)) continue;
                    if (tokenTypes.contains((Object)Institution.SCHOOL)) {
                        schoolSB.append(NOT_CAPITAL_CHARACTER.matcher(k).replaceAll(""));
                    }
                    if (!tokenTypes.contains((Object)Institution.DEPARTMENT)) continue;
                    departmentSB.append(NOT_CAPITAL_CHARACTER.matcher(k).replaceAll(""));
                }
                if (tokenTypes.contains((Object)Institution.SCHOOL)) {
                    school = schoolSB.toString();
                }
                if (!tokenTypes.contains((Object)Institution.DEPARTMENT)) continue;
                department = departmentSB.toString();
                continue;
            }
            if (rest != null) continue;
            if (tokenParts.size() >= 3) {
                int[] codePoints = tokenParts.stream().filter(Predicate.not(String::isBlank)).mapToInt(s -> s.codePointAt(0)).toArray();
                rest = new String(codePoints, 0, codePoints.length);
                continue;
            }
            rest = String.join((CharSequence)"", tokenParts);
        }
        return (university == null ? Objects.toString(rest, "") : university) + (school == null ? "" : school) + (department == null || school != null && department.equals(school) ? "" : department);
    }

    private static boolean noOtherInstitutionKeyWord(String word) {
        return !DEPARTMENTS.matcher(word).matches() && !StandardField.SCHOOL.getName().equalsIgnoreCase(word) && !"faculty".equalsIgnoreCase(word) && !NOT_CAPITAL_CHARACTER.matcher(word).replaceAll("").isEmpty();
    }

    private static List<String> getValidInstitutionNameParts(String name) {
        ArrayList<String> nameParts = new ArrayList<String>();
        List<String> ignore = Arrays.asList("press", "the");
        for (String part : name.replaceAll("\\{[A-Z]+}", "").split("[ \\-_]")) {
            if ((part.isEmpty() || ignore.contains(part.toLowerCase(Locale.ENGLISH)) || part.charAt(part.length() - 1) == '.' || !Character.isUpperCase(part.charAt(0))) && (part.length() < 3 || !"uni".equalsIgnoreCase(part.substring(0, 3)))) continue;
            nameParts.add(part);
        }
        return nameParts;
    }

    private static enum Institution {
        SCHOOL,
        DEPARTMENT,
        UNIVERSITY,
        TECHNOLOGY;

        private static final Pattern UNIVERSITIES;
        private static final Pattern TECHNOLOGICAL_INSTITUTES;
        private static final Pattern DEPARTMENTS_OR_LABS;

        public static EnumSet<Institution> findTypes(List<String> nameParts) {
            EnumSet<Institution> parts = EnumSet.noneOf(Institution.class);
            for (String namePart : nameParts) {
                if (UNIVERSITIES.matcher(namePart).matches()) {
                    parts.add(UNIVERSITY);
                    continue;
                }
                if (TECHNOLOGICAL_INSTITUTES.matcher(namePart).matches()) {
                    parts.add(TECHNOLOGY);
                    continue;
                }
                if (StandardField.SCHOOL.getName().equalsIgnoreCase(namePart)) {
                    parts.add(SCHOOL);
                    continue;
                }
                if (!DEPARTMENTS_OR_LABS.matcher(namePart).matches()) continue;
                parts.add(DEPARTMENT);
            }
            if (parts.contains((Object)TECHNOLOGY)) {
                parts.remove((Object)UNIVERSITY);
            }
            return parts;
        }

        static {
            UNIVERSITIES = Pattern.compile("^uni(v|b|$).*", 2);
            TECHNOLOGICAL_INSTITUTES = Pattern.compile("^tech.*", 2);
            DEPARTMENTS_OR_LABS = Pattern.compile("^(d[ei]p|lab).*", 2);
        }
    }
}

