/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.cleanup.CleanupJob;
import org.jabref.logic.cleanup.ConvertToBiblatexCleanup;
import org.jabref.logic.cleanup.ConvertToBibtexCleanup;
import org.jabref.logic.cleanup.DoiCleanup;
import org.jabref.logic.cleanup.EprintCleanup;
import org.jabref.logic.cleanup.FileLinksCleanup;
import org.jabref.logic.cleanup.ISSNCleanup;
import org.jabref.logic.cleanup.MoveFilesCleanup;
import org.jabref.logic.cleanup.RelativePathsCleanup;
import org.jabref.logic.cleanup.RemoveLinksToNotExistentFiles;
import org.jabref.logic.cleanup.RenamePdfCleanup;
import org.jabref.logic.cleanup.TimeStampToCreationDate;
import org.jabref.logic.cleanup.TimeStampToModificationDate;
import org.jabref.logic.cleanup.URLCleanup;
import org.jabref.logic.cleanup.UpgradePdfPsToFileCleanup;
import org.jabref.logic.preferences.TimestampPreferences;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.CleanupPreferences;
import org.jabref.preferences.FilePreferences;

public class CleanupWorker {
    private final BibDatabaseContext databaseContext;
    private final FilePreferences filePreferences;
    private final TimestampPreferences timestampPreferences;

    public CleanupWorker(BibDatabaseContext databaseContext, FilePreferences filePreferences, TimestampPreferences timestampPreferences) {
        this.databaseContext = databaseContext;
        this.filePreferences = filePreferences;
        this.timestampPreferences = timestampPreferences;
    }

    public List<FieldChange> cleanup(CleanupPreferences preset, BibEntry entry) {
        Objects.requireNonNull(preset);
        Objects.requireNonNull(entry);
        List<CleanupJob> jobs = this.determineCleanupActions(preset);
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        for (CleanupJob job : jobs) {
            changes.addAll(job.cleanup(entry));
        }
        return changes;
    }

    private List<CleanupJob> determineCleanupActions(CleanupPreferences preset) {
        ArrayList<CleanupJob> jobs = new ArrayList<CleanupJob>();
        for (CleanupPreferences.CleanupStep action : preset.getActiveJobs()) {
            jobs.add(this.toJob(action));
        }
        if (preset.getFieldFormatterCleanups().isEnabled()) {
            jobs.addAll(preset.getFieldFormatterCleanups().getConfiguredActions());
        }
        return jobs;
    }

    private CleanupJob toJob(CleanupPreferences.CleanupStep action) {
        return switch (action) {
            case CleanupPreferences.CleanupStep.CLEAN_UP_DOI -> new DoiCleanup();
            case CleanupPreferences.CleanupStep.CLEANUP_EPRINT -> new EprintCleanup();
            case CleanupPreferences.CleanupStep.CLEAN_UP_URL -> new URLCleanup();
            case CleanupPreferences.CleanupStep.MAKE_PATHS_RELATIVE -> new RelativePathsCleanup(this.databaseContext, this.filePreferences);
            case CleanupPreferences.CleanupStep.RENAME_PDF -> new RenamePdfCleanup(false, this.databaseContext, this.filePreferences);
            case CleanupPreferences.CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS -> new RenamePdfCleanup(true, this.databaseContext, this.filePreferences);
            case CleanupPreferences.CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS -> new UpgradePdfPsToFileCleanup();
            case CleanupPreferences.CleanupStep.CLEAN_UP_DELETED_LINKED_FILES -> new RemoveLinksToNotExistentFiles(this.databaseContext, this.filePreferences);
            case CleanupPreferences.CleanupStep.CONVERT_TO_BIBLATEX -> new ConvertToBiblatexCleanup();
            case CleanupPreferences.CleanupStep.CONVERT_TO_BIBTEX -> new ConvertToBibtexCleanup();
            case CleanupPreferences.CleanupStep.CONVERT_TIMESTAMP_TO_CREATIONDATE -> new TimeStampToCreationDate(this.timestampPreferences);
            case CleanupPreferences.CleanupStep.CONVERT_TIMESTAMP_TO_MODIFICATIONDATE -> new TimeStampToModificationDate(this.timestampPreferences);
            case CleanupPreferences.CleanupStep.MOVE_PDF -> new MoveFilesCleanup(this.databaseContext, this.filePreferences);
            case CleanupPreferences.CleanupStep.FIX_FILE_LINKS -> new FileLinksCleanup();
            case CleanupPreferences.CleanupStep.CLEAN_UP_ISSN -> new ISSNCleanup();
            default -> throw new UnsupportedOperationException(action.name());
        };
    }
}

